/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.messaging.exchange;

import java.io.IOException;
import java.net.URI;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.QName;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.jbi.messaging.exchange.MessageExchangeImpl;
import org.ow2.petals.system.persistence.PersistenceService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageExchangeDecorator
implements MessageExchange {
    private String exchangeId;
    private MessageExchangeImpl messageExchange;
    private MessageExchange.Role observerRole;
    private boolean timeout;
    private PersistenceService persistenceService;

    public MessageExchangeDecorator(MessageExchangeImpl messageExchangeImpl, MessageExchange.Role role) {
        this.messageExchange = messageExchangeImpl;
        this.exchangeId = this.messageExchange.getExchangeId();
        this.observerRole = role;
    }

    public Fault createFault() throws MessagingException {
        this.checkComponentOwnsExchange();
        this.checkExchange();
        return this.messageExchange.createFault();
    }

    public NormalizedMessage createMessage() throws MessagingException {
        this.checkExchange();
        this.checkComponentOwnsExchange();
        return this.messageExchange.createMessage();
    }

    public ServiceEndpoint getConsumerEndpoint() {
        this.checkExchange();
        return this.messageExchange.getConsumerEndpoint();
    }

    public javax.jbi.servicedesc.ServiceEndpoint getEndpoint() {
        this.checkExchange();
        this.checkComponentOwnsExchange();
        return this.messageExchange.getEndpoint();
    }

    public Exception getError() {
        this.checkExchange();
        this.checkComponentOwnsExchange();
        return this.messageExchange.getError();
    }

    public String getExchangeId() {
        return this.exchangeId;
    }

    public Fault getFault() {
        this.checkExchange();
        this.checkComponentOwnsExchange();
        return this.messageExchange.getFault();
    }

    public QName getInterfaceName() {
        this.checkExchange();
        this.checkComponentOwnsExchange();
        return this.messageExchange.getInterfaceName();
    }

    public NormalizedMessage getMessage(String string) {
        this.checkExchange();
        this.checkComponentOwnsExchange();
        return this.messageExchange.getMessage(string);
    }

    public MessageExchangeImpl getMessageExchange() {
        this.checkExchange();
        return this.messageExchange;
    }

    public Map<String, NormalizedMessage> getMessages() {
        this.checkExchange();
        return this.messageExchange.getMessages();
    }

    public MessageExchange.Role getObserverRole() {
        return this.observerRole;
    }

    public QName getOperation() {
        this.checkExchange();
        this.checkComponentOwnsExchange();
        return this.messageExchange.getOperation();
    }

    public URI getPattern() {
        this.checkExchange();
        this.checkComponentOwnsExchange();
        return this.messageExchange.getPattern();
    }

    public Object getProperty(String string) {
        this.checkExchange();
        this.checkComponentOwnsExchange();
        return this.messageExchange.getProperty(string);
    }

    public Set<?> getPropertyNames() {
        this.checkExchange();
        this.checkComponentOwnsExchange();
        return this.messageExchange.getPropertyNames();
    }

    public MessageExchange.Role getRole() {
        this.checkExchange();
        return this.messageExchange.getRole();
    }

    public QName getService() {
        this.checkExchange();
        this.checkComponentOwnsExchange();
        return this.messageExchange.getService();
    }

    public ExchangeStatus getStatus() {
        this.checkExchange();
        return this.messageExchange.getStatus();
    }

    public boolean isMessageExchangeStored() {
        return this.messageExchange == null;
    }

    public boolean isTerminated() {
        this.checkExchange();
        return this.messageExchange.isTerminated();
    }

    public boolean isTimeout() {
        return this.timeout;
    }

    public boolean isTransacted() {
        this.checkExchange();
        this.checkComponentOwnsExchange();
        return this.messageExchange.isTransacted();
    }

    public void persistExchange(PersistenceService persistenceService) throws IOException, SQLException {
        if (this.messageExchange.isPersisted() || this.messageExchange.isMonitored()) {
            persistenceService.updateMessageExchange(this.messageExchange, true, null);
        } else {
            persistenceService.addMessageExchange(this.messageExchange, true, null);
        }
        this.messageExchange = null;
        this.persistenceService = persistenceService;
    }

    public void setEndpoint(javax.jbi.servicedesc.ServiceEndpoint serviceEndpoint) {
        this.checkExchange();
        this.checkComponentOwnsExchange();
        this.messageExchange.setEndpoint(serviceEndpoint);
    }

    public void setError(Exception exception) {
        this.checkExchange();
        this.checkComponentOwnsExchange();
        this.messageExchange.setError(exception);
    }

    public void setFault(Fault fault) throws MessagingException {
        this.checkExchange();
        this.checkComponentOwnsExchange();
        this.messageExchange.setFault(fault);
    }

    public void setInterfaceName(QName qName) {
        this.checkExchange();
        this.checkComponentOwnsExchange();
        this.messageExchange.setInterfaceName(qName);
    }

    public void setMessage(NormalizedMessage normalizedMessage, String string) throws MessagingException {
        this.checkExchange();
        this.checkComponentOwnsExchange();
        this.messageExchange.setMessage(normalizedMessage, string);
    }

    public void setMessageExchange(MessageExchangeImpl messageExchangeImpl) throws MessagingException {
        if (!this.exchangeId.equals(messageExchangeImpl.getExchangeId())) {
            throw new MessagingException("Wrong Message Exchange Id for decorator. Expected Id '" + this.exchangeId + "' and get '" + messageExchangeImpl.getExchangeId() + "'");
        }
        this.messageExchange = messageExchangeImpl;
    }

    public void setObserverRole(MessageExchange.Role role) {
        this.observerRole = role;
    }

    public void setOperation(QName qName) {
        this.checkExchange();
        this.checkComponentOwnsExchange();
        this.messageExchange.setOperation(qName);
    }

    public void setPersisted(boolean bl) {
        this.checkExchange();
        this.messageExchange.setPersisted(bl);
    }

    public void setProperty(String string, Object object) {
        this.checkExchange();
        this.checkComponentOwnsExchange();
        this.messageExchange.setProperty(string, object);
    }

    public void setRole(MessageExchange.Role role) {
        this.checkExchange();
        this.messageExchange.setRole(role);
    }

    public void setService(QName qName) {
        this.checkExchange();
        this.checkComponentOwnsExchange();
        this.messageExchange.setService(qName);
    }

    public void setStatus(ExchangeStatus exchangeStatus) throws MessagingException {
        this.checkExchange();
        this.checkComponentOwnsExchange();
        this.messageExchange.setStatus(exchangeStatus);
    }

    public void setTerminated(boolean bl) {
        this.checkExchange();
        this.messageExchange.setTerminated(bl);
    }

    public void setTimeout(boolean bl) {
        this.timeout = bl;
    }

    public void setTransacted(boolean bl) {
        this.checkExchange();
        this.messageExchange.setTerminated(bl);
    }

    private void checkComponentOwnsExchange() throws IllegalStateException {
        if (this.observerRole != null && !this.messageExchange.getRole().equals(this.observerRole)) {
            if (this.messageExchange.isTerminated()) {
                throw new IllegalStateException("The Message Exchange has been terminated by another component");
            }
            throw new IllegalStateException("The component does not owns the MessageExchange");
        }
    }

    private void checkExchange() throws RuntimeException {
        if (this.messageExchange == null) {
            try {
                this.messageExchange = this.persistenceService.getMessageExchange(this.exchangeId);
            }
            catch (SQLException sQLException) {
                throw new RuntimeException("Failed to retrieve Message Exchange with id '" + this.exchangeId + "' from the persistence service", sQLException);
            }
            catch (IOException iOException) {
                throw new RuntimeException("Failed to retrieve Message Exchange with id '" + this.exchangeId + "' from the persistence service", iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new RuntimeException("Failed to retrieve Message Exchange with id '" + this.exchangeId + "' from the persistence service", classNotFoundException);
            }
        }
    }
}

