/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.messaging.exchange;

import java.net.URI;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOptionalOut;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.RobustInOnly;
import javax.xml.namespace.QName;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfOperation;
import org.ow2.petals.commons.util.IDGenerator;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.jbi.messaging.exchange.DeliveryChannel;
import org.ow2.petals.jbi.messaging.exchange.MessageExchangeDecorator;
import org.ow2.petals.jbi.messaging.exchange.MessageExchangeImpl;
import org.ow2.petals.jbi.messaging.exchange.types.InOnlyImpl;
import org.ow2.petals.jbi.messaging.exchange.types.InOptionalOutImpl;
import org.ow2.petals.jbi.messaging.exchange.types.InOutImpl;
import org.ow2.petals.jbi.messaging.exchange.types.RobustInOnlyImpl;
import org.ow2.petals.util.LoggingUtil;

public class MessageExchangeFactoryImpl
implements MessageExchangeFactory {
    protected DeliveryChannel deliveryChannel;
    protected ServiceEndpoint consumerEndpoint;
    protected QName defaultInterfaceName;
    protected QName defaultServiceName;
    protected javax.jbi.servicedesc.ServiceEndpoint defaultEndpoint;
    protected LoggingUtil log;

    public MessageExchangeFactoryImpl(DeliveryChannel deliveryChannel, ServiceEndpoint serviceEndpoint, Logger logger) {
        this.log = new LoggingUtil(logger);
        this.deliveryChannel = deliveryChannel;
        this.consumerEndpoint = serviceEndpoint;
    }

    public MessageExchangeFactoryImpl(DeliveryChannel deliveryChannel, ServiceEndpoint serviceEndpoint, Logger logger, QName qName, QName qName2, javax.jbi.servicedesc.ServiceEndpoint serviceEndpoint2) {
        this(deliveryChannel, serviceEndpoint, logger);
        this.defaultInterfaceName = qName;
        this.defaultServiceName = qName2;
        this.defaultEndpoint = serviceEndpoint2;
    }

    public MessageExchange createExchange(QName qName, QName qName2) throws MessagingException {
        this.log.call((Object)("Service Name : " + qName + " - operationName : " + qName2));
        MessageExchangeImpl messageExchangeImpl = this.createExchange();
        this.setDefaultMessageExchangeProperties(messageExchangeImpl);
        messageExchangeImpl.setService(qName);
        messageExchangeImpl.setOperation(qName2);
        return new MessageExchangeDecorator(messageExchangeImpl, MessageExchange.Role.CONSUMER);
    }

    public MessageExchange createExchange(URI uRI) throws MessagingException {
        this.log.call((Object)uRI);
        if (!(MessageExchangeImpl.IN_ONLY_PATTERN.equals(uRI) || MessageExchangeImpl.ROBUST_IN_ONLY_PATTERN.equals(uRI) || MessageExchangeImpl.IN_OUT_PATTERN.equals(uRI) || MessageExchangeImpl.IN_OPTIONAL_OUT_PATTERN.equals(uRI) || AbsItfOperation.MEPPatternConstants.IN_ONLY.equals(uRI) || AbsItfOperation.MEPPatternConstants.ROBUST_IN_ONLY.equals(uRI) || AbsItfOperation.MEPPatternConstants.IN_OUT.equals(uRI) || AbsItfOperation.MEPPatternConstants.IN_OPTIONAL_OUT.equals(uRI))) {
            throw new MessagingException("This Message Exchange Pattern is not recognized by JBI.");
        }
        return this.createExchangeDecorator(this.createExchange(), uRI);
    }

    public MessageExchange createExchangeDecorator(MessageExchangeImpl messageExchangeImpl, URI uRI) throws MessagingException {
        this.log.call((Object)uRI);
        if (MessageExchangeImpl.IN_ONLY_PATTERN.equals(uRI) || AbsItfOperation.MEPPatternConstants.IN_ONLY.equals(uRI)) {
            return new InOnlyImpl(messageExchangeImpl, messageExchangeImpl.getRole());
        }
        if (MessageExchangeImpl.ROBUST_IN_ONLY_PATTERN.equals(uRI) || AbsItfOperation.MEPPatternConstants.ROBUST_IN_ONLY.equals(uRI)) {
            return new RobustInOnlyImpl(messageExchangeImpl, messageExchangeImpl.getRole());
        }
        if (MessageExchangeImpl.IN_OUT_PATTERN.equals(uRI) || AbsItfOperation.MEPPatternConstants.IN_OUT.equals(uRI)) {
            return new InOutImpl(messageExchangeImpl, messageExchangeImpl.getRole());
        }
        if (MessageExchangeImpl.IN_OPTIONAL_OUT_PATTERN.equals(uRI) || AbsItfOperation.MEPPatternConstants.IN_OPTIONAL_OUT.equals(uRI)) {
            return new InOptionalOutImpl(messageExchangeImpl, messageExchangeImpl.getRole());
        }
        return new MessageExchangeDecorator(messageExchangeImpl, messageExchangeImpl.getRole());
    }

    public InOnly createInOnlyExchange() throws MessagingException {
        this.log.call();
        MessageExchangeImpl messageExchangeImpl = this.createExchange();
        return new InOnlyImpl(messageExchangeImpl, MessageExchange.Role.CONSUMER);
    }

    public InOptionalOut createInOptionalOutExchange() throws MessagingException {
        this.log.call();
        MessageExchangeImpl messageExchangeImpl = this.createExchange();
        return new InOptionalOutImpl(messageExchangeImpl, MessageExchange.Role.CONSUMER);
    }

    public InOut createInOutExchange() throws MessagingException {
        this.log.call();
        MessageExchangeImpl messageExchangeImpl = this.createExchange();
        return new InOutImpl(messageExchangeImpl, MessageExchange.Role.CONSUMER);
    }

    public RobustInOnly createRobustInOnlyExchange() throws MessagingException {
        this.log.call();
        MessageExchangeImpl messageExchangeImpl = this.createExchange();
        return new RobustInOnlyImpl(messageExchangeImpl, MessageExchange.Role.CONSUMER);
    }

    private final MessageExchangeImpl createExchange() throws MessagingException {
        this.log.call();
        this.deliveryChannel.checkDeliveryChannelIsOpened();
        MessageExchangeImpl messageExchangeImpl = new MessageExchangeImpl(this.consumerEndpoint);
        this.setDefaultMessageExchangeProperties(messageExchangeImpl);
        messageExchangeImpl.setExchangeId(IDGenerator.getInstance().getNewID());
        return messageExchangeImpl;
    }

    private final void setDefaultMessageExchangeProperties(MessageExchangeImpl messageExchangeImpl) {
        this.log.call();
        if (this.defaultInterfaceName != null) {
            messageExchangeImpl.setInterfaceName(this.defaultInterfaceName);
        }
        if (this.defaultServiceName != null) {
            messageExchangeImpl.setService(this.defaultServiceName);
        }
        if (this.defaultEndpoint != null) {
            messageExchangeImpl.setEndpoint(this.defaultEndpoint);
        }
    }
}

