/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.messaging.exchange;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.Fault;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.QName;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfOperation;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.jbi.messaging.exchange.FaultImpl;
import org.ow2.petals.jbi.messaging.exchange.NormalizedMessageImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageExchangeImpl
implements Serializable,
Cloneable,
MessageExchange {
    @Deprecated
    public static final URI IN_ONLY_PATTERN = URI.create("http://www.w3.org/2004/08/wsdl/in-only");
    @Deprecated
    public static final URI IN_OPTIONAL_OUT_PATTERN = URI.create("http://www.w3.org/2004/08/wsdl/in-opt-out");
    @Deprecated
    public static final URI IN_OUT_PATTERN = URI.create("http://www.w3.org/2004/08/wsdl/in-out");
    @Deprecated
    public static final URI ROBUST_IN_ONLY_PATTERN = URI.create("http://www.w3.org/2004/08/wsdl/robust-in-only");
    public static final String IN_MSG = "in";
    public static final String OUT_MSG = "out";
    public static final String FAULT_MSG = "fault";
    public static final short SERIALIZE_ROLE_CONSUMER = 0;
    public static final short SERIALIZE_ROLE_PROVIDER = 1;
    public static final short SERIALIZE_STATUS_ACTIVE = 0;
    public static final short SERIALIZE_STATUS_DONE = 1;
    public static final short SERIALIZE_STATUS_ERROR = 2;
    private static final long serialVersionUID = -4354354L;
    private ServiceEndpoint consumerEndpoint;
    private ServiceEndpoint endpoint;
    private Exception error;
    private String exchangeId;
    private QName interfaceName;
    private Map<String, NormalizedMessage> messages = new HashMap<String, NormalizedMessage>();
    private QName operation;
    private URI pattern;
    private Map<String, Object> properties = new HashMap<String, Object>();
    private QName service;
    private boolean terminated;
    private boolean transacted;
    private boolean persisted;
    private boolean monitored;
    private transient MessageExchange.Role role;
    private transient ExchangeStatus status;

    public MessageExchangeImpl(ServiceEndpoint serviceEndpoint) {
        this.status = ExchangeStatus.ACTIVE;
        this.role = MessageExchange.Role.CONSUMER;
        this.consumerEndpoint = serviceEndpoint;
    }

    public MessageExchangeImpl(String string, ServiceEndpoint serviceEndpoint, ServiceEndpoint serviceEndpoint2, QName qName, QName qName2, QName qName3, String string2, Map<String, Object> map, Map<String, NormalizedMessage> map2, Exception exception, short s, short s2, boolean bl, boolean bl2, boolean bl3, boolean bl4) throws URISyntaxException {
        this.exchangeId = string;
        this.consumerEndpoint = serviceEndpoint;
        this.endpoint = serviceEndpoint2;
        this.interfaceName = qName;
        this.service = qName2;
        this.operation = qName3;
        this.pattern = new URI(string2);
        this.properties = map;
        this.messages = map2;
        this.error = exception;
        this.role = s == 0 ? MessageExchange.Role.CONSUMER : MessageExchange.Role.PROVIDER;
        this.status = s2 == 0 ? ExchangeStatus.ACTIVE : (s2 == 1 ? ExchangeStatus.DONE : ExchangeStatus.ERROR);
        this.terminated = bl;
        this.transacted = bl2;
        this.monitored = bl3;
        this.persisted = bl4;
    }

    public void cleanMessages() {
        if (!ExchangeStatus.ACTIVE.equals(this.status)) {
            this.messages.clear();
        }
        if (this.messages.containsKey(FAULT_MSG) && this.messages.remove(IN_MSG) == null) {
            this.messages.remove(OUT_MSG);
        }
        if (this.messages.containsKey(OUT_MSG)) {
            this.messages.remove(IN_MSG);
        }
    }

    public Fault createFault() throws MessagingException {
        return new FaultImpl();
    }

    public NormalizedMessage createMessage() throws MessagingException {
        return new NormalizedMessageImpl();
    }

    public ServiceEndpoint getConsumerEndpoint() {
        return this.consumerEndpoint;
    }

    public javax.jbi.servicedesc.ServiceEndpoint getEndpoint() {
        return this.endpoint;
    }

    public Exception getError() {
        return this.error;
    }

    public String getExchangeId() {
        return this.exchangeId;
    }

    public Fault getFault() {
        return (Fault)this.getMessage(FAULT_MSG);
    }

    public QName getInterfaceName() {
        return this.interfaceName;
    }

    public NormalizedMessage getMessage(String string) {
        if (string != null) {
            return this.messages.get(string.toLowerCase());
        }
        return null;
    }

    public Map<String, NormalizedMessage> getMessages() {
        return this.messages;
    }

    public QName getOperation() {
        return this.operation;
    }

    public URI getPattern() {
        String string = null;
        Package package_ = Package.getPackage("org.ow2.petals.cdk");
        if (package_ != null) {
            string = package_.getImplementationVersion();
        }
        if (string != null && "5.1".compareTo(string) <= 0) {
            return this.pattern;
        }
        if (AbsItfOperation.MEPPatternConstants.IN_ONLY.equals(this.pattern)) {
            return IN_ONLY_PATTERN;
        }
        if (AbsItfOperation.MEPPatternConstants.ROBUST_IN_ONLY.equals(this.pattern)) {
            return ROBUST_IN_ONLY_PATTERN;
        }
        if (AbsItfOperation.MEPPatternConstants.IN_OUT.equals(this.pattern)) {
            return IN_OUT_PATTERN;
        }
        if (AbsItfOperation.MEPPatternConstants.IN_OPTIONAL_OUT.equals(this.pattern)) {
            return IN_OPTIONAL_OUT_PATTERN;
        }
        return null;
    }

    public Object getProperty(String string) {
        return this.properties.get(string);
    }

    public Set<?> getPropertyNames() {
        return this.properties.keySet();
    }

    public MessageExchange.Role getRole() {
        return this.role;
    }

    public QName getService() {
        return this.service;
    }

    public ServiceEndpoint getServiceEndpoint() {
        return this.endpoint;
    }

    public ExchangeStatus getStatus() {
        return this.status;
    }

    public boolean isMonitored() {
        return this.monitored;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public void setConsumerEndpoint(ServiceEndpoint serviceEndpoint) {
        this.consumerEndpoint = serviceEndpoint;
    }

    public void setEndpoint(javax.jbi.servicedesc.ServiceEndpoint serviceEndpoint) {
        this.endpoint = (ServiceEndpoint)serviceEndpoint;
    }

    public void setError(Exception exception) {
        this.error = exception;
        try {
            this.setStatus(ExchangeStatus.ERROR);
        }
        catch (MessagingException messagingException) {}
    }

    public void setExchangeId(String string) {
        this.exchangeId = string;
    }

    public void setFault(Fault fault) throws MessagingException {
        this.checkNotTerminated();
        if (this.role == null) {
            throw new MessagingException("The Role is not defined.");
        }
        if (ExchangeStatus.DONE.equals(this.status) || ExchangeStatus.ERROR.equals(this.status)) {
            throw new MessagingException("The MessageExchange state and the current Role do not allow this operation.");
        }
        if (!(!MessageExchange.Role.CONSUMER.equals(this.role) || IN_OPTIONAL_OUT_PATTERN.equals(this.pattern) && this.messages.containsKey(OUT_MSG))) {
            throw new MessagingException("The MessageExchange state and the current Role do not allow this operation.");
        }
        this.messages.put(FAULT_MSG, (NormalizedMessage)fault);
    }

    public void setInterfaceName(QName qName) {
        this.interfaceName = qName;
    }

    public void setMessage(NormalizedMessage normalizedMessage, String string) throws MessagingException {
        this.checkNotTerminated();
        if (normalizedMessage == null) {
            throw new MessagingException("NormalizedMessage must be non null.");
        }
        if (string == null || string.trim().length() == 0) {
            throw new MessagingException("The message reference must be non null and non empty.");
        }
        this.checkPatternMatching(string);
        this.checkRoleMatching(string);
        if (this.messages.containsKey(string.toLowerCase())) {
            throw new MessagingException("A message has already been set with the '" + string + "' reference.");
        }
        this.messages.put(string.toLowerCase(), normalizedMessage);
    }

    public void setMonitored(boolean bl) {
        this.monitored = bl;
    }

    public void setOperation(QName qName) {
        this.operation = qName;
    }

    public void setPattern(URI uRI) {
        this.pattern = uRI;
    }

    public void setPersisted(boolean bl) {
        this.persisted = bl;
    }

    public void setProperty(String string, Object object) {
        this.properties.put(string, object);
    }

    public void setRole(MessageExchange.Role role) {
        this.role = role;
    }

    public void setService(QName qName) {
        this.service = qName;
    }

    public void setStatus(ExchangeStatus exchangeStatus) throws MessagingException {
        this.checkNotTerminated();
        if (ExchangeStatus.DONE.equals(exchangeStatus)) {
            if (MessageExchange.Role.CONSUMER.equals(this.role)) {
                if (IN_ONLY_PATTERN.equals(this.pattern) || AbsItfOperation.MEPPatternConstants.IN_ONLY.equals(this.pattern)) {
                    throw new MessagingException("The MessageExchange state does not allow this operation.");
                }
                if ((IN_OUT_PATTERN.equals(this.pattern) || AbsItfOperation.MEPPatternConstants.IN_OUT.equals(this.pattern)) && !this.messages.containsKey(FAULT_MSG) && !this.messages.containsKey(OUT_MSG)) {
                    throw new MessagingException("The MessageExchange state does not allow this operation.");
                }
                if ((IN_OPTIONAL_OUT_PATTERN.equals(this.pattern) || AbsItfOperation.MEPPatternConstants.IN_OPTIONAL_OUT.equals(this.pattern)) && !this.messages.containsKey(FAULT_MSG) && !this.messages.containsKey(OUT_MSG)) {
                    throw new MessagingException("The MessageExchange state does not allow this operation.");
                }
            } else {
                if ((ROBUST_IN_ONLY_PATTERN.equals(this.pattern) || AbsItfOperation.MEPPatternConstants.IN_ONLY.equals(this.pattern)) && this.messages.containsKey(FAULT_MSG)) {
                    throw new MessagingException("The MessageExchange state does not allow this operation.");
                }
                if (IN_OUT_PATTERN.equals(this.pattern) || AbsItfOperation.MEPPatternConstants.IN_OUT.equals(this.pattern)) {
                    throw new MessagingException("The MessageExchange state does not allow this operation.");
                }
                if (IN_OPTIONAL_OUT_PATTERN.equals(this.pattern) || AbsItfOperation.MEPPatternConstants.IN_OPTIONAL_OUT.equals(this.pattern)) {
                    if (this.messages.containsKey(FAULT_MSG) && !this.messages.containsKey(OUT_MSG)) {
                        throw new MessagingException("The MessageExchange state does not allow this operation.");
                    }
                    if (!this.messages.containsKey(FAULT_MSG) && this.messages.containsKey(OUT_MSG)) {
                        throw new MessagingException("The MessageExchange state does not allow this operation.");
                    }
                }
            }
        } else if (ExchangeStatus.ERROR.equals(exchangeStatus) && MessageExchange.Role.PROVIDER.equals(this.role) && (IN_OUT_PATTERN.equals(this.pattern) || AbsItfOperation.MEPPatternConstants.IN_OUT.equals(this.pattern))) {
            throw new MessagingException("The MessageExchange state does not allow this operation.");
        }
        this.status = exchangeStatus;
    }

    public void setTerminated(boolean bl) {
        this.terminated = bl;
    }

    public void setTransacted(boolean bl) {
        this.transacted = bl;
    }

    public String toString() {
        return "MessageExchange@" + this.getExchangeId();
    }

    protected void checkNotTerminated() throws MessagingException {
        if (this.isTerminated()) {
            throw new MessagingException("The Exchange is terminated.");
        }
    }

    protected void checkPatternMatching(String string) throws MessagingException {
        if (this.pattern == null) {
            throw new MessagingException("The MEP is not defined.");
        }
        if (string == null) {
            throw new MessagingException("The reference name is not defined.");
        }
        if (IN_MSG.equalsIgnoreCase(string) && (IN_ONLY_PATTERN.equals(this.pattern) || ROBUST_IN_ONLY_PATTERN.equals(this.pattern) || IN_OUT_PATTERN.equals(this.pattern) || IN_OPTIONAL_OUT_PATTERN.equals(this.pattern) || AbsItfOperation.MEPPatternConstants.IN_ONLY.equals(this.pattern) || AbsItfOperation.MEPPatternConstants.ROBUST_IN_ONLY.equals(this.pattern) || AbsItfOperation.MEPPatternConstants.IN_OUT.equals(this.pattern) || AbsItfOperation.MEPPatternConstants.IN_OPTIONAL_OUT.equals(this.pattern))) {
            return;
        }
        if (OUT_MSG.equalsIgnoreCase(string) && (IN_OUT_PATTERN.equals(this.pattern) || IN_OPTIONAL_OUT_PATTERN.equals(this.pattern) || AbsItfOperation.MEPPatternConstants.IN_OUT.equals(this.pattern) || AbsItfOperation.MEPPatternConstants.IN_OPTIONAL_OUT.equals(this.pattern))) {
            return;
        }
        throw new MessagingException("the MessageExchange state does not allow this operation.");
    }

    protected void checkRoleMatching(String string) throws MessagingException {
        if (this.role == null) {
            throw new MessagingException("the Role is not defined.");
        }
        if (string == null) {
            throw new MessagingException("The reference name is not defined.");
        }
        if (MessageExchange.Role.CONSUMER.equals(this.role) ? IN_MSG.equalsIgnoreCase(string) : MessageExchange.Role.PROVIDER.equals(this.role) && OUT_MSG.equalsIgnoreCase(string)) {
            return;
        }
        throw new MessagingException("The Role does not allow this operation.");
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        switch (objectInputStream.readShort()) {
            case 0: {
                this.role = MessageExchange.Role.CONSUMER;
                break;
            }
            case 1: {
                this.role = MessageExchange.Role.PROVIDER;
                break;
            }
        }
        switch (objectInputStream.readShort()) {
            case 0: {
                this.status = ExchangeStatus.ACTIVE;
                break;
            }
            case 1: {
                this.status = ExchangeStatus.DONE;
                break;
            }
            case 2: {
                this.status = ExchangeStatus.ERROR;
                break;
            }
        }
        try {
            objectInputStream.defaultReadObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException(classNotFoundException.getClass() + ":" + classNotFoundException.getMessage());
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        if (MessageExchange.Role.CONSUMER.equals(this.role)) {
            objectOutputStream.writeShort(0);
        } else {
            objectOutputStream.writeShort(1);
        }
        if (ExchangeStatus.ACTIVE.equals(this.status)) {
            objectOutputStream.writeShort(0);
        } else if (ExchangeStatus.DONE.equals(this.status)) {
            objectOutputStream.writeShort(1);
        } else {
            objectOutputStream.writeShort(2);
        }
        objectOutputStream.defaultWriteObject();
    }
}

