/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.messaging.exchange;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.util.ByteArrayDataSource;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.ow2.petals.commons.threadlocal.Transformers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageExchangeSerializer {
    private MessageExchangeSerializer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void serializeContent(Source source, ObjectOutputStream objectOutputStream, boolean bl) throws Exception {
        if (source == null) {
            objectOutputStream.writeBoolean(false);
            return;
        }
        objectOutputStream.writeBoolean(true);
        Source source2 = source;
        synchronized (source2) {
            StreamResult streamResult = null;
            GZIPOutputStream gZIPOutputStream = null;
            if (bl) {
                gZIPOutputStream = new GZIPOutputStream(objectOutputStream);
                streamResult = new StreamResult(gZIPOutputStream);
            } else {
                streamResult = new StreamResult(objectOutputStream);
            }
            Transformer transformer = Transformers.getDefaultTransformer();
            try {
                transformer.transform(source, streamResult);
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                transformer.reset();
                throw throwable;
            }
            {
                Object var7_9 = null;
                transformer.reset();
                if (!bl) return;
            }
            gZIPOutputStream.finish();
            return;
        }
    }

    public static final Source deserializeContent(ObjectInputStream objectInputStream, boolean bl) throws IOException {
        StreamSource streamSource = null;
        if (objectInputStream.readBoolean()) {
            streamSource = new StreamSource();
            InputStream inputStream = objectInputStream;
            if (bl) {
                inputStream = new GZIPInputStream(objectInputStream);
            }
            byte[] byArray = new byte[4098];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n = 0;
            while (-1 != (n = inputStream.read(byArray))) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            streamSource.setInputStream(byteArrayInputStream);
        }
        return streamSource;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void serializeAttachments(Map<String, DataHandler> map, ObjectOutputStream objectOutputStream) throws Exception {
        objectOutputStream.writeInt(map.size());
        Iterator<Map.Entry<String, DataHandler>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Object var8_8;
            Map.Entry<String, DataHandler> entry = iterator.next();
            InputStream inputStream = entry.getValue().getInputStream();
            try {
                int n = inputStream.available();
                objectOutputStream.writeUTF(entry.getKey());
                objectOutputStream.writeUTF(entry.getValue().getContentType());
                objectOutputStream.writeUTF(entry.getValue().getName());
                objectOutputStream.writeInt(n);
                byte[] byArray = new byte[4097];
                int n2 = 0;
                while (-1 != (n2 = inputStream.read(byArray))) {
                    objectOutputStream.write(byArray, 0, n2);
                    objectOutputStream.flush();
                }
            }
            catch (Throwable throwable) {
                var8_8 = null;
                inputStream.close();
                throw throwable;
            }
            {
                var8_8 = null;
            }
            inputStream.close();
        }
        return;
    }

    public static final Map<String, DataHandler> deserializeAttachments(ObjectInputStream objectInputStream) throws IOException {
        HashMap<String, DataHandler> hashMap = new HashMap<String, DataHandler>();
        int n = objectInputStream.readInt();
        int n2 = 0;
        while (n2 < n) {
            String string = objectInputStream.readUTF();
            String string2 = objectInputStream.readUTF();
            String string3 = objectInputStream.readUTF();
            int n3 = objectInputStream.readInt();
            byte[] byArray = new byte[n3];
            objectInputStream.readFully(byArray);
            ByteArrayDataSource byteArrayDataSource = new ByteArrayDataSource(byArray, string2);
            byteArrayDataSource.setName(string3);
            DataHandler dataHandler = new DataHandler((DataSource)byteArrayDataSource);
            hashMap.put(string, dataHandler);
            ++n2;
        }
        return hashMap;
    }
}

