/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.messaging.exchange;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.security.auth.Subject;
import javax.xml.transform.Source;
import org.ow2.petals.jbi.messaging.exchange.MessageExchangeSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NormalizedMessageImpl
implements Serializable,
NormalizedMessage {
    public static final String PROPERTY_COMPRESSION = "org.ow2.petals.transport.compress";
    private static final long serialVersionUID = 45438732L;
    protected transient Map<String, DataHandler> attachments;
    protected transient Source content = null;
    protected Map<String, Object> properties = new HashMap<String, Object>();
    protected Subject subject;

    public NormalizedMessageImpl() {
        this.attachments = new HashMap<String, DataHandler>();
    }

    public void addAttachment(String string, DataHandler dataHandler) throws MessagingException {
        this.attachments.put(string, dataHandler);
    }

    public DataHandler getAttachment(String string) {
        return this.attachments.get(string);
    }

    public Set<?> getAttachmentNames() {
        return this.attachments.keySet();
    }

    public Source getContent() {
        return this.content;
    }

    public Object getProperty(String string) {
        return this.properties.get(string);
    }

    public Set<?> getPropertyNames() {
        return this.properties.keySet();
    }

    public Subject getSecuritySubject() {
        return this.subject;
    }

    public void removeAttachment(String string) throws MessagingException {
        DataHandler dataHandler = this.attachments.remove(string);
        if (dataHandler == null) {
            throw new MessagingException(String.valueOf(string) + " attachment does not exist.");
        }
    }

    public void setContent(Source source) throws MessagingException {
        this.content = source;
    }

    public void setProperty(String string, Object object) {
        if (object == null) {
            this.properties.remove(string);
        } else {
            this.properties.put(string, object);
        }
    }

    public void setSecuritySubject(Subject subject) {
        this.subject = subject;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
            this.attachments = MessageExchangeSerializer.deserializeAttachments(objectInputStream);
            String string = (String)this.getProperty(PROPERTY_COMPRESSION);
            this.content = MessageExchangeSerializer.deserializeContent(objectInputStream, Boolean.valueOf(string));
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException(classNotFoundException.getClass() + ":" + classNotFoundException.getMessage());
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        try {
            MessageExchangeSerializer.serializeAttachments(this.attachments, objectOutputStream);
            String string = (String)this.getProperty(PROPERTY_COMPRESSION);
            MessageExchangeSerializer.serializeContent(this.content, objectOutputStream, Boolean.parseBoolean(string));
        }
        catch (Exception exception) {
            throw (IOException)new IOException(exception.getMessage()).initCause(exception);
        }
    }
}

