/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.messaging.routing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.xml.namespace.QName;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.Cardinality;
import org.objectweb.fractal.fraclet.annotation.annotations.type.Contingency;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.container.lifecycle.ServiceUnitLifeCycle;
import org.ow2.petals.jbi.component.context.ComponentContext;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.jbi.messaging.exchange.MessageExchangeDecorator;
import org.ow2.petals.jbi.messaging.routing.RouterService;
import org.ow2.petals.jbi.messaging.routing.RoutingException;
import org.ow2.petals.jbi.messaging.routing.module.InstallModule;
import org.ow2.petals.jbi.messaging.routing.module.ReceiverModule;
import org.ow2.petals.jbi.messaging.routing.module.SenderModule;
import org.ow2.petals.jbi.messaging.routing.monitoring.RouterMonitorService;
import org.ow2.petals.jbi.messaging.routing.util.SourcesForkerUtil;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.kernel.configuration.ContainerConfiguration;
import org.ow2.petals.transport.TransportException;
import org.ow2.petals.transport.TransportListener;
import org.ow2.petals.transport.Transporter;
import org.ow2.petals.transport.util.TransportSendContext;
import org.ow2.petals.util.LoggingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=RouterService.class), @Interface(name="transportlistener", signature=TransportListener.class)})
public class RouterServiceImpl
implements BindingController,
LifeCycleController,
RouterService,
TransportListener {
    private LoggerFactory loggerFactory;
    private static final String INSTALLMODULE_FRACTAL_PREFIX = "installmodule";
    private static final String PROVIDER_SUFFIX = "-provider";
    private static final String RECEIVERMODULE_FRACTAL_PREFIX = "receivermodule";
    private static final String SENDERMODULE_FRACTAL_PREFIX = "sendermodule";
    private static final int STOP_TRAFFIC_TIMEOUT = 10000;
    private static final String TRANSPORTER_FRACTAL_PREFIX = "transporter";
    private Map<String, BlockingQueue<MessageExchangeDecorator>> exchangeQueues;
    @Requires(name="configuration", signature=ConfigurationService.class)
    private ConfigurationService configurationService;
    @Requires(name="routermonitor", signature=RouterMonitorService.class)
    private RouterMonitorService routerMonitorService;
    @Requires(cardinality=Cardinality.COLLECTION, contingency=Contingency.OPTIONAL, name="installmodule", signature=InstallModule.class)
    private final Map<String, Object> installModules = new Hashtable<String, Object>();
    private LoggingUtil log;
    private Logger logger;
    private Map<String, List<MessageExchangeDecorator>> pendingMessageExchanges;
    @Requires(cardinality=Cardinality.COLLECTION, contingency=Contingency.OPTIONAL, name="receivermodule", signature=ReceiverModule.class)
    private final Map<String, Object> receiverModules = new Hashtable<String, Object>();
    @Requires(cardinality=Cardinality.COLLECTION, contingency=Contingency.OPTIONAL, name="sendermodule", signature=SenderModule.class)
    private final Map<String, Object> senderModules = new Hashtable<String, Object>();
    private boolean stopTraffic;
    private List<Thread> threadsList;
    @Requires(cardinality=Cardinality.COLLECTION, contingency=Contingency.OPTIONAL, name="transporter", signature=Transporter.class)
    private final Map<String, Object> transporters = new Hashtable<String, Object>();
    long transporterQueueOfferingTimeout;

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    private static final boolean checkBypassMessageExchange(MessageExchangeDecorator messageExchangeDecorator) {
        boolean bl = false;
        Object object = null;
        if (messageExchangeDecorator.isTerminated()) {
            object = MessageExchange.Role.CONSUMER.equals(messageExchangeDecorator.getRole()) ? messageExchangeDecorator.getProperty("org.ow2.petals.router.provider.noack") : messageExchangeDecorator.getProperty("org.ow2.petals.router.consumer.noack");
            bl = object != null && object.toString().toLowerCase().equals("true");
        }
        return bl;
    }

    @Override
    public void addComponent(ComponentContext componentContext) throws RoutingException {
        Object object2;
        this.log.start();
        for (Object object2 : this.installModules.values()) {
            ((InstallModule)object2).addComponent(componentContext);
        }
        object2 = this.configurationService.getContainerConfiguration();
        int n = ((ContainerConfiguration)object2).getTransporterQueueMaxSize();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Using a queue bounded to " + n + " for component '" + componentContext.getComponentName() + "'."));
        }
        this.exchangeQueues.put(componentContext.getComponentName(), new ArrayBlockingQueue(n));
        this.log.end();
    }

    @Override
    public void exchangeSent(MessageExchangeDecorator messageExchangeDecorator) {
        this.routerMonitorService.exchangeSent(messageExchangeDecorator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifiedSALifeCycle(List<ServiceUnitLifeCycle> list) {
        this.log.start();
        Map<String, List<MessageExchangeDecorator>> map = this.pendingMessageExchanges;
        synchronized (map) {
            for (ServiceUnitLifeCycle serviceUnitLifeCycle : list) {
                List list2 = serviceUnitLifeCycle.getServiceUnitDescriptor().getServices().getProvides();
                if (list2 == null) continue;
                String string = serviceUnitLifeCycle.getCurrentState();
                for (org.ow2.petals.jbi.descriptor.original.generated.Provides provides : list2) {
                    String string2 = String.valueOf(provides.getEndpointName()) + provides.getServiceName() + PROVIDER_SUFFIX;
                    if ("Stopped".equals(string) || "Shutdown".equals(string)) {
                        if (this.pendingMessageExchanges.containsKey(string2)) continue;
                        this.pendingMessageExchanges.put(string2, new Vector(100));
                        continue;
                    }
                    if (!"Started".equals(string)) continue;
                    BlockingQueue<MessageExchangeDecorator> blockingQueue = this.exchangeQueues.get(serviceUnitLifeCycle.getTargetComponentName());
                    blockingQueue.addAll((Collection<MessageExchangeDecorator>)this.pendingMessageExchanges.remove(string2));
                }
            }
        }
        this.log.end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onExchange(MessageExchangeDecorator messageExchangeDecorator) {
        this.log.start();
        String string = null;
        this.routerMonitorService.exchangeReceived(messageExchangeDecorator);
        Map<String, List<MessageExchangeDecorator>> map = this.pendingMessageExchanges;
        synchronized (map) {
            if (messageExchangeDecorator.getRole().equals(MessageExchange.Role.CONSUMER)) {
                string = messageExchangeDecorator.getConsumerEndpoint().getLocation().getComponentName();
            } else if (messageExchangeDecorator.getRole().equals(MessageExchange.Role.PROVIDER)) {
                ServiceEndpoint serviceEndpoint = (ServiceEndpoint)messageExchangeDecorator.getEndpoint();
                String string2 = String.valueOf(serviceEndpoint.getEndpointName()) + serviceEndpoint.getServiceName() + PROVIDER_SUFFIX;
                List<MessageExchangeDecorator> list = this.pendingMessageExchanges.get(string2);
                if (list != null) {
                    this.log.debug((Object)"SU not started, store the exchange");
                    list.add(messageExchangeDecorator);
                } else {
                    string = ((ServiceEndpoint)messageExchangeDecorator.getEndpoint()).getLocation().getComponentName();
                }
            }
        }
        if (string != null) {
            try {
                this.exchangeQueues.get(string).offer(messageExchangeDecorator, this.transporterQueueOfferingTimeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                this.log.error((Object)"A message exchange has been lost because of exhaustion of the component transporter queue.");
            }
        }
        this.log.end();
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configurationService = (ConfigurationService)object;
            return;
        }
        if (string.equals("routermonitor")) {
            if (!RouterMonitorService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + RouterMonitorService.class.getName());
            }
            this.routerMonitorService = (RouterMonitorService)object;
            return;
        }
        if (string.startsWith(INSTALLMODULE_FRACTAL_PREFIX)) {
            if (!InstallModule.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + InstallModule.class.getName());
            }
            this.installModules.put(string, object);
            return;
        }
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.startsWith(RECEIVERMODULE_FRACTAL_PREFIX)) {
            if (!ReceiverModule.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ReceiverModule.class.getName());
            }
            this.receiverModules.put(string, object);
            return;
        }
        if (string.startsWith(SENDERMODULE_FRACTAL_PREFIX)) {
            if (!SenderModule.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + SenderModule.class.getName());
            }
            this.senderModules.put(string, object);
            return;
        }
        if (string.startsWith(TRANSPORTER_FRACTAL_PREFIX)) {
            if (!Transporter.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + Transporter.class.getName());
            }
            this.transporters.put(string, object);
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("configuration");
        arrayList.add("routermonitor");
        arrayList.addAll((Collection)this.installModules.keySet());
        arrayList.addAll((Collection)this.receiverModules.keySet());
        arrayList.addAll((Collection)this.senderModules.keySet());
        arrayList.addAll((Collection)this.transporters.keySet());
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        if (string.equals("routermonitor")) {
            return this.routerMonitorService;
        }
        if (string.startsWith(string)) {
            return this.installModules.get(string);
        }
        if (string.startsWith(string)) {
            return this.receiverModules.get(string);
        }
        if (string.startsWith(string)) {
            return this.senderModules.get(string);
        }
        if (string.startsWith(string)) {
            return this.transporters.get(string);
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public MessageExchangeDecorator receive(ComponentContext componentContext, long l) throws RoutingException {
        Iterator<Object> iterator;
        MessageExchangeDecorator messageExchangeDecorator;
        String string;
        block9: {
            block8: {
                string = componentContext.getComponentName();
                this.log.start((Object)("Component : " + string + " - Timeout : " + l));
                this.checkStopTraffic();
                if (l != 0L) break block8;
                messageExchangeDecorator = (MessageExchangeDecorator)this.exchangeQueues.get(string).poll();
                break block9;
            }
            this.threadsList.add(Thread.currentThread());
            try {
                try {
                    messageExchangeDecorator = l > 0L ? this.exchangeQueues.get(string).poll(l, TimeUnit.MILLISECONDS) : this.exchangeQueues.get(string).take();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    throw new RoutingException("The pending receipt for the component '" + string + "' is interrupted", interruptedException);
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.threadsList.remove(Thread.currentThread());
                throw throwable;
            }
            {
                iterator = null;
                this.threadsList.remove(Thread.currentThread());
            }
        }
        if (messageExchangeDecorator == null) {
            this.log.end((Object)("No exchange - Component : " + string));
            return messageExchangeDecorator;
        }
        iterator = this.receiverModules.values().iterator();
        while (true) {
            if (!iterator.hasNext()) {
                messageExchangeDecorator.setObserverRole(messageExchangeDecorator.getRole());
                this.log.end((Object)("Exchange Id : " + messageExchangeDecorator.getExchangeId() + " - Component : " + string));
                return messageExchangeDecorator;
            }
            Object object = iterator.next();
            ((ReceiverModule)object).receiveExchange(messageExchangeDecorator, componentContext);
        }
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        if (string.equals("routermonitor")) {
            this.routerMonitorService = null;
            return;
        }
        if (this.installModules.containsKey(string)) {
            this.installModules.remove(string);
            return;
        }
        if (this.receiverModules.containsKey(string)) {
            this.receiverModules.remove(string);
            return;
        }
        if (this.senderModules.containsKey(string)) {
            this.senderModules.remove(string);
            return;
        }
        if (this.transporters.containsKey(string)) {
            this.transporters.remove(string);
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    @Override
    public void removeComponent(ComponentContext componentContext) throws RoutingException {
        this.log.start();
        for (Object object : this.installModules.values()) {
            ((InstallModule)object).removeComponent(componentContext);
        }
        this.exchangeQueues.remove(componentContext.getComponentName());
        this.log.end();
    }

    @Override
    public void send(ComponentContext componentContext, MessageExchangeDecorator messageExchangeDecorator) throws RoutingException {
        this.log.call();
        this.checkStopTraffic();
        if (!RouterServiceImpl.checkBypassMessageExchange(messageExchangeDecorator)) {
            messageExchangeDecorator.getMessageExchange().cleanMessages();
            LinkedHashMap<ServiceEndpoint, TransportSendContext> linkedHashMap = new LinkedHashMap<ServiceEndpoint, TransportSendContext>();
            for (Object object : this.senderModules.values()) {
                ((SenderModule)object).electEndpoints(linkedHashMap, componentContext, messageExchangeDecorator);
            }
            boolean bl = false;
            try {
                messageExchangeDecorator.setObserverRole(null);
                if (MessageExchange.Role.CONSUMER.equals(messageExchangeDecorator.getRole())) {
                    messageExchangeDecorator.setRole(MessageExchange.Role.PROVIDER);
                    bl = this.sendToProvider(linkedHashMap, componentContext, messageExchangeDecorator, false, 0L);
                } else {
                    messageExchangeDecorator.setRole(MessageExchange.Role.CONSUMER);
                    TransportSendContext transportSendContext = (TransportSendContext)linkedHashMap.values().iterator().next();
                    bl = this.sendToConsumer(transportSendContext, messageExchangeDecorator, false, 0L);
                }
                if (!bl) {
                    messageExchangeDecorator.setObserverRole(messageExchangeDecorator.getRole());
                }
            }
            catch (RoutingException routingException) {
                if (MessageExchange.Role.CONSUMER.equals(messageExchangeDecorator.getRole())) {
                    messageExchangeDecorator.setRole(MessageExchange.Role.PROVIDER);
                    messageExchangeDecorator.setObserverRole(MessageExchange.Role.PROVIDER);
                } else {
                    messageExchangeDecorator.setRole(MessageExchange.Role.CONSUMER);
                    messageExchangeDecorator.setObserverRole(MessageExchange.Role.CONSUMER);
                }
                throw routingException;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void sendSync(ComponentContext componentContext, MessageExchangeDecorator messageExchangeDecorator, long l) throws RoutingException {
        this.log.call();
        this.checkStopTraffic();
        messageExchangeDecorator.getMessageExchange().cleanMessages();
        this.removeBypassMessageExchange(messageExchangeDecorator);
        long l2 = 0L;
        if (l > 0L) {
            l2 = System.currentTimeMillis();
            messageExchangeDecorator.setProperty("org.ow2.petals.router.timetolive", l2 + l);
        }
        LinkedHashMap<ServiceEndpoint, TransportSendContext> linkedHashMap = new LinkedHashMap<ServiceEndpoint, TransportSendContext>();
        for (Object object : this.senderModules.values()) {
            ((SenderModule)object).electEndpoints(linkedHashMap, componentContext, messageExchangeDecorator);
        }
        long l3 = l;
        if (l3 > 0L && (l3 -= System.currentTimeMillis() - l2) == 0L) {
            l3 = -1L;
        }
        if (l3 < 0L) {
            messageExchangeDecorator.setTimeout(true);
            return;
        }
        MessageExchange.Role role = messageExchangeDecorator.getRole();
        try {
            messageExchangeDecorator.setObserverRole(null);
            if (MessageExchange.Role.CONSUMER.equals(messageExchangeDecorator.getRole())) {
                messageExchangeDecorator.setRole(MessageExchange.Role.PROVIDER);
                this.sendToProvider(linkedHashMap, componentContext, messageExchangeDecorator, true, l);
            } else {
                messageExchangeDecorator.setRole(MessageExchange.Role.CONSUMER);
                Object object = (TransportSendContext)linkedHashMap.values().iterator().next();
                this.sendToConsumer((TransportSendContext)object, messageExchangeDecorator, true, l);
            }
            if (!messageExchangeDecorator.isTimeout()) {
                this.routerMonitorService.exchangeReceived(messageExchangeDecorator);
                for (Object object : this.receiverModules.values()) {
                    ((ReceiverModule)object).receiveExchange(messageExchangeDecorator, componentContext);
                }
            }
            Object var13_14 = null;
            messageExchangeDecorator.setRole(role);
            messageExchangeDecorator.setObserverRole(role);
            return;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            messageExchangeDecorator.setRole(role);
            messageExchangeDecorator.setObserverRole(role);
            throw throwable;
        }
    }

    @Override
    public void stopTraffic() {
        this.log.start();
        long l = 10000L + System.currentTimeMillis();
        boolean bl = false;
        try {
            while (System.currentTimeMillis() < l && !bl) {
                for (BlockingQueue<MessageExchangeDecorator> blockingQueue : this.exchangeQueues.values()) {
                    if (blockingQueue.size() <= 0) continue;
                    Thread.sleep(1000L);
                    break;
                }
                bl = true;
            }
        }
        catch (InterruptedException interruptedException) {}
        if (!bl) {
            this.log.warning((Object)"The timeout for stopping the Router traffic has been reached. Some message have not beed accepted by the component, they are lost.");
        }
        this.stopTraffic = true;
        boolean bl2 = true;
        while (bl2) {
            try {
                for (Thread thread : this.threadsList) {
                    if (!thread.isAlive()) continue;
                    thread.interrupt();
                }
                bl2 = false;
            }
            catch (ConcurrentModificationException concurrentModificationException) {}
        }
        this.log.end();
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() throws RoutingException {
        this.log = new LoggingUtil(this.logger);
        this.log.call();
        this.exchangeQueues = new ConcurrentHashMap<String, BlockingQueue<MessageExchangeDecorator>>();
        this.pendingMessageExchanges = new ConcurrentHashMap<String, List<MessageExchangeDecorator>>();
        this.threadsList = new Vector<Thread>(100);
        ContainerConfiguration containerConfiguration = this.configurationService.getContainerConfiguration();
        this.transporterQueueOfferingTimeout = containerConfiguration.getTransporterQueueOfferingTimeout();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("The offering timeout of component queues is set to " + this.transporterQueueOfferingTimeout + "'."));
        }
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() throws RoutingException {
        this.log.call();
    }

    private void checkStopTraffic() throws RoutingException {
        if (this.stopTraffic) {
            Thread.currentThread().interrupt();
            throw new RoutingException("The Router traffic is stopped", new InterruptedException());
        }
    }

    private boolean removeBypassMessageExchange(MessageExchangeDecorator messageExchangeDecorator) {
        this.log.call();
        if (messageExchangeDecorator.isTerminated()) {
            if (MessageExchange.Role.CONSUMER.equals(messageExchangeDecorator.getRole())) {
                if (messageExchangeDecorator.getProperty("org.ow2.petals.router.consumer.noack") != null) {
                    messageExchangeDecorator.setProperty("org.ow2.petals.router.consumer.noack", "false");
                    this.log.warning((Object)"Property 'org.ow2.petals.router.consumer.noack' is not supported in synchronous send mode");
                }
            } else if (messageExchangeDecorator.getProperty("org.ow2.petals.router.provider.noack") != null) {
                messageExchangeDecorator.setProperty("org.ow2.petals.router.provider.noack", "false");
                this.log.warning((Object)"Property 'org.ow2.petals.router.provider.noack' is not supported in synchronous send mode");
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean sendToConsumer(TransportSendContext transportSendContext, MessageExchangeDecorator messageExchangeDecorator, boolean bl, long l) throws RoutingException {
        this.log.start();
        boolean bl2 = false;
        long l2 = System.currentTimeMillis();
        boolean bl3 = true;
        int n = 0;
        while (bl3) {
            Object var13_13;
            bl3 = false;
            if (n != 0) {
                try {
                    Thread.sleep(transportSendContext.delay);
                }
                catch (InterruptedException interruptedException) {
                    throw new RoutingException(interruptedException);
                }
            }
            try {
                try {
                    if (transportSendContext.attempt > 1 || messageExchangeDecorator.getMessageExchange().isPersisted()) {
                        try {
                            SourcesForkerUtil.forkExchangeSources(messageExchangeDecorator);
                        }
                        catch (MessagingException messagingException) {
                            throw new RoutingException(messagingException);
                        }
                    }
                    if (bl) {
                        if (l > 0L) {
                            long l3 = System.currentTimeMillis() - l2;
                            if (l3 > l) {
                                messageExchangeDecorator.setTimeout(true);
                                var13_13 = null;
                                try {
                                    SourcesForkerUtil.cleanExchangeSources(messageExchangeDecorator);
                                }
                                catch (IOException iOException) {}
                                break;
                            }
                            transportSendContext.timeout = l - l3;
                        }
                        ((Transporter)this.transporters.get("transporter-" + transportSendContext.transport)).sendSync(messageExchangeDecorator, transportSendContext);
                    } else {
                        ((Transporter)this.transporters.get("transporter-" + transportSendContext.transport)).send(messageExchangeDecorator, transportSendContext);
                        if ("local".equals(transportSendContext.transport)) {
                            bl2 = true;
                        }
                    }
                    bl3 = false;
                }
                catch (TransportException transportException) {
                    transportSendContext.attempt = (short)(transportSendContext.attempt - 1);
                    if (transportSendContext.attempt <= 0) throw new RoutingException((Throwable)((Object)transportException));
                    this.log.warning((Object)("The send attempt to the " + transportSendContext.destination + " failed"), (Throwable)((Object)transportException));
                    bl3 = true;
                    n = transportSendContext.delay;
                }
                var13_13 = null;
            }
            catch (Throwable throwable) {
                var13_13 = null;
                try {}
                catch (IOException iOException) {}
                SourcesForkerUtil.cleanExchangeSources(messageExchangeDecorator);
                throw throwable;
                throw throwable;
            }
            try {}
            catch (IOException iOException) {}
            SourcesForkerUtil.cleanExchangeSources(messageExchangeDecorator);
        }
        this.log.end();
        return bl2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean sendToProvider(Map<ServiceEndpoint, TransportSendContext> map, ComponentContext componentContext, MessageExchangeDecorator messageExchangeDecorator, boolean bl, long l) throws RoutingException {
        this.log.start();
        boolean bl2 = false;
        TransportSendContext transportSendContext = null;
        long l2 = System.currentTimeMillis();
        boolean bl3 = true;
        int n = 0;
        while (true) {
            Object var17_17;
            if (!bl3) {
                this.log.end();
                return bl2;
            }
            if (n != 0) {
                this.log.debug((Object)("Wait " + n + " millisecond before the next send attempt"));
                try {
                    Thread.sleep(n);
                }
                catch (InterruptedException interruptedException) {
                    throw new RoutingException(interruptedException);
                }
            }
            bl3 = false;
            Iterator<ServiceEndpoint> iterator = map.keySet().iterator();
            try {
                while (iterator.hasNext()) {
                    ServiceEndpoint serviceEndpoint = iterator.next();
                    transportSendContext = map.get(serviceEndpoint);
                    if (transportSendContext.attempt <= 0) continue;
                    this.log.debug((Object)("Send attempt to endpoint '" + serviceEndpoint.getEndpointName() + "'"));
                    try {
                        block24: {
                            block21: {
                                block22: {
                                    long l3;
                                    block23: {
                                        messageExchangeDecorator.setEndpoint(serviceEndpoint);
                                        messageExchangeDecorator.setService(serviceEndpoint.getServiceName());
                                        messageExchangeDecorator.setInterfaceName((QName)serviceEndpoint.getInterfacesName().get(0));
                                        if (iterator.hasNext() || n > 0 || transportSendContext.attempt > 1 || messageExchangeDecorator.getMessageExchange().isPersisted()) {
                                            try {
                                                SourcesForkerUtil.forkExchangeSources(messageExchangeDecorator);
                                            }
                                            catch (MessagingException messagingException) {
                                                throw new RoutingException(messagingException);
                                            }
                                        }
                                        if (!bl) break block21;
                                        if (l <= 0L) break block22;
                                        l3 = System.currentTimeMillis() - l2;
                                        if (l3 <= l) break block23;
                                        this.log.debug((Object)"Timeout reached!");
                                        messageExchangeDecorator.setTimeout(true);
                                        bl3 = false;
                                        break;
                                    }
                                    transportSendContext.timeout = l - l3;
                                }
                                ((Transporter)this.transporters.get("transporter-" + transportSendContext.transport)).sendSync(messageExchangeDecorator, transportSendContext);
                                break block24;
                            }
                            ((Transporter)this.transporters.get("transporter-" + transportSendContext.transport)).send(messageExchangeDecorator, transportSendContext);
                            if ("local".equals(transportSendContext.transport)) {
                                bl2 = true;
                            }
                        }
                        bl3 = false;
                        break;
                    }
                    catch (TransportException transportException) {
                        transportSendContext.attempt = (short)(transportSendContext.attempt - 1);
                        if (transportSendContext.attempt > 0) {
                            bl3 = true;
                            if (transportSendContext.delay > n) {
                                n = transportSendContext.delay;
                            }
                        }
                        if (!iterator.hasNext()) {
                            if (!bl3) throw new RoutingException((Throwable)((Object)transportException));
                        }
                        this.log.warning((Object)("The send attempt to the endpoint '" + serviceEndpoint.getEndpointName() + "' with destination " + transportSendContext.destination + " failed"), (Throwable)((Object)transportException));
                    }
                }
            }
            catch (Throwable throwable) {
                var17_17 = null;
                try {
                    SourcesForkerUtil.cleanExchangeSources(messageExchangeDecorator);
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                var17_17 = null;
            }
            try {}
            catch (IOException iOException) {}
            SourcesForkerUtil.cleanExchangeSources(messageExchangeDecorator);
        }
    }
}

