/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.messaging.routing.module;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.security.auth.Subject;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.jaas.GroupPrincipal;
import org.ow2.petals.jbi.component.context.ComponentContext;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.jbi.messaging.exchange.MessageExchangeDecorator;
import org.ow2.petals.jbi.messaging.routing.RoutingException;
import org.ow2.petals.jbi.messaging.routing.module.SenderModule;
import org.ow2.petals.jbi.security.AuthorizationEntry;
import org.ow2.petals.jbi.security.AuthorizationException;
import org.ow2.petals.jbi.security.AuthorizationMap;
import org.ow2.petals.jbi.security.DefaultAuthorizationMap;
import org.ow2.petals.jbi.security.DefaultAuthorizationParser;
import org.ow2.petals.transport.util.TransportSendContext;
import org.ow2.petals.util.LoggingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=SenderModule.class)})
public class AuthorizationModule
implements BindingController,
LifeCycleController,
SenderModule {
    private LoggerFactory loggerFactory;
    protected LoggingUtil log;
    protected Logger logger;
    public static final String CONFIGURATION = "authorization.cfg";
    private AuthorizationMap authorizationMap;

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() throws IOException, URISyntaxException, AuthorizationException {
        this.log = new LoggingUtil(this.logger);
        this.log.call();
        URL uRL = this.getClass().getResource("/authorization.cfg");
        if (uRL == null) {
            IOException iOException = new IOException("Can not load the authorization resource from classpath");
            this.log.error((Object)"Failed to start Authorization Module", (Throwable)iOException);
            throw iOException;
        }
        try {
            DefaultAuthorizationParser defaultAuthorizationParser = new DefaultAuthorizationParser(uRL.toURI());
            this.authorizationMap = defaultAuthorizationParser.parse();
            if (this.authorizationMap == null) {
                this.authorizationMap = new DefaultAuthorizationMap(new ArrayList<AuthorizationEntry>(0));
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            this.log.error((Object)"Failed to start Authorization Module", (Throwable)uRISyntaxException);
            throw uRISyntaxException;
        }
        catch (AuthorizationException authorizationException) {
            this.log.error((Object)"Failed to start Authorization Module", (Throwable)authorizationException);
            throw authorizationException;
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() throws RoutingException {
        this.log.call();
    }

    @Override
    public void electEndpoints(Map<ServiceEndpoint, TransportSendContext> map, ComponentContext componentContext, MessageExchangeDecorator messageExchangeDecorator) throws RoutingException {
        this.authorizeSend(messageExchangeDecorator);
    }

    protected void authorizeSend(MessageExchangeDecorator messageExchangeDecorator) throws RoutingException {
        javax.jbi.servicedesc.ServiceEndpoint serviceEndpoint;
        if (messageExchangeDecorator.getRole() == MessageExchange.Role.PROVIDER && messageExchangeDecorator.getStatus() != ExchangeStatus.DONE && (serviceEndpoint = messageExchangeDecorator.getEndpoint()) != null) {
            Set<Principal> set = this.authorizationMap.getAccessControlList(serviceEndpoint, messageExchangeDecorator.getOperation());
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                for (Principal object : set) {
                    this.log.debug((Object)("Server defined ACL for operation : " + messageExchangeDecorator.getOperation().toString()));
                    this.log.debug((Object)(String.valueOf(object.getName()) + "(" + object.getClass().getName() + ")"));
                }
            }
            if (!set.contains(GroupPrincipal.ALL)) {
                Subject subject = messageExchangeDecorator.getMessage("in").getSecuritySubject();
                if (subject == null) {
                    throw new SecurityException("User not authenticated (security subject is null)");
                }
                set.retainAll(subject.getPrincipals());
                this.log.debug((Object)("ACLS size after retain is : " + set.size()));
                if (set.size() == 0) {
                    throw new SecurityException("Endpoint '" + serviceEndpoint.getEndpointName() + "' / Operation '" + messageExchangeDecorator.getOperation() + "' is not authorized for this user");
                }
            }
        }
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList arrayList = new ArrayList();
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

