/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.messaging.routing.module;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.xml.namespace.QName;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.jbi.component.context.ComponentContext;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.jbi.messaging.exchange.MessageExchangeDecorator;
import org.ow2.petals.jbi.messaging.routing.RoutingException;
import org.ow2.petals.jbi.messaging.routing.module.SenderModule;
import org.ow2.petals.jbi.messaging.routing.module.flow.PriorityModifier;
import org.ow2.petals.jbi.messaging.routing.monitoring.RouterMonitorFilter;
import org.ow2.petals.jbi.messaging.routing.monitoring.RouterMonitorService;
import org.ow2.petals.regulation.RegulationBuilder;
import org.ow2.petals.regulation.RegulationException;
import org.ow2.petals.regulation.generated.Flow;
import org.ow2.petals.regulation.generated.Regulation;
import org.ow2.petals.transport.util.TransportSendContext;
import org.ow2.petals.util.LoggingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=SenderModule.class)})
public class FlowControllerModule
implements BindingController,
LifeCycleController,
SenderModule {
    private LoggerFactory loggerFactory;
    public static final String REGULATION_CONFIGURATION_FILE = "regulation.xml";
    private static final long RATE_CALCULATE_PERIOD = 10000L;
    private static final long PRIORITY_UPDATE_PERIOD = 500L;
    private static final long EXCHANGE_DELAY = 300L;
    private LoggingUtil log;
    private Logger logger;
    @Requires(name="prioritymodifier", signature=PriorityModifier.class)
    private PriorityModifier priorityModifier;
    @Requires(name="routermonitor", signature=RouterMonitorService.class)
    private RouterMonitorService routerMonitorService;
    private Map<RouterMonitorFilter, _Rate> rates;
    private Map<Long, MessageExchangeDecorator> pendingExchanges;
    private Timer rateControlTimer;

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @Override
    public void electEndpoints(Map<ServiceEndpoint, TransportSendContext> map, ComponentContext componentContext, MessageExchangeDecorator messageExchangeDecorator) throws RoutingException {
        if (MessageExchange.Role.CONSUMER.equals(messageExchangeDecorator.getRole()) && messageExchangeDecorator.getMessage("in") != null) {
            for (RouterMonitorFilter routerMonitorFilter : this.rates.keySet()) {
                String string = null;
                QName qName = messageExchangeDecorator.getInterfaceName();
                QName qName2 = messageExchangeDecorator.getService();
                QName qName3 = messageExchangeDecorator.getOperation();
                if (messageExchangeDecorator.getEndpoint() != null) {
                    string = messageExchangeDecorator.getEndpoint().getEndpointName();
                    qName = messageExchangeDecorator.getEndpoint().getInterfaces()[0];
                    qName2 = messageExchangeDecorator.getEndpoint().getServiceName();
                }
                if (routerMonitorFilter.getInterfaceName() != null && (qName == null || !qName.equals(routerMonitorFilter.getInterfaceName())) || routerMonitorFilter.getServiceName() != null && (qName2 == null || !qName2.equals(routerMonitorFilter.getServiceName())) || routerMonitorFilter.getEndpointName() != null && (string == null || !string.equals(routerMonitorFilter.getEndpointName())) || routerMonitorFilter.getOperationName() != null && (qName3 == null || !qName3.equals(routerMonitorFilter.getOperationName()))) continue;
                _Rate _Rate2 = this.rates.get(routerMonitorFilter);
                if (_Rate2.diffRate <= 0) continue;
                messageExchangeDecorator.setProperty("org.petals.ow2.router.priority", "0");
                long l = (long)_Rate2.diffRate * 300L;
                this.log.debug((Object)("Slow down the exchange with Id '" + messageExchangeDecorator.getExchangeId() + "' of " + l + "ms"));
                this.pendingExchanges.put(System.currentTimeMillis() + l, messageExchangeDecorator);
            }
        }
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() throws RegulationException {
        this.log = new LoggingUtil(this.logger);
        this.log.start();
        this.rates = new HashMap<RouterMonitorFilter, _Rate>();
        this.pendingExchanges = new ConcurrentHashMap<Long, MessageExchangeDecorator>();
        this.rateControlTimer = new Timer();
        try {
            if (this.loadRegulationConfiguration()) {
                for (RouterMonitorFilter routerMonitorFilter : this.rates.keySet()) {
                    try {
                        this.routerMonitorService.monitorExchanges(routerMonitorFilter.getInterfaceName(), routerMonitorFilter.getServiceName(), routerMonitorFilter.getEndpointName(), routerMonitorFilter.getOperationName(), false);
                    }
                    catch (MessagingException messagingException) {
                        this.log.warning((Object)messagingException.getMessage());
                    }
                }
                this.rateControlTimer.schedule((TimerTask)new RateCaculator(), 10000L, 10000L);
                this.rateControlTimer.schedule((TimerTask)new PriorityUpdater(), 10000L, 500L);
            }
        }
        catch (RegulationException regulationException) {
            this.log.error((Object)"Failed to start Priority Regulator service", (Throwable)regulationException);
            throw regulationException;
        }
        this.log.end();
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("prioritymodifier")) {
            if (!PriorityModifier.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + PriorityModifier.class.getName());
            }
            this.priorityModifier = (PriorityModifier)object;
            return;
        }
        if (string.equals("routermonitor")) {
            if (!RouterMonitorService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + RouterMonitorService.class.getName());
            }
            this.routerMonitorService = (RouterMonitorService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.call();
        this.rateControlTimer.cancel();
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("prioritymodifier");
        arrayList.add("routermonitor");
        return arrayList.toArray(new String[0]);
    }

    private boolean loadRegulationConfiguration() throws RegulationException {
        boolean bl = false;
        URL uRL = this.getClass().getResource("/regulation.xml");
        if (uRL != null) {
            Regulation regulation = RegulationBuilder.createRegulation((String)uRL.getFile());
            for (Flow flow : regulation.getFlow()) {
                RouterMonitorFilter routerMonitorFilter = new RouterMonitorFilter(flow.getInterface(), flow.getService(), flow.getEndpoint(), flow.getOperation(), false);
                if (flow.getRate() == null) continue;
                this.rates.put(routerMonitorFilter, new _Rate(flow.getRate().intValue()));
                this.log.info((Object)("Add a flow control on " + routerMonitorFilter + " with rate " + flow.getRate()));
            }
            bl = true;
        }
        return bl;
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("prioritymodifier")) {
            return this.priorityModifier;
        }
        if (string.equals("routermonitor")) {
            return this.routerMonitorService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("prioritymodifier")) {
            this.priorityModifier = null;
            return;
        }
        if (string.equals("routermonitor")) {
            this.routerMonitorService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    private class PriorityUpdater
    extends TimerTask {
        private PriorityUpdater() {
        }

        public void run() {
            long l = System.currentTimeMillis();
            for (Long l2 : FlowControllerModule.this.pendingExchanges.keySet()) {
                if (l <= l2) continue;
                MessageExchangeDecorator messageExchangeDecorator = (MessageExchangeDecorator)FlowControllerModule.this.pendingExchanges.remove(l2);
                try {
                    FlowControllerModule.this.priorityModifier.modifyPriority(messageExchangeDecorator, (short)3);
                    FlowControllerModule.this.log.debug((Object)("Reassign priority for exchange with Id '" + messageExchangeDecorator.getExchangeId() + "'"));
                }
                catch (RoutingException routingException) {
                    FlowControllerModule.this.log.warning((Object)("Failed to reassign a priority to the exchange with Id '" + messageExchangeDecorator.getExchangeId() + "', maybe a timeout has occurred"), (Throwable)((Object)routingException));
                }
            }
        }
    }

    private class RateCaculator
    extends TimerTask {
        private RateCaculator() {
        }

        public void run() {
            long l = System.currentTimeMillis();
            for (RouterMonitorFilter routerMonitorFilter : FlowControllerModule.this.rates.keySet()) {
                try {
                    int n = FlowControllerModule.this.routerMonitorService.getExchanges(routerMonitorFilter.getInterfaceName(), routerMonitorFilter.getServiceName(), routerMonitorFilter.getEndpointName(), routerMonitorFilter.getOperationName(), l - 10000L, l);
                    float f = 0.0f;
                    if (n != 0) {
                        f = (float)n * 1000.0f / 10000.0f;
                    }
                    _Rate _Rate2 = (_Rate)FlowControllerModule.this.rates.get(routerMonitorFilter);
                    if (f > _Rate2.expectedRate) {
                        _Rate2.diffRate += new Double(Math.exp(f - _Rate2.expectedRate)).intValue();
                    } else if (f < _Rate2.expectedRate && _Rate2.diffRate > 0) {
                        _Rate2.diffRate -= new Double(Math.exp(_Rate2.expectedRate - f)).intValue();
                        if (_Rate2.diffRate < 0) {
                            _Rate2.diffRate = 0;
                        }
                    }
                    FlowControllerModule.this.log.debug((Object)("Flow rate for " + routerMonitorFilter + " : " + f));
                }
                catch (MessagingException messagingException) {
                    FlowControllerModule.this.log.warning((Object)("Failed to calculate a flow rate for " + routerMonitorFilter), (Throwable)messagingException);
                }
            }
        }
    }

    private class _Rate {
        public float expectedRate;
        public int diffRate;

        public _Rate(float f) {
            this.expectedRate = f;
        }
    }
}

