/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.messaging.routing.module;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.jbi.messaging.MessageExchange;
import javax.xml.namespace.QName;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.jbi.component.context.ComponentContext;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.jbi.messaging.exchange.MessageExchangeDecorator;
import org.ow2.petals.jbi.messaging.routing.RoutingException;
import org.ow2.petals.jbi.messaging.routing.module.SenderModule;
import org.ow2.petals.jbi.messaging.routing.module.flow.PriorityModifier;
import org.ow2.petals.jbi.messaging.routing.monitoring.RouterMonitorFilter;
import org.ow2.petals.regulation.RegulationBuilder;
import org.ow2.petals.regulation.RegulationException;
import org.ow2.petals.regulation.generated.Flow;
import org.ow2.petals.regulation.generated.Regulation;
import org.ow2.petals.transport.util.TransportSendContext;
import org.ow2.petals.util.LoggingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=SenderModule.class)})
public class FlowFilterModule
implements BindingController,
LifeCycleController,
SenderModule {
    private LoggerFactory loggerFactory;
    private static final long PRIORITY_UPDATE_PERIOD = 1000L;
    private LoggingUtil log;
    private Logger logger;
    @Requires(name="prioritymodifier", signature=PriorityModifier.class)
    private PriorityModifier priorityModifier;
    private Map<RouterMonitorFilter, _Filter> filters;
    private Timer filterTimer;

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void electEndpoints(Map<ServiceEndpoint, TransportSendContext> map, ComponentContext componentContext, MessageExchangeDecorator messageExchangeDecorator) throws RoutingException {
        if (MessageExchange.Role.CONSUMER.equals(messageExchangeDecorator.getRole()) && messageExchangeDecorator.getMessage("in") != null) {
            for (RouterMonitorFilter routerMonitorFilter : this.filters.keySet()) {
                String string = null;
                QName qName = messageExchangeDecorator.getInterfaceName();
                QName qName2 = messageExchangeDecorator.getService();
                QName qName3 = messageExchangeDecorator.getOperation();
                if (messageExchangeDecorator.getEndpoint() != null) {
                    string = messageExchangeDecorator.getEndpoint().getEndpointName();
                    qName = messageExchangeDecorator.getEndpoint().getInterfaces()[0];
                    qName2 = messageExchangeDecorator.getEndpoint().getServiceName();
                }
                if (routerMonitorFilter.getInterfaceName() != null && (qName == null || !qName.equals(routerMonitorFilter.getInterfaceName())) || routerMonitorFilter.getServiceName() != null && (qName2 == null || !qName2.equals(routerMonitorFilter.getServiceName())) || routerMonitorFilter.getEndpointName() != null && (string == null || !string.equals(routerMonitorFilter.getEndpointName())) || routerMonitorFilter.getOperationName() != null && (qName3 == null || !qName3.equals(routerMonitorFilter.getOperationName()))) continue;
                _Filter _Filter2 = this.filters.get(routerMonitorFilter);
                boolean bl = false;
                _Filter _Filter3 = _Filter2;
                synchronized (_Filter3) {
                    if (_Filter2.messagesSent == _Filter2.expectedFilter) {
                        _Filter2.pendingExchanges.add(messageExchangeDecorator);
                        bl = true;
                    } else {
                        ++_Filter2.messagesSent;
                    }
                }
                if (!bl) continue;
                messageExchangeDecorator.setProperty("org.petals.ow2.router.priority", "0");
                this.log.debug((Object)("Filter the exchange with Id '" + messageExchangeDecorator.getExchangeId() + "'"));
            }
        }
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() throws RegulationException {
        this.log = new LoggingUtil(this.logger);
        this.log.start();
        this.filters = new HashMap<RouterMonitorFilter, _Filter>();
        this.filterTimer = new Timer();
        try {
            if (this.loadRegulationConfiguration()) {
                this.filterTimer.schedule((TimerTask)new PriorityUpdater(), 1000L, 1000L);
            }
        }
        catch (RegulationException regulationException) {
            this.log.error((Object)"Failed to start Priority Regulator service", (Throwable)regulationException);
            throw regulationException;
        }
        this.log.end();
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.call();
        this.filterTimer.cancel();
    }

    private boolean loadRegulationConfiguration() throws RegulationException {
        boolean bl = false;
        URL uRL = this.getClass().getResource("/regulation.xml");
        if (uRL != null) {
            Regulation regulation = RegulationBuilder.createRegulation((String)uRL.getFile());
            for (Flow flow : regulation.getFlow()) {
                RouterMonitorFilter routerMonitorFilter = new RouterMonitorFilter(flow.getInterface(), flow.getService(), flow.getEndpoint(), flow.getOperation(), false);
                if (flow.getFilter() == null) continue;
                this.filters.put(routerMonitorFilter, new _Filter(flow.getFilter().getValue(), flow.getFilter().getWindow()));
                this.log.info((Object)("Add a flow filter on " + routerMonitorFilter + " with threshold " + flow.getFilter().getValue() + " on window " + flow.getFilter().getWindow()));
            }
            bl = true;
        }
        return bl;
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("prioritymodifier")) {
            if (!PriorityModifier.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + PriorityModifier.class.getName());
            }
            this.priorityModifier = (PriorityModifier)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("prioritymodifier");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("prioritymodifier")) {
            return this.priorityModifier;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("prioritymodifier")) {
            this.priorityModifier = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    private class PriorityUpdater
    extends TimerTask {
        private PriorityUpdater() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Iterator iterator = FlowFilterModule.this.filters.values().iterator();
            while (iterator.hasNext()) {
                _Filter _Filter2;
                _Filter _Filter3 = _Filter2 = (_Filter)iterator.next();
                synchronized (_Filter3) {
                    ++_Filter2.currentWindow;
                    if (_Filter2.currentWindow == _Filter2.expectedWindow) {
                        _Filter2.currentWindow = 0;
                        _Filter2.messagesSent = 0;
                        while (_Filter2.pendingExchanges.size() > 0 && _Filter2.messagesSent < _Filter2.expectedFilter) {
                            MessageExchangeDecorator messageExchangeDecorator = _Filter2.pendingExchanges.poll();
                            try {
                                FlowFilterModule.this.priorityModifier.modifyPriority(messageExchangeDecorator, (short)3);
                                FlowFilterModule.this.log.debug((Object)("Reassign priority for exchange with Id '" + messageExchangeDecorator.getExchangeId() + "'"));
                                ++_Filter2.messagesSent;
                            }
                            catch (RoutingException routingException) {
                                FlowFilterModule.this.log.warning((Object)("Failed to reassign a priority to the exchange with Id '" + messageExchangeDecorator.getExchangeId() + "', maybe a timeout has occurred"), (Throwable)((Object)routingException));
                            }
                        }
                    }
                }
            }
        }
    }

    private class _Filter {
        public int expectedFilter;
        public int messagesSent;
        public Queue<MessageExchangeDecorator> pendingExchanges;
        public int expectedWindow;
        public int currentWindow;

        public _Filter(int n, int n2) {
            this.expectedFilter = n;
            this.expectedWindow = n2;
            this.pendingExchanges = new ConcurrentLinkedQueue<MessageExchangeDecorator>();
        }
    }
}

