/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.messaging.routing.module;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.sql.SQLException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.jbi.component.context.ComponentContext;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.jbi.messaging.exchange.MessageExchangeDecorator;
import org.ow2.petals.jbi.messaging.routing.RoutingException;
import org.ow2.petals.jbi.messaging.routing.module.SenderModule;
import org.ow2.petals.jbi.messaging.routing.module.flow.PriorityModifier;
import org.ow2.petals.system.persistence.PersistenceService;
import org.ow2.petals.transport.util.TransportSendContext;
import org.ow2.petals.util.LoggingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=SenderModule.class), @Interface(name="prioritymodifier", signature=PriorityModifier.class)})
public class PriorityOrdererModule
implements NotificationListener,
BindingController,
LifeCycleController,
SenderModule,
PriorityModifier {
    private LoggerFactory loggerFactory;
    private LoggingUtil log;
    private Logger logger;
    @Requires(name="persistence", signature=PersistenceService.class)
    private PersistenceService persistenceService;
    public static final String PROPERTY_ROUTER_PRIORITY = "org.petals.ow2.router.priority";
    public static final long TIMEOUT_MANAGER_PERIOD = 1000L;
    private Deque<MessageExchangeDecorator> exchangePriority0;
    private Deque<MessageExchangeDecorator> exchangePriority1;
    private Deque<MessageExchangeDecorator> exchangePriority2;
    private Deque<MessageExchangeDecorator> exchangePriority3;
    private Map<MessageExchangeDecorator, Long> exchangeTimeouts;
    private AtomicLong pendingExchanges;
    private PriorityProcessor priorityProcessor;
    private Timer timeoutManagerTimer;

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void electEndpoints(Map<ServiceEndpoint, TransportSendContext> map, ComponentContext componentContext, MessageExchangeDecorator messageExchangeDecorator) throws RoutingException {
        String string = (String)messageExchangeDecorator.getProperty(PROPERTY_ROUTER_PRIORITY);
        if (string == null) return;
        String string2 = messageExchangeDecorator.getExchangeId();
        synchronized (string2) {
            Deque<MessageExchangeDecorator> deque;
            if ("3".equals(string)) {
                deque = this.exchangePriority3;
                synchronized (deque) {
                    this.log.debug((Object)("Add Exchange with Id '" + messageExchangeDecorator.getExchangeId() + "' to priority 3"));
                    this.exchangePriority3.add(messageExchangeDecorator);
                }
            }
            if ("2".equals(string)) {
                deque = this.exchangePriority2;
                synchronized (deque) {
                    this.log.debug((Object)("Add Exchange with Id '" + messageExchangeDecorator.getExchangeId() + "' to priority 2"));
                    this.exchangePriority2.add(messageExchangeDecorator);
                }
            }
            if ("1".equals(string)) {
                deque = this.exchangePriority1;
                synchronized (deque) {
                    this.log.debug((Object)("Add Exchange with Id '" + messageExchangeDecorator.getExchangeId() + "' to priority 1"));
                    this.exchangePriority1.add(messageExchangeDecorator);
                }
            }
            if ("0".equals(string)) {
                deque = this.exchangePriority0;
                synchronized (deque) {
                    this.log.debug((Object)("Add Exchange with Id '" + messageExchangeDecorator.getExchangeId() + "' to priority 0"));
                    this.exchangePriority0.add(messageExchangeDecorator);
                    this.exchangeTimeouts.put(messageExchangeDecorator, (Long)messageExchangeDecorator.getProperty("org.ow2.petals.router.timetolive"));
                }
            }
            if (this.pendingExchanges.getAndIncrement() == 0L) {
                this.timeoutManagerTimer = new Timer();
                this.timeoutManagerTimer.schedule((TimerTask)new TimeoutManager(), 1000L, 1000L);
                LockSupport.unpark(this.priorityProcessor);
            }
            try {
                try {
                    messageExchangeDecorator.getExchangeId().wait();
                }
                catch (InterruptedException interruptedException) {
                    if (!(this.exchangePriority3.remove(messageExchangeDecorator) || this.exchangePriority2.remove(messageExchangeDecorator) || this.exchangePriority1.remove(messageExchangeDecorator))) {
                        if (!this.exchangePriority0.remove(messageExchangeDecorator)) throw new RoutingException("Message Exchange with Id '" + messageExchangeDecorator.getExchangeId() + "' has been interrupted from priority ordering", interruptedException);
                    }
                    this.pendingExchanges.decrementAndGet();
                    throw new RoutingException("Message Exchange with Id '" + messageExchangeDecorator.getExchangeId() + "' has been interrupted from priority ordering", interruptedException);
                }
                Object var7_10 = null;
                messageExchangeDecorator.setProperty(PROPERTY_ROUTER_PRIORITY, null);
                return;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                messageExchangeDecorator.setProperty(PROPERTY_ROUTER_PRIORITY, null);
                throw throwable;
            }
        }
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("persistence")) {
            if (!PersistenceService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + PersistenceService.class.getName());
            }
            this.persistenceService = (PersistenceService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("persistence");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("persistence")) {
            return this.persistenceService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleNotification(Notification notification, Object object) {
        if ("java.management.memory.threshold.exceeded".equals(notification.getType())) {
            Iterator<MessageExchangeDecorator> iterator;
            this.log.info((Object)"Memory threshold reached, persist some pending exchange if any");
            int n = this.exchangePriority0.size() + this.exchangePriority1.size() + this.exchangePriority2.size() + this.exchangePriority3.size();
            int n2 = 0;
            MessageExchangeDecorator messageExchangeDecorator = null;
            Deque<MessageExchangeDecorator> deque = this.exchangePriority0;
            synchronized (deque) {
                iterator = this.exchangePriority0.iterator();
                while (iterator.hasNext()) {
                    try {
                        messageExchangeDecorator = iterator.next();
                        if (messageExchangeDecorator.isMessageExchangeStored()) continue;
                        messageExchangeDecorator.persistExchange(this.persistenceService);
                        this.log.debug((Object)("Persist Message Exchange with Id '" + messageExchangeDecorator.getExchangeId() + "'"));
                        ++n2;
                    }
                    catch (SQLException sQLException) {
                        this.log.warning((Object)("Failed to persist Message Exchange with Id '" + messageExchangeDecorator.getExchangeId() + "'"), (Throwable)sQLException);
                    }
                    catch (IOException iOException) {
                        this.log.warning((Object)("Failed to store a monitored exchange with Id '" + messageExchangeDecorator.getExchangeId() + "'"), (Throwable)iOException);
                    }
                }
            }
            if (n2 < n / 2) {
                deque = this.exchangePriority1;
                synchronized (deque) {
                    iterator = this.exchangePriority1.iterator();
                    int n3 = this.exchangePriority1.size() / 2;
                    while (iterator.hasNext() && n3 > 0) {
                        try {
                            messageExchangeDecorator = iterator.next();
                            if (messageExchangeDecorator.isMessageExchangeStored()) continue;
                            messageExchangeDecorator.persistExchange(this.persistenceService);
                            this.log.debug((Object)("Persist Message Exchange with Id '" + messageExchangeDecorator.getExchangeId() + "'"));
                            ++n2;
                            ++n3;
                        }
                        catch (SQLException sQLException) {
                            this.log.warning((Object)("Failed to persist Message Exchange with Id '" + messageExchangeDecorator.getExchangeId() + "'"), (Throwable)sQLException);
                        }
                        catch (IOException iOException) {
                            this.log.warning((Object)("Failed to persist Message Exchange with Id '" + messageExchangeDecorator.getExchangeId() + "'"), (Throwable)iOException);
                        }
                    }
                }
            }
            if (n2 < n / 2) {
                deque = this.exchangePriority2;
                synchronized (deque) {
                    iterator = this.exchangePriority2.iterator();
                    int n4 = this.exchangePriority2.size() / 2;
                    while (iterator.hasNext() && n4 > 0) {
                        try {
                            messageExchangeDecorator = iterator.next();
                            if (messageExchangeDecorator.isMessageExchangeStored()) continue;
                            messageExchangeDecorator.persistExchange(this.persistenceService);
                            this.log.debug((Object)("Persist Message Exchange with Id '" + messageExchangeDecorator.getExchangeId() + "'"));
                            ++n2;
                            ++n4;
                        }
                        catch (SQLException sQLException) {
                            this.log.warning((Object)("Failed to persist Message Exchange with Id '" + messageExchangeDecorator.getExchangeId() + "'"), (Throwable)sQLException);
                        }
                        catch (IOException iOException) {
                            this.log.warning((Object)("Failed to persist Message Exchange with Id '" + messageExchangeDecorator.getExchangeId() + "'"), (Throwable)iOException);
                        }
                    }
                }
            }
            if (n2 < n / 2) {
                deque = this.exchangePriority3;
                synchronized (deque) {
                    iterator = this.exchangePriority3.iterator();
                    int n5 = this.exchangePriority3.size() / 2;
                    while (iterator.hasNext() && n5 > 0) {
                        try {
                            if (messageExchangeDecorator.isMessageExchangeStored()) continue;
                            messageExchangeDecorator = iterator.next();
                            messageExchangeDecorator.persistExchange(this.persistenceService);
                            this.log.debug((Object)("Persist Message Exchange with Id '" + messageExchangeDecorator.getExchangeId() + "'"));
                            ++n2;
                            ++n5;
                        }
                        catch (SQLException sQLException) {
                            this.log.warning((Object)("Failed to persist Message Exchange with Id '" + messageExchangeDecorator.getExchangeId() + "'"), (Throwable)sQLException);
                        }
                        catch (IOException iOException) {
                            this.log.warning((Object)("Failed to persist Message Exchange with Id '" + messageExchangeDecorator.getExchangeId() + "'"), (Throwable)iOException);
                        }
                    }
                }
            }
        }
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("persistence")) {
            this.persistenceService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyPriority(MessageExchangeDecorator messageExchangeDecorator, short s) throws RoutingException {
        this.log.call((Object)("Exchange Id '" + messageExchangeDecorator.getExchangeId() + "' - Priority " + s));
        boolean bl = false;
        Deque<MessageExchangeDecorator> deque = this.exchangePriority3;
        synchronized (deque) {
            bl = this.exchangePriority3.remove(messageExchangeDecorator);
        }
        if (!bl) {
            deque = this.exchangePriority2;
            synchronized (deque) {
                bl = this.exchangePriority2.remove(messageExchangeDecorator);
            }
        }
        if (!bl) {
            deque = this.exchangePriority1;
            synchronized (deque) {
                bl = this.exchangePriority1.remove(messageExchangeDecorator);
            }
        }
        if (!bl) {
            deque = this.exchangePriority0;
            synchronized (deque) {
                bl = this.exchangePriority0.remove(messageExchangeDecorator);
                this.exchangeTimeouts.remove(messageExchangeDecorator);
            }
        }
        if (!bl) {
            throw new RoutingException("The Message exchange with Id '" + messageExchangeDecorator.getExchangeId() + "' is no more in priority queues");
        }
        if (s == 3) {
            deque = this.exchangePriority3;
            synchronized (deque) {
                this.exchangePriority3.add(messageExchangeDecorator);
            }
        } else if (s == 2) {
            deque = this.exchangePriority2;
            synchronized (deque) {
                this.exchangePriority2.add(messageExchangeDecorator);
            }
        } else if (s == 1) {
            deque = this.exchangePriority1;
            synchronized (deque) {
                this.exchangePriority1.add(messageExchangeDecorator);
            }
        } else if (s == 0) {
            deque = this.exchangePriority0;
            synchronized (deque) {
                this.exchangePriority0.add(messageExchangeDecorator);
                this.exchangeTimeouts.put(messageExchangeDecorator, (Long)messageExchangeDecorator.getProperty("org.ow2.petals.router.timetolive"));
            }
        } else {
            throw new RoutingException("Priority " + s + " is not supported");
        }
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.call();
        this.pendingExchanges = new AtomicLong();
        this.exchangePriority0 = new ArrayDeque<MessageExchangeDecorator>();
        this.exchangePriority1 = new ArrayDeque<MessageExchangeDecorator>();
        this.exchangePriority2 = new ArrayDeque<MessageExchangeDecorator>();
        this.exchangePriority3 = new ArrayDeque<MessageExchangeDecorator>();
        this.exchangeTimeouts = new ConcurrentHashMap<MessageExchangeDecorator, Long>();
        for (MemoryPoolMXBean platformManagedObject2 : ManagementFactory.getMemoryPoolMXBeans()) {
            if (!MemoryType.HEAP.equals((Object)platformManagedObject2.getType()) || !platformManagedObject2.isUsageThresholdSupported()) continue;
            long l = platformManagedObject2.getUsage().getMax();
            Double d = new Double((double)l * 0.8);
            platformManagedObject2.setUsageThreshold(d.longValue());
        }
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        ((NotificationEmitter)((Object)memoryMXBean)).addNotificationListener(this, null, null);
        this.priorityProcessor = new PriorityProcessor();
        this.priorityProcessor.start();
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.call();
        this.priorityProcessor.isRunning = false;
        LockSupport.unpark(this.priorityProcessor);
        if (this.timeoutManagerTimer != null) {
            this.timeoutManagerTimer.cancel();
        }
    }

    private class PriorityProcessor
    extends Thread {
        public boolean isRunning = true;

        private PriorityProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.isRunning) {
                String string;
                if (PriorityOrdererModule.this.pendingExchanges.get() == 0L) {
                    if (PriorityOrdererModule.this.timeoutManagerTimer != null) {
                        PriorityOrdererModule.this.timeoutManagerTimer.cancel();
                        PriorityOrdererModule.this.timeoutManagerTimer = null;
                    }
                    LockSupport.park(this);
                }
                int n = 3;
                MessageExchangeDecorator messageExchangeDecorator = null;
                Deque deque = PriorityOrdererModule.this.exchangePriority3;
                synchronized (deque) {
                    while (n > 0) {
                        messageExchangeDecorator = (MessageExchangeDecorator)PriorityOrdererModule.this.exchangePriority3.pollLast();
                        if (messageExchangeDecorator != null) {
                            string = messageExchangeDecorator.getExchangeId();
                            synchronized (string) {
                                messageExchangeDecorator.getExchangeId().notify();
                            }
                            PriorityOrdererModule.this.pendingExchanges.decrementAndGet();
                            n = (short)(n - 1);
                            continue;
                        }
                        n = 0;
                    }
                }
                n = 2;
                messageExchangeDecorator = null;
                deque = PriorityOrdererModule.this.exchangePriority2;
                synchronized (deque) {
                    while (n > 0) {
                        messageExchangeDecorator = (MessageExchangeDecorator)PriorityOrdererModule.this.exchangePriority2.pollLast();
                        if (messageExchangeDecorator != null) {
                            string = messageExchangeDecorator.getExchangeId();
                            synchronized (string) {
                                messageExchangeDecorator.getExchangeId().notify();
                            }
                            PriorityOrdererModule.this.pendingExchanges.decrementAndGet();
                            n = (short)(n - 1);
                            continue;
                        }
                        n = 0;
                    }
                }
                messageExchangeDecorator = null;
                deque = PriorityOrdererModule.this.exchangePriority1;
                synchronized (deque) {
                    messageExchangeDecorator = (MessageExchangeDecorator)PriorityOrdererModule.this.exchangePriority1.pollLast();
                    if (messageExchangeDecorator != null) {
                        string = messageExchangeDecorator.getExchangeId();
                        synchronized (string) {
                            messageExchangeDecorator.getExchangeId().notify();
                        }
                        PriorityOrdererModule.this.pendingExchanges.decrementAndGet();
                    }
                }
            }
        }
    }

    private class TimeoutManager
    extends TimerTask {
        private TimeoutManager() {
        }

        public void run() {
            long l = System.currentTimeMillis();
            for (MessageExchangeDecorator messageExchangeDecorator : PriorityOrdererModule.this.exchangeTimeouts.keySet()) {
                Long l2 = (Long)PriorityOrdererModule.this.exchangeTimeouts.get(messageExchangeDecorator);
                if (l2 == null || l <= l2) continue;
                messageExchangeDecorator.setTimeout(true);
                PriorityOrdererModule.this.log.debug((Object)("Exchange with Id '" + messageExchangeDecorator.getExchangeId() + "' is in send timeout"));
                try {
                    PriorityOrdererModule.this.modifyPriority(messageExchangeDecorator, (short)3);
                }
                catch (RoutingException routingException) {}
            }
        }
    }
}

