/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.messaging.routing.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.ow2.petals.commons.stream.InputStreamForker;
import org.ow2.petals.commons.stream.ReaderInputStream;
import org.ow2.petals.jbi.messaging.exchange.MessageExchangeDecorator;

public class SourcesForkerUtil {
    private static final Map<String, Map<String, InputStreamForker>> forkedStreams = new ConcurrentHashMap<String, Map<String, InputStreamForker>>();

    public static final void cleanExchangeSources(MessageExchange messageExchange) throws IOException {
        Map<String, InputStreamForker> map = forkedStreams.remove(messageExchange.getExchangeId());
        if (map != null) {
            for (InputStreamForker inputStreamForker : map.values()) {
                inputStreamForker.getInputStreamTwo().close();
            }
        }
    }

    public static final void forkExchangeSources(MessageExchangeDecorator messageExchangeDecorator) throws MessagingException {
        Map<String, InputStreamForker> map = forkedStreams.get(messageExchangeDecorator.getExchangeId());
        if (map == null) {
            map = new HashMap<String, InputStreamForker>();
            forkedStreams.put(messageExchangeDecorator.getExchangeId(), map);
        }
        Map<String, NormalizedMessage> map2 = messageExchangeDecorator.getMessages();
        for (Map.Entry<String, NormalizedMessage> entry : map2.entrySet()) {
            StreamSource streamSource;
            InputStream inputStream;
            String string = entry.getKey();
            Source source = entry.getValue().getContent();
            if (!(source instanceof StreamSource)) continue;
            InputStreamForker inputStreamForker = map.get(string);
            inputStreamForker = inputStreamForker != null ? new InputStreamForker(inputStreamForker.getInputStreamTwo()) : ((inputStream = (streamSource = (StreamSource)source).getInputStream()) != null ? new InputStreamForker(inputStream) : new InputStreamForker((InputStream)new ReaderInputStream(streamSource.getReader())));
            map.put(string, inputStreamForker);
            streamSource = new StreamSource(inputStreamForker.getInputStreamOne());
            entry.getValue().setContent((Source)streamSource);
        }
    }
}

