/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.security;

import java.security.Principal;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.ow2.petals.jbi.security.AuthorizationEntry;
import org.ow2.petals.jbi.security.AuthorizationMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAuthorizationMap
implements AuthorizationMap {
    private AuthorizationEntry defaultEntry;
    private final List<AuthorizationEntry> authorizationEntries;
    private static final Logger logger = Logger.getLogger((String)DefaultAuthorizationMap.class.getName());

    public DefaultAuthorizationMap(List<AuthorizationEntry> list) {
        this.authorizationEntries = list;
    }

    @Override
    public Set<Principal> getAccessControlList(ServiceEndpoint serviceEndpoint, QName qName) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Get Access control list for endpoint : " + serviceEndpoint.getEndpointName() + ", operation : " + qName.toString()));
        }
        HashSet<Principal> hashSet = new HashSet<Principal>();
        if (this.defaultEntry != null) {
            hashSet.addAll(this.defaultEntry.getAcls());
        }
        for (AuthorizationEntry authorizationEntry : this.authorizationEntries) {
            if (!this.match(authorizationEntry, serviceEndpoint, qName)) continue;
            if (AuthorizationEntry.ROLE_TYPE.ADD.equals((Object)authorizationEntry.getType())) {
                hashSet.addAll(authorizationEntry.getAcls());
                continue;
            }
            if (AuthorizationEntry.ROLE_TYPE.SET.equals((Object)authorizationEntry.getType())) {
                hashSet.clear();
                hashSet.addAll(authorizationEntry.getAcls());
                continue;
            }
            if (!AuthorizationEntry.ROLE_TYPE.REM.equals((Object)authorizationEntry.getType())) continue;
            hashSet.removeAll(authorizationEntry.getAcls());
        }
        return hashSet;
    }

    protected boolean match(AuthorizationEntry authorizationEntry, ServiceEndpoint serviceEndpoint, QName qName) {
        return this.match(authorizationEntry.getService(), serviceEndpoint.getServiceName()) && this.match(authorizationEntry.getEndpoint(), serviceEndpoint.getEndpointName()) && (authorizationEntry.getOperation() == null || qName == null || this.match(authorizationEntry.getOperation(), qName));
    }

    private boolean match(QName qName, QName qName2) {
        return this.match(qName.getNamespaceURI(), qName2.getNamespaceURI()) && this.match(qName.getLocalPart(), qName2.getLocalPart());
    }

    private boolean match(String string, String string2) {
        return string == null || string.equals("*") || Pattern.matches(string, string2);
    }

    public void setDefaultEntry(AuthorizationEntry authorizationEntry) {
        this.defaultEntry = authorizationEntry;
    }
}

