/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.kernel.configuration;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;
import org.ow2.petals.kernel.api.server.util.SystemUtil;
import org.ow2.petals.kernel.configuration.ConfigurationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ContainerConfiguration
implements Serializable {
    private static final long serialVersionUID = 6543213857L;
    private String subdomainName;
    private String name;
    private String description;
    private String host;
    private ContainerState state = ContainerState.UNKNOWN;
    private String rootDirectoryPath;
    private String repositoryDirectoryPath;
    private String workDirectoryPath;
    private boolean exchangeValidation;
    private long taskTimeout;
    private boolean isolateJBIClassLoaders;
    private boolean activateAutoloader = true;
    private String user;
    private String password;
    private int jmxRMIConnectorPort;
    private int webservicePort = 9001;
    private String webservicePrefix = "petals/ws";
    private String routerQOS = "fast";
    private String routerStrategy = "highest,3,2,1";
    private short routerSendAttempt = (short)2;
    private int routerSendDelay = 1000;
    private long topologyUpdatePeriod = 30L;
    private int tcpPort;
    private String sslKeyPassword;
    private int transporterQueueMaxSize = 10000;
    private long transporterQueueOfferingTimeout = 2500L;
    private int tcpReceivers = 10;
    private int tcpSenders = 10;
    private long tcpConnectionTimeout = 5000L;
    private long tcpSendTimeout = 5000L;
    private long tcpSenderEvictorDelay = 60000L;
    private long tcpSenderEvictableDelay = 60000L;
    private String sslKeystore;
    private String sslKeystorePassword;
    private String sslTruststore;
    private String sslTruststorePassword;
    private int registryPort;
    private RegistryMode registryMode;
    private int registrySynchroPeriod;
    private int registryTransportTimeout;
    private String registryRepository;
    private String registryDatabaseDriver = "org.hsqldb.jdbcDriver";
    private String registryDatabaseUrl;
    private String registryDatabaseUser = "SA";
    private String registryDatabasePassword = "";
    private String registryDatabaseDialect;
    private long persistenceDuration = 3600000L;
    private int persistenceFetchSize = 10;
    private int recoveryCorePoolSize = 5;
    private int recoveryMaxPoolSize = 5;
    private long recoveryKeepAliveTime = 60L;
    private Map<String, String> userConfiguration;

    public static long getSerialVersionUID() {
        return 6543213857L;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        boolean bl = false;
        if (object instanceof ContainerConfiguration) {
            ContainerConfiguration containerConfiguration = (ContainerConfiguration)object;
            bl = containerConfiguration.getName().equals(this.getName()) && containerConfiguration.getHost().equals(this.getHost()) && containerConfiguration.isExchangeValidation() == this.isExchangeValidation() && containerConfiguration.getRouterQOS().equals(this.getRouterQOS()) && containerConfiguration.getRouterStrategy().equals(this.getRouterStrategy()) && containerConfiguration.getTaskTimeout() == this.getTaskTimeout() && containerConfiguration.isIsolateJBIClassLoaders() == this.isIsolateJBIClassLoaders() && containerConfiguration.isActivateAutoloader() == this.isActivateAutoloader() && containerConfiguration.getUser().equals(this.getUser()) && containerConfiguration.getPassword().equals(this.getPassword()) && containerConfiguration.getJmxRMIConnectorPort() == this.getJmxRMIConnectorPort() && containerConfiguration.getTCPPort() == this.getTCPPort() && containerConfiguration.getRegistryMode() == this.getRegistryMode() && containerConfiguration.getTCPReceivers() == this.getTCPReceivers() && containerConfiguration.getTCPSenders() == this.getTCPSenders() && containerConfiguration.getTCPConnectionTimeout() == this.getTCPConnectionTimeout() && containerConfiguration.getTCPSendTimeout() == this.getTCPSendTimeout() && containerConfiguration.getTCPSenderEvictorDelay() == this.getTCPSenderEvictorDelay() && containerConfiguration.getTCPSenderEvictableDelay() == this.getTCPSenderEvictableDelay() && containerConfiguration.getSSLKeyPassword().equals(this.getSSLKeyPassword()) && containerConfiguration.getSSLKeystore().equals(this.getSSLKeystore()) && containerConfiguration.getSSLKeystorePassword().equals(this.getSSLKeystorePassword()) && containerConfiguration.getSSLTruststore().equals(this.getSSLTruststore()) && containerConfiguration.getSSLTruststorePassword().equals(this.getSSLTruststorePassword()) && containerConfiguration.getWebservicePort() == this.getWebservicePort() && containerConfiguration.getWebservicePrefix().equals(this.getWebservicePrefix()) && containerConfiguration.getRegistryPort() == this.getRegistryPort() && containerConfiguration.getRegistryMode().equals((Object)this.getRegistryMode()) && containerConfiguration.getRegistrySynchroPeriod() == this.getRegistrySynchroPeriod() && containerConfiguration.getRegistryTransportTimeout() == this.getRegistryTransportTimeout() && containerConfiguration.getRegistryRepository().equals(this.getRegistryRepository()) && containerConfiguration.getRegistryDatabaseDriver().equals(this.getRegistryDatabaseDriver()) && containerConfiguration.getRegistryDatabaseUrl().equals(this.getRegistryDatabaseUrl()) && containerConfiguration.getRegistryDatabaseUser().equals(this.getRegistryDatabaseUser()) && containerConfiguration.getRegistryDatabasePassword().equals(this.getRegistryDatabasePassword()) && containerConfiguration.getRegistryDatabaseDialect().equals(this.getRegistryDatabaseDialect()) && (containerConfiguration.getUserConfiguration() == this.getUserConfiguration() || containerConfiguration.getUserConfiguration() != null && containerConfiguration.getUserConfiguration().equals(this.getUserConfiguration())) && containerConfiguration.getTopologyUpdatePeriod() == this.getTopologyUpdatePeriod() && containerConfiguration.getPersistenceDuration() == this.getPersistenceDuration();
        }
        return bl;
    }

    public String getDescription() {
        return this.description;
    }

    public String getHost() {
        return this.host;
    }

    public int getJmxRMIConnectorPort() {
        return this.jmxRMIConnectorPort;
    }

    public String getName() {
        return this.name;
    }

    public String getPassword() {
        return this.password;
    }

    public long getPersistenceDuration() {
        return this.persistenceDuration;
    }

    public int getPersistenceFetchSize() {
        return this.persistenceFetchSize;
    }

    public String getRegistryDatabaseDialect() {
        return this.registryDatabaseDialect;
    }

    public String getRegistryDatabaseDriver() {
        return this.registryDatabaseDriver;
    }

    public String getRegistryDatabasePassword() {
        return this.registryDatabasePassword;
    }

    public String getRegistryDatabaseUrl() {
        return this.registryDatabaseUrl;
    }

    public String getRegistryDatabaseUser() {
        return this.registryDatabaseUser;
    }

    public RegistryMode getRegistryMode() {
        return this.registryMode;
    }

    public int getRegistryPort() {
        return this.registryPort;
    }

    public String getRegistryRepository() {
        return this.registryRepository;
    }

    public int getRegistrySynchroPeriod() {
        return this.registrySynchroPeriod;
    }

    public int getRegistryTransportTimeout() {
        return this.registryTransportTimeout;
    }

    public String getRepositoryDirectoryPath() {
        return this.repositoryDirectoryPath;
    }

    public String getRootDirectoryPath() {
        return this.rootDirectoryPath;
    }

    public String getRouterQOS() {
        return this.routerQOS;
    }

    public short getRouterSendAttempt() {
        return this.routerSendAttempt;
    }

    public int getRouterSendDelay() {
        return this.routerSendDelay;
    }

    public String getRouterStrategy() {
        return this.routerStrategy;
    }

    public String getSSLKeyPassword() {
        return this.sslKeyPassword;
    }

    public String getSSLKeystore() {
        return this.sslKeystore;
    }

    public String getSSLKeystorePassword() {
        return this.sslKeystorePassword;
    }

    public String getSSLTruststore() {
        return this.sslTruststore;
    }

    public String getSSLTruststorePassword() {
        return this.sslTruststorePassword;
    }

    public ContainerState getState() {
        return this.state;
    }

    public String getSubdomainName() {
        return this.subdomainName;
    }

    public long getTaskTimeout() {
        return this.taskTimeout;
    }

    public long getTCPConnectionTimeout() {
        return this.tcpConnectionTimeout;
    }

    public int getTCPPort() {
        return this.tcpPort;
    }

    public int getTCPReceivers() {
        return this.tcpReceivers;
    }

    public long getTCPSenderEvictableDelay() {
        return this.tcpSenderEvictableDelay;
    }

    public long getTCPSenderEvictorDelay() {
        return this.tcpSenderEvictorDelay;
    }

    public int getTCPSenders() {
        return this.tcpSenders;
    }

    public long getTCPSendTimeout() {
        return this.tcpSendTimeout;
    }

    public long getTopologyUpdatePeriod() {
        return this.topologyUpdatePeriod;
    }

    public String getUser() {
        return this.user;
    }

    public Map<String, String> getUserConfiguration() {
        return this.userConfiguration;
    }

    public int getWebservicePort() {
        return this.webservicePort;
    }

    public String getWebservicePrefix() {
        return this.webservicePrefix;
    }

    public String getWorkDirectoryPath() {
        return this.workDirectoryPath;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.isActivateAutoloader() ? 1231 : 1237);
        n = 31 * n + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        n = 31 * n + this.getTCPPort();
        n = 31 * n + this.getTCPReceivers();
        n = 31 * n + this.getTCPSenders();
        n = 31 * n + (int)(this.getTCPConnectionTimeout() ^ this.getTCPConnectionTimeout() >>> 32);
        n = 31 * n + (int)(this.getTCPSendTimeout() ^ this.getTCPSendTimeout() >>> 32);
        n = 31 * n + (int)(this.getTCPSenderEvictorDelay() ^ this.getTCPSenderEvictorDelay() >>> 32);
        n = 31 * n + (int)(this.getTCPSenderEvictableDelay() ^ this.getTCPSenderEvictableDelay() >>> 32);
        n = 31 * n + (this.isExchangeValidation() ? 1231 : 1237);
        n = 31 * n + (this.getHost() == null ? 0 : this.getHost().hashCode());
        n = 31 * n + (this.getRootDirectoryPath() == null ? 0 : this.getRootDirectoryPath().hashCode());
        n = 31 * n + (this.isIsolateJBIClassLoaders() ? 1231 : 1237);
        n = 31 * n + this.getJmxRMIConnectorPort();
        n = 31 * n + (this.getSSLKeyPassword() == null ? 0 : this.getSSLKeyPassword().hashCode());
        n = 31 * n + (this.getSSLKeystore() == null ? 0 : this.getSSLKeystore().hashCode());
        n = 31 * n + (this.getSSLKeystorePassword() == null ? 0 : this.getSSLKeystorePassword().hashCode());
        n = 31 * n + (this.getName() == null ? 0 : this.getName().hashCode());
        n = 31 * n + (this.getPassword() == null ? 0 : this.getPassword().hashCode());
        n = 31 * n + (this.getRepositoryDirectoryPath() == null ? 0 : this.getRepositoryDirectoryPath().hashCode());
        n = 31 * n + (this.getRouterStrategy() == null ? 0 : this.getRouterStrategy().hashCode());
        n = 31 * n + (this.getState() == null ? 0 : this.getState().hashCode());
        n = 31 * n + (this.getSubdomainName() == null ? 0 : this.getSubdomainName().hashCode());
        n = 31 * n + (int)(this.getTaskTimeout() ^ this.getTaskTimeout() >>> 32);
        n = 31 * n + (this.getRouterQOS() == null ? 0 : this.getRouterQOS().hashCode());
        n = 31 * n + (this.getSSLTruststore() == null ? 0 : this.getSSLTruststore().hashCode());
        n = 31 * n + (this.getSSLTruststorePassword() == null ? 0 : this.getSSLTruststorePassword().hashCode());
        n = 31 * n + (this.getUser() == null ? 0 : this.getUser().hashCode());
        n = 31 * n + this.getWebservicePort();
        n = 31 * n + (this.getWebservicePrefix() == null ? 0 : this.getWebservicePrefix().hashCode());
        n = 31 * n + (this.getUserConfiguration() == null ? 0 : this.getUserConfiguration().hashCode());
        n = 31 * n + this.getRegistryPort();
        n = 31 * n + (this.getRegistryMode() == null ? 0 : this.getRegistryMode().hashCode());
        n = 31 * n + this.getRegistrySynchroPeriod();
        n = 31 * n + this.getRegistryTransportTimeout();
        n = 31 * n + (this.getRegistryRepository() == null ? 0 : this.getRegistryRepository().hashCode());
        n = 31 * n + (this.getRegistryDatabaseDriver() == null ? 0 : this.getRegistryDatabaseDriver().hashCode());
        n = 31 * n + (this.getRegistryDatabaseUrl() == null ? 0 : this.getRegistryDatabaseUrl().hashCode());
        n = 31 * n + (this.getRegistryDatabaseUser() == null ? 0 : this.getRegistryDatabaseUser().hashCode());
        n = 31 * n + (this.getRegistryDatabasePassword() == null ? 0 : this.getRegistryDatabasePassword().hashCode());
        n = 31 * n + (this.getRegistryDatabaseDialect() == null ? 0 : this.getRegistryDatabaseDialect().hashCode());
        n = 31 * n + (int)this.getTopologyUpdatePeriod();
        n = 31 * n + (int)this.getPersistenceDuration();
        return n;
    }

    public void init() throws ConfigurationException {
        try {
            this.setRootDirectoryPath(SystemUtil.getPetalsInstallDirectory().getCanonicalPath());
        }
        catch (IOException iOException) {
            throw new ConfigurationException("The PEtALS install directory is not valid : " + SystemUtil.getPetalsInstallDirectory().getAbsolutePath());
        }
        this.repositoryDirectoryPath = String.valueOf(this.getRootDirectoryPath()) + File.separator + "repository";
        this.workDirectoryPath = String.valueOf(this.getRootDirectoryPath()) + File.separator + "work";
        this.registryDatabaseUrl = "jdbc:hsqldb:file:" + this.workDirectoryPath + File.separator + "persistenceService;shutdown=true";
    }

    public boolean isActivateAutoloader() {
        return this.activateAutoloader;
    }

    public boolean isExchangeValidation() {
        return this.exchangeValidation;
    }

    public boolean isInFloodingMode() {
        return this.isPeer();
    }

    public boolean isInMasterSlaveMode() {
        return this.isMaster() || this.isSlave();
    }

    public boolean isInStandaloneMode() {
        return this.isStandalone();
    }

    public boolean isIsolateJBIClassLoaders() {
        return this.isolateJBIClassLoaders;
    }

    public boolean isMaster() {
        return this.getRegistryMode().equals((Object)RegistryMode.MASTER);
    }

    public boolean isPeer() {
        return this.getRegistryMode().equals((Object)RegistryMode.PEER);
    }

    public boolean isSlave() {
        return this.getRegistryMode().equals((Object)RegistryMode.SLAVE);
    }

    public boolean isStandalone() {
        return this.getRegistryMode().equals((Object)RegistryMode.STANDALONE);
    }

    public String toString() {
        StringBuffer stringBuffer;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Container ").append(this.getName()).append(" on ").append(this.getHost()).append(" in sub-domain ").append(this.getSubdomainName());
        if (this.getDescription() != null) {
            stringBuilder.append("\n\t\t\tDescription :\n\t\t\t  ").append(this.getDescription());
        }
        stringBuilder.append("\n\t\t\tConfiguration :\n\t\t\t  - InstallDirectory:").append(this.getRootDirectoryPath());
        stringBuilder.append("\n\t\t\t  - RepositoryDirectory:").append(this.getRepositoryDirectoryPath());
        stringBuilder.append("\n\t\t\t  - ExchangeValidation:").append(this.isExchangeValidation());
        stringBuilder.append("\n\t\t\t  - RouterQOS:").append(this.getRouterQOS());
        stringBuilder.append("\n\t\t\t  - RoutingStrategy:").append(this.getRouterStrategy());
        stringBuilder.append("\n\t\t\t  - TaskTimeout:").append(this.getTaskTimeout());
        stringBuilder.append("\n\t\t\t  - IsolateClassLoaders:").append(this.isIsolateJBIClassLoaders());
        stringBuilder.append("\n\t\t\t  - ActivateAutoloader:").append(this.isActivateAutoloader());
        stringBuilder.append("\n\t\t\t  - User:").append(this.getUser() != null ? this.getUser() : "none");
        if (this.getPassword() != null) {
            stringBuffer = new StringBuffer(this.getPassword().length());
            while (stringBuffer.length() < this.getPassword().length()) {
                stringBuffer.append("*");
            }
            stringBuilder.append("\n\t\t\t  - Password:").append(stringBuffer);
        } else {
            stringBuilder.append("\n\t\t\t  - Password:none");
        }
        stringBuilder.append("\n\t\t\t  - JMXRMIConnectionPort:").append(this.getJmxRMIConnectorPort());
        stringBuilder.append("\n\t\t\t  - TCPPort:").append(this.getTCPPort() != 0 ? Integer.valueOf(this.getTCPPort()) : "none");
        if (this.getSSLKeyPassword() != null) {
            stringBuffer = new StringBuffer(this.getSSLKeyPassword().length());
            while (stringBuffer.length() < this.getSSLKeyPassword().length()) {
                stringBuffer.append("*");
            }
            stringBuilder.append("\n\t\t\t  - sslKeyPassword:").append(stringBuffer);
        } else {
            stringBuilder.append("\n\t\t\t  - sslKeyPassword:none");
        }
        stringBuilder.append("\n\t\t\t  - Keystore:").append(this.getSSLKeystore() != null ? this.getSSLKeystore() : "none");
        if (this.getSSLKeystorePassword() != null) {
            stringBuffer = new StringBuffer(this.getSSLKeystorePassword().length());
            while (stringBuffer.length() < this.getSSLKeystorePassword().length()) {
                stringBuffer.append("*");
            }
            stringBuilder.append("\n\t\t\t  - KeystorePassword:").append(stringBuffer);
        } else {
            stringBuilder.append("\n\t\t\t  - KeystorePassword:none");
        }
        stringBuilder.append("\n\t\t\t  - Truststore:").append(this.getSSLTruststore() != null ? this.getSSLTruststore() : "none");
        if (this.getSSLTruststorePassword() != null) {
            stringBuffer = new StringBuffer(this.getSSLTruststorePassword().length());
            while (stringBuffer.length() < this.getSSLTruststorePassword().length()) {
                stringBuffer.append("*");
            }
            stringBuilder.append("\n\t\t\t  - TruststorePassword:").append(stringBuffer);
        } else {
            stringBuilder.append("\n\t\t\t  - TruststorePassword:none");
        }
        if (this.getTCPPort() != 0) {
            stringBuilder.append("\n\t\t\t  - TCPReceivers:").append(this.getTCPReceivers());
            stringBuilder.append("\n\t\t\t  - TCPSenders:").append(this.getTCPSenders());
            stringBuilder.append("\n\t\t\t  - TCPConnectionTimeout:").append(this.getTCPConnectionTimeout());
            stringBuilder.append("\n\t\t\t  - TCPSendTimeout:").append(this.getTCPSendTimeout());
            stringBuilder.append("\n\t\t\t  - TCPSenderEvictorDelay:").append(this.getTCPSenderEvictorDelay());
            stringBuilder.append("\n\t\t\t  - TCPSenderEvictableDelay:").append(this.getTCPSenderEvictableDelay());
        }
        stringBuilder.append("\n\t\t\t  - State:").append(this.getState().name());
        stringBuilder.append("\n\t\t\t  - RegistryPort:").append(this.getRegistryPort());
        stringBuilder.append("\n\t\t\t  - RegistryMode:").append((Object)this.getRegistryMode());
        stringBuilder.append("\n\t\t\t  - RegistrySynchroPeriod:").append(this.getRegistrySynchroPeriod());
        stringBuilder.append("\n\t\t\t  - RegistryTransportTimeout:").append(this.getRegistryTransportTimeout());
        stringBuilder.append("\n\t\t\t  - RegistryRepository:").append(this.getRegistryRepository());
        stringBuilder.append("\n\t\t\t  - RegistryDatabaseDriver:").append(this.getRegistryDatabaseDriver());
        stringBuilder.append("\n\t\t\t  - RegistryDatabaseUrl:").append(this.getRegistryDatabaseUrl());
        stringBuilder.append("\n\t\t\t  - RegistryDatabaseUser:").append(this.getRegistryDatabaseUser());
        if (this.getRegistryDatabasePassword() != null) {
            stringBuffer = new StringBuffer(this.getRegistryDatabasePassword().length());
            while (stringBuffer.length() < this.getRegistryDatabasePassword().length()) {
                stringBuffer.append("*");
            }
            stringBuilder.append("\n\t\t\t  - RegistryDatabasePassword:").append(stringBuffer);
        } else {
            stringBuilder.append("\n\t\t\t  - RegistryDatabasePassword:none");
        }
        stringBuilder.append("\n\t\t\t  - RegistryDatabaseDialect:").append(this.getRegistryDatabaseDialect());
        stringBuilder.append("\n\t\t\t  - WebServicePort:").append(this.getWebservicePort());
        stringBuilder.append("\n\t\t\t  - WebServicePrefix:").append(this.getWebservicePrefix());
        stringBuilder.append("\n\t\t\t  - Topology update period:").append(this.getTopologyUpdatePeriod());
        stringBuilder.append("\n\t\t\t  - Persistence duration:").append(this.getPersistenceDuration());
        if (this.getUserConfiguration() != null) {
            stringBuffer = new StringBuffer();
            for (String string : this.getUserConfiguration().keySet()) {
                stringBuffer.append("\n\t\t\t\t").append(string).append('=').append(this.getUserConfiguration().get(string));
            }
            stringBuilder.append("\n\t\t\t  - User properties:").append(stringBuffer.toString());
        }
        return stringBuilder.toString();
    }

    public void setActivateAutoloader(boolean bl) {
        this.activateAutoloader = bl;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setExchangeValidation(boolean bl) {
        this.exchangeValidation = bl;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public void setIsolateJBIClassLoaders(boolean bl) {
        this.isolateJBIClassLoaders = bl;
    }

    public void setJmxRMIConnectorPort(int n) {
        this.jmxRMIConnectorPort = n;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setPersistenceDuration(long l) {
        this.persistenceDuration = l;
    }

    public void setPersistenceFetchSize(int n) {
        this.persistenceFetchSize = n;
    }

    public void setRegistryDatabaseDialect(String string) {
        this.registryDatabaseDialect = string;
    }

    public void setRegistryDatabaseDriver(String string) {
        this.registryDatabaseDriver = string;
    }

    public void setRegistryDatabasePassword(String string) {
        this.registryDatabasePassword = string;
    }

    public void setRegistryDatabaseUrl(String string) {
        this.registryDatabaseUrl = string;
    }

    public void setRegistryDatabaseUser(String string) {
        this.registryDatabaseUser = string;
    }

    public void setRegistryMode(RegistryMode registryMode) {
        this.registryMode = registryMode;
    }

    public void setRegistryPort(int n) {
        this.registryPort = n;
    }

    public void setRegistryRepository(String string) {
        this.registryRepository = string;
    }

    public void setRegistrySynchroPeriod(int n) {
        this.registrySynchroPeriod = n;
    }

    public void setRegistryTransportTimeout(int n) {
        this.registryTransportTimeout = n;
    }

    public void setRepositoryDirectoryPath(String string) {
        this.repositoryDirectoryPath = string;
    }

    public void setRootDirectoryPath(String string) {
        this.rootDirectoryPath = string;
    }

    public void setRouterQOS(String string) {
        this.routerQOS = string;
    }

    public void setRouterSendAttempt(short s) {
        this.routerSendAttempt = s;
    }

    public void setRouterSendDelay(int n) {
        this.routerSendDelay = n;
    }

    public void setRouterStrategy(String string) {
        this.routerStrategy = string;
    }

    public void setSslKeyPassword(String string) {
        this.sslKeyPassword = string;
    }

    public void setSSLKeyPassword(String string) {
        this.setSslKeyPassword(string);
    }

    public void setSslKeystore(String string) {
        this.sslKeystore = string;
    }

    public void setSSLKeystore(String string) {
        this.setSslKeystore(string);
    }

    public void setSslKeystorePassword(String string) {
        this.sslKeystorePassword = string;
    }

    public void setSSLKeystorePassword(String string) {
        this.setSslKeystorePassword(string);
    }

    public void setSslTruststore(String string) {
        this.sslTruststore = string;
    }

    public void setSSLTruststore(String string) {
        this.setSslTruststore(string);
    }

    public void setSslTruststorePassword(String string) {
        this.sslTruststorePassword = string;
    }

    public void setSSLTruststorePassword(String string) {
        this.setSslTruststorePassword(string);
    }

    public void setState(ContainerState containerState) {
        this.state = containerState;
    }

    public void setSubdomainName(String string) {
        this.subdomainName = string;
    }

    public void setTaskTimeout(long l) {
        this.taskTimeout = l;
    }

    public void setTcpConnectionTimeout(long l) {
        this.tcpConnectionTimeout = l;
    }

    public void setTCPConnectionTimeout(long l) {
        this.setTcpConnectionTimeout(l);
    }

    public void setTcpPort(int n) {
        this.tcpPort = n;
    }

    public void setTCPPort(int n) {
        this.setTcpPort(n);
    }

    public void setTcpReceivers(int n) {
        this.tcpReceivers = n;
    }

    public void setTCPReceivers(int n) {
        this.setTcpReceivers(n);
    }

    public void setTcpSenderEvictableDelay(long l) {
        this.tcpSenderEvictableDelay = l;
    }

    public void setTCPSenderEvictableDelay(long l) {
        this.setTcpSenderEvictableDelay(l);
    }

    public void setTcpSenderEvictorDelay(long l) {
        this.tcpSenderEvictorDelay = l;
    }

    public void setTCPSenderEvictorDelay(long l) {
        this.setTcpSenderEvictorDelay(l);
    }

    public void setTcpSenders(int n) {
        this.tcpSenders = n;
    }

    public void setTCPSenders(int n) {
        this.setTcpSenders(n);
    }

    public void setTcpSendTimeout(long l) {
        this.tcpSendTimeout = l;
    }

    public void setTCPSendTimeout(long l) {
        this.setTcpSendTimeout(l);
    }

    public void setTopologyUpdatePeriod(long l) {
        this.topologyUpdatePeriod = l;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public void setUserConfiguration(Map<String, String> map) {
        this.userConfiguration = map;
    }

    public void setWebservicePort(int n) {
        this.webservicePort = n;
    }

    public void setWebservicePrefix(String string) {
        this.webservicePrefix = string;
    }

    public void setWorkDirectoryPath(String string) {
        this.workDirectoryPath = string;
    }

    public int getRecoveryCorePoolSize() {
        return this.recoveryCorePoolSize;
    }

    public void setRecoveryCorePoolSize(int n) {
        this.recoveryCorePoolSize = n;
    }

    public int getRecoveryMaxPoolSize() {
        return this.recoveryMaxPoolSize;
    }

    public void setRecoveryMaxPoolSize(int n) {
        this.recoveryMaxPoolSize = n;
    }

    public long getRecoveryKeepAliveTime() {
        return this.recoveryKeepAliveTime;
    }

    public void setRecoveryKeepAliveTime(long l) {
        this.recoveryKeepAliveTime = l;
    }

    public int getTransporterQueueMaxSize() {
        return this.transporterQueueMaxSize;
    }

    public void setTransporterQueueMaxSize(int n) {
        this.transporterQueueMaxSize = n;
    }

    public long getTransporterQueueOfferingTimeout() {
        return this.transporterQueueOfferingTimeout;
    }

    public void setTransporterQueueOfferingTimeout(long l) {
        this.transporterQueueOfferingTimeout = l;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ContainerState {
        STARTED,
        STOPPED,
        UNKNOWN;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RegistryMode {
        STANDALONE,
        PEER,
        MASTER,
        SLAVE;

    }
}

