/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.kernel.configuration;

import org.ow2.petals.kernel.configuration.ContainerConfiguration;
import org.ow2.petals.topology.generated.Container;
import org.ow2.petals.topology.generated.RegistryService;
import org.ow2.petals.topology.generated.TransportService;
import org.ow2.petals.topology.generated.WebServiceService;

public class ContainerConfigurationHelper {
    public static final void fill(ContainerConfiguration containerConfiguration, Container container) {
        WebServiceService webServiceService;
        RegistryService registryService;
        TransportService transportService;
        containerConfiguration.setName(container.getName());
        containerConfiguration.setDescription(container.getDescription());
        containerConfiguration.setUser(container.getUser());
        containerConfiguration.setPassword(container.getPassword());
        if (container.getHost() != null) {
            containerConfiguration.setHost(container.getHost());
        }
        if (container.getType() != null) {
            switch (container.getType()) {
                case MASTER: {
                    containerConfiguration.setRegistryMode(ContainerConfiguration.RegistryMode.MASTER);
                    break;
                }
                case SLAVE: {
                    containerConfiguration.setRegistryMode(ContainerConfiguration.RegistryMode.SLAVE);
                    break;
                }
                case PEER: {
                    containerConfiguration.setRegistryMode(ContainerConfiguration.RegistryMode.PEER);
                    break;
                }
                case STANDALONE: {
                    containerConfiguration.setRegistryMode(ContainerConfiguration.RegistryMode.STANDALONE);
                }
            }
        }
        if (container.getJmxService() != null) {
            containerConfiguration.setJmxRMIConnectorPort(container.getJmxService().getRmiPort());
        }
        if ((transportService = container.getTransportService()) != null) {
            containerConfiguration.setTCPPort(transportService.getTcpPort());
        }
        if ((registryService = container.getRegistryService()) != null && registryService.getPort() != null) {
            containerConfiguration.setRegistryPort(registryService.getPort());
        }
        if ((webServiceService = container.getWebserviceService()) != null) {
            if (webServiceService.getPort() != 0) {
                containerConfiguration.setWebservicePort(webServiceService.getPort());
            }
            if (webServiceService.getPrefix() != null) {
                containerConfiguration.setWebservicePrefix(webServiceService.getPrefix());
            }
        }
    }
}

