/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.system.classloader;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.kernel.api.server.PetalsException;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.system.classloader.ClassLoaderService;
import org.ow2.petals.system.classloader.ComponentClassLoader;
import org.ow2.petals.system.classloader.PetalsClassLoader;
import org.ow2.petals.system.classloader.SharedLibrariesClassLoader;
import org.ow2.petals.system.classloader.SharedLibraryClassLoader;
import org.ow2.petals.util.LoggingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=ClassLoaderService.class)})
public class ClassLoaderServiceImpl
implements BindingController,
LifeCycleController,
ClassLoaderService {
    private LoggerFactory loggerFactory;
    public static final String COMMON_LOADER = "common";
    private SharedLibrariesClassLoader sharedLibrariesClassLoader;
    private Map<String, PetalsClassLoader> classLoaders = new HashMap<String, PetalsClassLoader>();
    private ClassLoader parentClassLoader;
    LoggingUtil log;
    protected Logger logger;
    @Requires(name="configuration", signature=ConfigurationService.class)
    private ConfigurationService configurationService;

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @Override
    public boolean containsClassLoader(String string) {
        this.log.call();
        return this.classLoaders.containsKey(string);
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    @Override
    public URLClassLoader createComponentClassLoader(String string, URL[] uRLArray, List<String> list, boolean bl, List<String> list2) throws PetalsException {
        this.log.start();
        ComponentClassLoader componentClassLoader = null;
        try {
            componentClassLoader = new ComponentClassLoader(uRLArray, list, this.sharedLibrariesClassLoader, list2);
            componentClassLoader.setParentFirst(bl);
        }
        catch (IOException iOException) {
            throw new PetalsException("Error while creating a PEtALS class loader", (Throwable)iOException);
        }
        this.classLoaders.put(string, componentClassLoader);
        this.log.end();
        return componentClassLoader;
    }

    @Override
    public URLClassLoader createSharedLibraryClassLoader(String string, URL[] uRLArray, List<String> list, boolean bl) throws PetalsException {
        this.log.start();
        SharedLibraryClassLoader sharedLibraryClassLoader = null;
        try {
            sharedLibraryClassLoader = new SharedLibraryClassLoader(uRLArray, list, this.parentClassLoader);
            sharedLibraryClassLoader.setParentFirst(bl);
        }
        catch (IOException iOException) {
            throw new PetalsException("Error while creating a class loader", (Throwable)iOException);
        }
        this.classLoaders.put(string, sharedLibraryClassLoader);
        this.sharedLibrariesClassLoader.addSharedLibraryClassLoader(string, sharedLibraryClassLoader);
        this.log.end();
        return sharedLibraryClassLoader;
    }

    @Override
    public void deleteClassLoader(String string) {
        this.log.start();
        if (!this.containsClassLoader(string)) {
            this.log.warning((Object)("No classloader with Id " + string + " loaded. Can not remove it"));
            return;
        }
        PetalsClassLoader petalsClassLoader = this.classLoaders.remove(string);
        if (petalsClassLoader instanceof SharedLibraryClassLoader) {
            this.sharedLibrariesClassLoader.removeSharedLibraryClassLoader(string);
        }
        petalsClassLoader.close();
        this.log.end();
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.start();
        boolean bl = this.configurationService.getContainerConfiguration().isIsolateJBIClassLoaders();
        this.parentClassLoader = bl ? ClassLoader.getSystemClassLoader() : ClassLoaderServiceImpl.class.getClassLoader();
        this.classLoaders = new HashMap<String, PetalsClassLoader>();
        this.sharedLibrariesClassLoader = new SharedLibrariesClassLoader(this.parentClassLoader);
        this.log.end();
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.start();
        for (String string : this.classLoaders.keySet()) {
            this.sharedLibrariesClassLoader.removeSharedLibraryClassLoader(string);
            this.classLoaders.get(string).close();
        }
        this.classLoaders = null;
        this.sharedLibrariesClassLoader = null;
        this.parentClassLoader = null;
        this.log.end();
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configurationService = (ConfigurationService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("configuration");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

