/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.system.classloader;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarFile;
import org.ow2.petals.system.classloader.factory.URLFactory;
import org.ow2.petals.system.classloader.locator.LocatorAbstract;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PetalsClassLoader
extends URLClassLoader {
    private static final String JAVA_PACKAGE = "java.";
    private static final String JAVAX_PACKAGE = "javax.";
    private final URL[] bases;
    private URLFactory[] factories;
    private Set<String> localKnownPackages;
    private LocatorAbstract[] locators;
    private boolean parentFirst;
    private boolean usePackageIntelligence;

    public PetalsClassLoader(URL[] uRLArray, List<String> list) throws IOException {
        super(uRLArray, ClassLoader.getSystemClassLoader());
        this.bases = uRLArray;
        this.initialize(list);
    }

    public PetalsClassLoader(URL[] uRLArray, List<String> list, ClassLoader classLoader) throws IOException {
        super(uRLArray, classLoader);
        this.bases = uRLArray;
        this.initialize(list);
    }

    public PetalsClassLoader(URL[] uRLArray, List<String> list, ClassLoader classLoader, URLStreamHandlerFactory uRLStreamHandlerFactory) throws IOException {
        super(uRLArray, classLoader, uRLStreamHandlerFactory);
        this.bases = uRLArray;
        this.initialize(list);
    }

    @Override
    public void close() {
        if (System.getProperty("java.vm.vendor").contains("Sun Microsystems")) {
            try {
                Class<?> clazz = this.getClass();
                while (!clazz.getSimpleName().equals("URLClassLoader")) {
                    clazz = clazz.getSuperclass();
                }
                Field field = clazz.getDeclaredField("ucp");
                field.setAccessible(true);
                Object object = field.get(this);
                Field field2 = object.getClass().getDeclaredField("loaders");
                field2.setAccessible(true);
                List list = (List)field2.get(object);
                for (Object e : list) {
                    try {
                        Field field3 = e.getClass().getDeclaredField("jar");
                        field3.setAccessible(true);
                        JarFile jarFile = (JarFile)field3.get(e);
                        jarFile.close();
                    }
                    catch (NoSuchFieldException noSuchFieldException) {}
                }
            }
            catch (Throwable throwable) {}
        }
    }

    public URL[] getBases() {
        return this.bases;
    }

    public String getClasspath() {
        URL[] uRLArray = this.getURLs();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < uRLArray.length) {
            String string = uRLArray[n].getFile();
            if (string.indexOf("!/") == -1) {
                stringBuffer.append(String.valueOf(File.pathSeparator) + string);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    @Override
    public URL getResource(String string) {
        URL uRL = null;
        if (this.useParentFirst(string, false)) {
            uRL = this.getParent().getResource(string);
            if (uRL == null) {
                uRL = this.findResource(string);
            }
        } else {
            uRL = this.findResource(string);
            if (uRL == null) {
                uRL = this.getParent().getResource(string);
            }
        }
        return uRL;
    }

    @Override
    public InputStream getResourceAsStream(String string) {
        InputStream inputStream = null;
        if (this.useParentFirst(string, false)) {
            inputStream = this.getParent().getResourceAsStream(string);
            if (inputStream == null) {
                URL uRL = this.findResource(string);
                inputStream = this.getStream(uRL);
            }
        } else {
            URL uRL = this.findResource(string);
            if (uRL == null) {
                uRL = this.getParent().getResource(string);
            }
            inputStream = this.getStream(uRL);
        }
        return inputStream;
    }

    @Override
    public Enumeration<URL> getResources(String string) throws IOException {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        if (this.useParentFirst(string, false)) {
            Enumeration<URL> enumeration = this.getParent().getResources(string);
            while (enumeration.hasMoreElements()) {
                arrayList.add(enumeration.nextElement());
            }
            enumeration = this.findResources(string);
            while (enumeration.hasMoreElements()) {
                arrayList.add(enumeration.nextElement());
            }
        } else {
            Enumeration<URL> enumeration = this.findResources(string);
            while (enumeration.hasMoreElements()) {
                arrayList.add(enumeration.nextElement());
            }
            enumeration = this.getParent().getResources(string);
            while (enumeration.hasMoreElements()) {
                arrayList.add(enumeration.nextElement());
            }
        }
        return Collections.enumeration(arrayList);
    }

    public boolean isParentFirst() {
        return this.parentFirst;
    }

    public boolean isUsingPackageIntelligence() {
        this.localKnownPackages = null;
        return this.usePackageIntelligence;
    }

    public void setParentFirst(boolean bl) {
        this.parentFirst = bl;
    }

    public void setUsingPackageIntelligence(boolean bl) {
        this.localKnownPackages = new HashSet<String>();
        this.usePackageIntelligence = bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Classloader : " + this.getClass().getName() + "\n");
        stringBuffer.append("\tmodules bases (not in loader!) : \n");
        int n = 0;
        while (n < this.bases.length) {
            stringBuffer.append("\t\t -" + this.bases[n] + "\n");
            ++n;
        }
        stringBuffer.append("\trepositories :\n");
        URL[] uRLArray = this.getURLs();
        int n2 = 0;
        while (n2 < uRLArray.length) {
            stringBuffer.append("\t\t -" + uRLArray[n2] + "\n");
            ++n2;
        }
        stringBuffer.append("\tparent : " + this.getParent() + "\n");
        return stringBuffer.toString();
    }

    protected final void addInRepository(String string) throws IOException {
        int n = 0;
        while (n < this.bases.length) {
            if (this.locators[n].hasDirectory(string)) {
                if (string.charAt(string.length() - 1) != '/') {
                    string = String.valueOf(string) + "/";
                }
                this.addURL(this.factories[n].getURL(string));
            } else if (this.locators[n].hasFile(string)) {
                this.addURL(this.factories[n].getURL(string));
            }
            ++n;
        }
    }

    protected void addLocalKnownPackage(String string) {
        if (this.localKnownPackages != null) {
            this.localKnownPackages.add(string);
        }
    }

    protected String getPackageName(String string) {
        int n = string.lastIndexOf(46);
        return string.substring(0, n);
    }

    protected InputStream getStream(URL uRL) {
        InputStream inputStream = null;
        if (uRL != null) {
            try {
                if ("file".equals(uRL.getProtocol())) {
                    inputStream = new FileInputStream(uRL.getPath());
                } else if ("jar".equals(uRL.getProtocol())) {
                    try {
                        String string = uRL.getPath().substring(0, uRL.getPath().indexOf("!"));
                        string = string.substring(5);
                        JarFile jarFile = new JarFile(string);
                        String string2 = uRL.getPath().substring(uRL.getPath().indexOf("!") + 2);
                        string2 = string2.replace("%20", " ");
                        inputStream = jarFile.getInputStream(jarFile.getEntry(string2));
                    }
                    catch (Exception exception) {
                        inputStream = null;
                    }
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                inputStream = null;
            }
        }
        return inputStream;
    }

    protected boolean knowLocalPackage(String string) {
        boolean bl = false;
        if (this.localKnownPackages != null) {
            bl = this.localKnownPackages.contains(string);
        }
        return bl;
    }

    @Override
    protected synchronized Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz = null;
        clazz = this.findLoadedClass(string);
        if (clazz == null) {
            if (this.useParentFirst(string, true)) {
                try {
                    clazz = this.getParent().loadClass(string);
                }
                catch (Throwable throwable) {
                    clazz = this.findClass(string);
                }
            } else {
                try {
                    clazz = this.findClass(string);
                }
                catch (Throwable throwable) {
                    clazz = this.getParent().loadClass(string);
                }
            }
        }
        if (clazz == null) {
            throw new ClassNotFoundException(string);
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    protected boolean useParentFirst(String string, boolean bl) {
        boolean bl2 = this.isParentFirst();
        if (bl2) {
            if (this.isUsingPackageIntelligence() && bl) {
                String string2 = this.getPackageName(string);
                bl2 = !this.knowLocalPackage(string2);
            }
        } else {
            bl2 = string.startsWith(JAVA_PACKAGE) || string.startsWith(JAVAX_PACKAGE);
        }
        return bl2;
    }

    private final void initialize(List<String> list) throws IOException {
        this.parentFirst = true;
        this.usePackageIntelligence = false;
        this.factories = new URLFactory[this.bases.length];
        this.locators = new LocatorAbstract[this.bases.length];
        int n = 0;
        while (n < this.bases.length) {
            this.factories[n] = URLFactory.getFactory(this.bases[n]);
            this.locators[n] = LocatorAbstract.getLocator(this.bases[n]);
            ++n;
        }
        for (String string : list) {
            this.addInRepository(string);
        }
    }
}

