/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.system.classloader;

import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.ow2.petals.system.classloader.SharedLibraryClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedLibrariesClassLoader
extends ClassLoader {
    protected Map<String, SharedLibraryClassLoader> slClassLoaders = new ConcurrentHashMap<String, SharedLibraryClassLoader>();

    public SharedLibrariesClassLoader(ClassLoader classLoader) {
        super(classLoader);
    }

    public void addSharedLibraryClassLoader(String string, SharedLibraryClassLoader sharedLibraryClassLoader) {
        this.slClassLoaders.put(string, sharedLibraryClassLoader);
    }

    public void removeSharedLibraryClassLoader(String string) {
        this.slClassLoaders.remove(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected URL getResource(String string, List<String> list) {
        URL uRL = null;
        if (list != null) {
            List<String> list2 = list;
            synchronized (list2) {
                Iterator<String> iterator = list.iterator();
                while (iterator.hasNext() && uRL == null) {
                    SharedLibraryClassLoader sharedLibraryClassLoader = this.slClassLoaders.get(iterator.next());
                    if (sharedLibraryClassLoader == null) continue;
                    uRL = sharedLibraryClassLoader.getResource(string);
                }
            }
        }
        return uRL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream getResourceAsStream(String string, List<String> list) {
        InputStream inputStream = null;
        if (list != null) {
            List<String> list2 = list;
            synchronized (list2) {
                Iterator<String> iterator = list.iterator();
                while (iterator.hasNext() && inputStream == null) {
                    SharedLibraryClassLoader sharedLibraryClassLoader = this.slClassLoaders.get(iterator.next());
                    if (sharedLibraryClassLoader == null) continue;
                    inputStream = sharedLibraryClassLoader.getResourceAsStream(string);
                }
            }
        }
        return inputStream;
    }

    protected synchronized Class<?> loadClass(String string, boolean bl, List<String> list) throws ClassNotFoundException {
        Class<?> clazz = null;
        if (list != null && !list.isEmpty()) {
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext() && clazz == null) {
                SharedLibraryClassLoader sharedLibraryClassLoader = this.slClassLoaders.get(iterator.next());
                if (sharedLibraryClassLoader == null) continue;
                try {
                    clazz = sharedLibraryClassLoader.loadClass(string, bl);
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
            if (clazz == null) {
                throw new ClassNotFoundException(string);
            }
        } else {
            clazz = super.loadClass(string);
        }
        return clazz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("classloader : " + this.getClass().getName() + "\n");
        Map<String, SharedLibraryClassLoader> map = this.slClassLoaders;
        synchronized (map) {
            stringBuffer.append("\t " + this.slClassLoaders.values());
        }
        return stringBuffer.toString();
    }
}

