/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.system.classloader.locator;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.ow2.petals.system.classloader.locator.LocatorAbstract;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirLocator
extends LocatorAbstract {
    private File file;

    public DirLocator(URL uRL) throws IOException {
        String string = uRL.getFile();
        string = string.replace("%20", " ");
        this.file = new File(string);
        if (!this.file.exists()) {
            throw new IOException("File " + this.file + " does not exists.");
        }
        if (!this.file.isDirectory()) {
            throw new IOException("File " + this.file + " is not a directory.");
        }
    }

    @Override
    public boolean hasDirectory(String string) {
        File file = new File(this.file, string);
        return file.exists() && file.isDirectory();
    }

    @Override
    public boolean hasFile(String string) {
        File file = new File(this.file, string);
        return file.exists() && file.isFile();
    }

    @Override
    public List<String> listContent(String string) {
        File file = new File(this.file, string);
        ArrayList<String> arrayList = new ArrayList<String>();
        if (file.isDirectory()) {
            this.addContent(file, arrayList);
        }
        return arrayList;
    }

    private void addContent(File file, List<String> list) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            int n = 0;
            while (n < fileArray.length) {
                if (fileArray[n].isDirectory()) {
                    this.addContent(fileArray[n], list);
                } else if (fileArray[n].isFile()) {
                    list.add(fileArray[n].getPath().substring(this.file.getPath().length()));
                }
                ++n;
            }
        }
    }
}

