/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.system.persistence;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.jbi.messaging.ExchangeStatus;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.NormalizedMessage;
import javax.xml.namespace.QName;
import org.apache.commons.dbcp.BasicDataSource;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfOperation;
import org.ow2.petals.commons.util.IDGenerator;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.jbi.messaging.exchange.MessageExchangeImpl;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.kernel.configuration.ContainerConfiguration;
import org.ow2.petals.system.persistence.PersistenceService;
import org.ow2.petals.util.LoggingUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=PersistenceService.class)})
public class PersistenceServiceImpl
implements BindingController,
LifeCycleController,
PersistenceService {
    private LoggerFactory loggerFactory;
    private int fetchSize;
    private Timer cleanerTimer;
    @Requires(name="configuration", signature=ConfigurationService.class)
    private ConfigurationService configurationService;
    private String databaseDriver;
    private BasicDataSource jdbcDataSource;
    private LoggingUtil log;
    private Logger logger;
    private long storageDuration;

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void addMessageExchange(MessageExchangeImpl messageExchangeImpl, boolean bl, Boolean bl2) throws IOException, SQLException {
        this.log.call((Object)("ExchangeId : " + messageExchangeImpl.getExchangeId()));
        long l = System.currentTimeMillis();
        Connection connection = this.jdbcDataSource.getConnection();
        try {
            String string;
            PreparedStatement preparedStatement = bl ? connection.prepareStatement("INSERT INTO MESSAGE_EXCHANGE VALUES(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)") : connection.prepareStatement("INSERT INTO MESSAGE_EXCHANGE (EXCHANGE_ID, CONSUMER_ENDPOINT, ENDPOINT, INTERFACE_NAME, SERVICE_NAME, ENDPOINT_NAME, OPERATION_NAME, PATTERN, CREATION_TIMESTAMP) VALUES(?,?,?,?,?,?,?,?,?)");
            preparedStatement.setString(1, messageExchangeImpl.getExchangeId());
            preparedStatement.setObject(2, messageExchangeImpl.getConsumerEndpoint());
            preparedStatement.setObject(3, messageExchangeImpl.getServiceEndpoint());
            if (messageExchangeImpl.getInterfaceName() == null) {
                preparedStatement.setString(4, null);
            } else {
                preparedStatement.setString(4, messageExchangeImpl.getInterfaceName().toString());
            }
            if (messageExchangeImpl.getService() == null) {
                preparedStatement.setString(5, null);
            } else {
                preparedStatement.setString(5, messageExchangeImpl.getService().toString());
            }
            if (messageExchangeImpl.getServiceEndpoint() == null) {
                preparedStatement.setString(6, null);
            } else {
                preparedStatement.setString(6, messageExchangeImpl.getServiceEndpoint().getEndpointName());
            }
            if (messageExchangeImpl.getOperation() == null) {
                preparedStatement.setString(7, null);
            } else {
                preparedStatement.setString(7, messageExchangeImpl.getOperation().toString());
            }
            String string2 = null;
            if (MessageExchangeImpl.IN_ONLY_PATTERN.equals(messageExchangeImpl.getPattern())) {
                string2 = AbsItfOperation.MEPPatternConstants.IN_ONLY.toString();
            } else if (MessageExchangeImpl.ROBUST_IN_ONLY_PATTERN.equals(messageExchangeImpl.getPattern())) {
                string2 = AbsItfOperation.MEPPatternConstants.ROBUST_IN_ONLY.toString();
            } else if (MessageExchangeImpl.IN_OUT_PATTERN.equals(messageExchangeImpl.getPattern())) {
                string2 = AbsItfOperation.MEPPatternConstants.IN_OUT.toString();
            } else if (MessageExchangeImpl.IN_OPTIONAL_OUT_PATTERN.equals(messageExchangeImpl.getPattern())) {
                string2 = AbsItfOperation.MEPPatternConstants.IN_OPTIONAL_OUT.toString();
            }
            preparedStatement.setString(8, string2);
            if (bl) {
                preparedStatement.setObject(9, messageExchangeImpl.getError());
                if (MessageExchange.Role.CONSUMER.equals(messageExchangeImpl.getRole())) {
                    preparedStatement.setShort(10, (short)0);
                } else {
                    preparedStatement.setShort(10, (short)1);
                }
                if (ExchangeStatus.ACTIVE.equals(messageExchangeImpl.getStatus())) {
                    preparedStatement.setShort(11, (short)0);
                } else if (ExchangeStatus.DONE.equals(messageExchangeImpl.getStatus())) {
                    preparedStatement.setShort(11, (short)1);
                } else {
                    preparedStatement.setShort(11, (short)2);
                }
                preparedStatement.setBoolean(12, messageExchangeImpl.isTerminated());
                preparedStatement.setBoolean(13, messageExchangeImpl.isTransacted());
                preparedStatement.setBoolean(14, messageExchangeImpl.isMonitored());
                preparedStatement.setBoolean(15, messageExchangeImpl.isPersisted());
                preparedStatement.setLong(16, l);
            } else {
                preparedStatement.setLong(9, l);
            }
            try {
                preparedStatement.addBatch();
                preparedStatement.execute();
                string = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                preparedStatement.close();
                throw throwable;
            }
            preparedStatement.close();
            if (bl) {
                this.insertMessageExchangeProperties(connection, messageExchangeImpl);
                this.insertNormalizedMessages(connection, messageExchangeImpl);
            }
            if (bl2 != null) {
                string = messageExchangeImpl.getMessage("in") != null ? "in" : (messageExchangeImpl.getMessage("out") != null ? "out" : (messageExchangeImpl.getMessage("fault") != null ? "fault" : (messageExchangeImpl.getError() != null ? "error-ack" : "done-ack")));
                PreparedStatement preparedStatement2 = connection.prepareStatement("INSERT INTO EXCHANGE_TIMESTAMP (EVENT_TIMESTAMP, EXCHANGE_ID, IS_SENT, TYPE) VALUES(?, ?, ?, ?)");
                try {
                    preparedStatement2.setLong(1, l);
                    preparedStatement2.setString(2, messageExchangeImpl.getExchangeId());
                    if ("oracle.jdbc.driver.OracleDriver".equals(this.databaseDriver)) {
                        preparedStatement2.setShort(3, bl2 != false ? (short)1 : 0);
                    } else {
                        preparedStatement2.setBoolean(3, bl2);
                    }
                    preparedStatement2.setString(4, string);
                    preparedStatement2.execute();
                    Object var11_14 = null;
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    preparedStatement2.close();
                    throw throwable;
                }
                preparedStatement2.close();
            }
            Object var13_17 = null;
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            connection.close();
            throw throwable;
        }
        connection.close();
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configurationService = (ConfigurationService)object;
            return;
        }
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("configuration");
        return arrayList.toArray(new String[0]);
    }

    @Override
    public void deleteMessageExchange(String string) throws SQLException {
        this.log.call((Object)("ExchangeId : " + string));
        this.deleteMessageExchangeFromTable("MESSAGE_EXCHANGE_PROPERTY", string);
        this.deleteMessageExchangeFromTable("NORMALIZED_MESSAGE", string);
        this.deleteMessageExchangeFromTable("EXCHANGE_TIMESTAMP", string);
        this.deleteMessageExchangeFromTable("MESSAGE_EXCHANGE", string);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deleteMessageExchangeFromTable(String string, String string2) throws SQLException {
        Connection connection = this.jdbcDataSource.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("DELETE FROM " + string + " WHERE EXCHANGE_ID=?");
            preparedStatement.setString(1, string2);
            try {
                preparedStatement.execute();
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                preparedStatement.close();
                throw throwable;
            }
            {
                Object var5_7 = null;
                preparedStatement.close();
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            connection.close();
            throw throwable;
        }
        {
            Object var7_10 = null;
        }
        connection.close();
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public MessageExchangeImpl getMessageExchange(String string) throws IOException, ClassNotFoundException, SQLException {
        MessageExchangeImpl messageExchangeImpl;
        this.log.call((Object)("ExchangeId : " + string));
        Connection connection = this.jdbcDataSource.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT CONSUMER_ENDPOINT, ENDPOINT, INTERFACE_NAME, SERVICE_NAME, OPERATION_NAME, PATTERN, ERROR, ROLE, STATUS, TTERMINATED, TRANSACTED, MONITORED, PERSISTED FROM MESSAGE_EXCHANGE WHERE EXCHANGE_ID=?");
            try {
                MessageExchangeImpl messageExchangeImpl2;
                preparedStatement.setString(1, string);
                preparedStatement.setFetchSize(this.fetchSize);
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSet.next()) {
                    boolean bl;
                    boolean bl2;
                    boolean bl3;
                    boolean bl4;
                    short s;
                    short s2;
                    Exception exception;
                    String string2;
                    QName qName;
                    QName qName2;
                    Object object;
                    QName qName3;
                    Object object2;
                    ServiceEndpoint serviceEndpoint;
                    ServiceEndpoint serviceEndpoint2;
                    try {
                        serviceEndpoint2 = "org.hsqldb.jdbcDriver".equals(this.databaseDriver) ? (ServiceEndpoint)resultSet.getObject(1) : (ServiceEndpoint)PersistenceServiceImpl.convertInpustStreamToObject(resultSet.getBinaryStream(1));
                        serviceEndpoint = "org.hsqldb.jdbcDriver".equals(this.databaseDriver) ? (ServiceEndpoint)resultSet.getObject(2) : (ServiceEndpoint)PersistenceServiceImpl.convertInpustStreamToObject(resultSet.getBinaryStream(2));
                        object2 = resultSet.getString(3);
                        qName3 = object2 != null ? QName.valueOf((String)object2) : null;
                        object = resultSet.getString(4);
                        qName2 = object != null ? QName.valueOf((String)object) : null;
                        String string3 = resultSet.getString(5);
                        qName = string3 != null ? QName.valueOf(string3) : null;
                        string2 = resultSet.getString(6);
                        exception = "org.hsqldb.jdbcDriver".equals(this.databaseDriver) ? (Exception)resultSet.getObject(7) : (Exception)PersistenceServiceImpl.convertInpustStreamToObject(resultSet.getBinaryStream(7));
                        s2 = resultSet.getShort(8);
                        s = resultSet.getShort(9);
                        bl4 = resultSet.getBoolean(10);
                        bl3 = resultSet.getBoolean(11);
                        bl2 = resultSet.getBoolean(12);
                        bl = resultSet.getBoolean(13);
                    }
                    catch (Throwable throwable) {
                        Object var22_22 = null;
                        resultSet.close();
                        throw throwable;
                    }
                    {
                        Object var22_23 = null;
                    }
                    resultSet.close();
                    object2 = this.getMessageExchangeProperties(connection, string);
                    object = this.getNormalizedMessages(connection, string);
                    try {
                        messageExchangeImpl2 = new MessageExchangeImpl(string, serviceEndpoint2, serviceEndpoint, qName3, qName2, qName, string2, (Map<String, Object>)object2, (Map<String, NormalizedMessage>)object, exception, s2, s, bl4, bl3, bl2, bl);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        messageExchangeImpl2 = null;
                    }
                } else {
                    messageExchangeImpl2 = null;
                }
                messageExchangeImpl = messageExchangeImpl2;
                Object var24_26 = null;
            }
            catch (Throwable throwable) {
                Object var24_27 = null;
                preparedStatement.close();
                throw throwable;
            }
            preparedStatement.close();
            Object var27_28 = null;
        }
        catch (Throwable throwable) {
            Object var27_29 = null;
            connection.close();
            throw throwable;
        }
        connection.close();
        return messageExchangeImpl;
    }

    private static Object convertInpustStreamToObject(InputStream inputStream) throws IOException, ClassNotFoundException {
        Object object;
        if (inputStream != null) {
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            object = objectInputStream.readObject();
            objectInputStream.close();
        } else {
            object = null;
        }
        return object;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, Object> getMessageExchangeProperties(Connection connection, String string) throws IOException, ClassNotFoundException, SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT KKEY, VALUE FROM MESSAGE_EXCHANGE_PROPERTY WHERE EXCHANGE_ID=?");
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            preparedStatement.setString(1, string);
            preparedStatement.setFetchSize(this.fetchSize);
            ResultSet resultSet = preparedStatement.executeQuery();
            try {
                while (resultSet.next()) {
                    if ("org.hsqldb.jdbcDriver".equals(this.databaseDriver)) {
                        hashMap.put(resultSet.getString(1), resultSet.getObject(2));
                        continue;
                    }
                    hashMap.put(resultSet.getString(1), PersistenceServiceImpl.convertInpustStreamToObject(resultSet.getBinaryStream(2)));
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                resultSet.close();
                throw throwable;
            }
            {
                Object var6_8 = null;
                resultSet.close();
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            preparedStatement.close();
            throw throwable;
        }
        {
            Object var8_11 = null;
        }
        preparedStatement.close();
        return hashMap;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, NormalizedMessage> getNormalizedMessages(Connection connection, String string) throws IOException, ClassNotFoundException, SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement("SELECT KKEY, VALUE FROM NORMALIZED_MESSAGE WHERE EXCHANGE_ID=?");
        HashMap<String, NormalizedMessage> hashMap = new HashMap<String, NormalizedMessage>();
        try {
            preparedStatement.setString(1, string);
            preparedStatement.setFetchSize(this.fetchSize);
            ResultSet resultSet = preparedStatement.executeQuery();
            try {
                while (resultSet.next()) {
                    if ("org.hsqldb.jdbcDriver".equals(this.databaseDriver)) {
                        hashMap.put(resultSet.getString(1), (NormalizedMessage)resultSet.getObject(2));
                        continue;
                    }
                    hashMap.put(resultSet.getString(1), (NormalizedMessage)PersistenceServiceImpl.convertInpustStreamToObject(resultSet.getBinaryStream(2)));
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                resultSet.close();
                throw throwable;
            }
            {
                Object var6_8 = null;
                resultSet.close();
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            preparedStatement.close();
            throw throwable;
        }
        {
            Object var8_11 = null;
        }
        preparedStatement.close();
        return hashMap;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Map<String, Long> getMessageExchangeHistory(String string) throws SQLException {
        this.log.call((Object)("ExchangeId : " + string));
        HashMap<String, Long> hashMap = null;
        Connection connection = this.jdbcDataSource.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT EVENT_TIMESTAMP,IS_SENT,TYPE FROM EXCHANGE_TIMESTAMP WHERE EXCHANGE_ID=?");
            try {
                preparedStatement.setString(1, string);
                preparedStatement.setFetchSize(this.fetchSize);
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    while (resultSet.next()) {
                        if (hashMap == null) {
                            hashMap = new HashMap<String, Long>();
                        }
                        String string2 = resultSet.getBoolean(2) ? "sent" : "received";
                        hashMap.put(String.valueOf(resultSet.getString(3)) + "-" + string2, resultSet.getLong(1));
                    }
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    resultSet.close();
                    throw throwable;
                }
                {
                    Object var7_9 = null;
                    resultSet.close();
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                preparedStatement.close();
                throw throwable;
            }
            {
                Object var9_12 = null;
                preparedStatement.close();
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            connection.close();
            throw throwable;
        }
        {
            Object var11_15 = null;
        }
        connection.close();
        return hashMap;
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<String> getMessageExchangeIds(QName var1_1, QName var2_2, String var3_3, QName var4_4, long var5_5, long var7_6) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public int getMessageExchanges(QName var1_1, QName var2_2, String var3_3, QName var4_4, long var5_5, long var7_6) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void setExchangeStorageDuration(long l) {
        this.storageDuration = l;
        this.cleanerTimer.cancel();
        this.cleanerTimer = new Timer();
        this.cleanerTimer.schedule((TimerTask)new PersistenceCleaner(), 0L, this.storageDuration);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void updateMessageExchange(MessageExchangeImpl messageExchangeImpl, boolean bl, Boolean bl2) throws IOException, SQLException {
        this.log.call((Object)("ExchangeId : " + messageExchangeImpl.getExchangeId()));
        Connection connection = this.jdbcDataSource.getConnection();
        try {
            if (!bl) {
                if (!ExchangeStatus.ACTIVE.equals(messageExchangeImpl.getStatus())) {
                    this.updateMessageExchangeStatus(connection, messageExchangeImpl);
                }
            } else {
                this.updateMessageExchange(connection, messageExchangeImpl);
                this.insertMessageExchangeProperties(connection, messageExchangeImpl);
                this.insertNormalizedMessages(connection, messageExchangeImpl);
            }
            if (bl2 != null) {
                int n = 0;
                if (bl2.booleanValue()) {
                    n = 1;
                }
                String string = messageExchangeImpl.getMessage("in") != null ? "in" : (messageExchangeImpl.getMessage("out") != null ? "out" : (messageExchangeImpl.getMessage("fault") != null ? "fault" : (messageExchangeImpl.getError() != null ? "error-ack" : "done-ack")));
                String string2 = null;
                string2 = "org.hsqldb.jdbcDriver".equals(this.databaseDriver) ? (n == 0 ? "false" : "true") : String.valueOf(n);
                PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO EXCHANGE_TIMESTAMP (EVENT_TIMESTAMP, EXCHANGE_ID, IS_SENT, TYPE) VALUES(?,?,?,?)");
                try {
                    preparedStatement.setLong(1, System.currentTimeMillis());
                    preparedStatement.setString(2, messageExchangeImpl.getExchangeId());
                    preparedStatement.setString(3, string2);
                    preparedStatement.setString(4, string);
                    preparedStatement.execute();
                    Object var9_11 = null;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    preparedStatement.close();
                    throw throwable;
                }
                preparedStatement.close();
            }
            Object var11_14 = null;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            connection.close();
            throw throwable;
        }
        connection.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateMessageExchangeStatus(Connection connection, MessageExchangeImpl messageExchangeImpl) throws SQLException {
        short s = ExchangeStatus.DONE.equals(messageExchangeImpl.getStatus()) ? (short)1 : (ExchangeStatus.ERROR.equals(messageExchangeImpl.getStatus()) ? (short)2 : 0);
        PreparedStatement preparedStatement = connection.prepareStatement("UPDATE MESSAGE_EXCHANGE SET STATUS=? WHERE EXCHANGE_ID=?");
        preparedStatement.setShort(1, s);
        preparedStatement.setString(2, messageExchangeImpl.getExchangeId());
        try {
            preparedStatement.execute();
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            preparedStatement.close();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        preparedStatement.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateMessageExchange(Connection connection, MessageExchangeImpl messageExchangeImpl) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement("UPDATE MESSAGE_EXCHANGE SET CONSUMER_ENDPOINT=?, ENDPOINT=?, INTERFACE_NAME=?, SERVICE_NAME=?, ENDPOINT_NAME=?, ERROR=?, ROLE=?, STATUS=?, TTERMINATED=?, TRANSACTED=?, MONITORED=?, PERSISTED=? WHERE EXCHANGE_ID=?");
        try {
            preparedStatement.setObject(1, messageExchangeImpl.getConsumerEndpoint());
            preparedStatement.setObject(2, messageExchangeImpl.getServiceEndpoint());
            preparedStatement.setString(3, messageExchangeImpl.getInterfaceName().toString());
            preparedStatement.setString(4, messageExchangeImpl.getService().toString());
            preparedStatement.setString(5, messageExchangeImpl.getServiceEndpoint().getEndpointName());
            preparedStatement.setObject(6, messageExchangeImpl.getError());
            if (MessageExchange.Role.CONSUMER.equals(messageExchangeImpl.getRole())) {
                preparedStatement.setShort(7, (short)0);
            } else {
                preparedStatement.setShort(7, (short)1);
            }
            if (ExchangeStatus.ACTIVE.equals(messageExchangeImpl.getStatus())) {
                preparedStatement.setShort(8, (short)0);
            } else if (ExchangeStatus.DONE.equals(messageExchangeImpl.getStatus())) {
                preparedStatement.setShort(8, (short)1);
            } else {
                preparedStatement.setShort(8, (short)2);
            }
            preparedStatement.setBoolean(9, messageExchangeImpl.isTerminated());
            preparedStatement.setBoolean(10, messageExchangeImpl.isTransacted());
            preparedStatement.setBoolean(11, messageExchangeImpl.isMonitored());
            preparedStatement.setBoolean(12, messageExchangeImpl.isPersisted());
            preparedStatement.setString(13, messageExchangeImpl.getExchangeId());
            preparedStatement.execute();
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            preparedStatement.close();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        preparedStatement.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void insertMessageExchangeProperties(Connection connection, MessageExchangeImpl messageExchangeImpl) throws IOException, SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO MESSAGE_EXCHANGE_PROPERTY VALUES(?,?,?)");
        try {
            for (Object obj : messageExchangeImpl.getPropertyNames()) {
                preparedStatement.setString(1, messageExchangeImpl.getExchangeId());
                preparedStatement.setString(2, (String)obj);
                if ("org.hsqldb.jdbcDriver".equals(this.databaseDriver)) {
                    preparedStatement.setObject(3, messageExchangeImpl.getProperty((String)obj));
                } else {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    new ObjectOutputStream(byteArrayOutputStream).writeUnshared(messageExchangeImpl.getProperty((String)obj));
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                    preparedStatement.setBinaryStream(3, (InputStream)byteArrayInputStream, byteArrayInputStream.available());
                }
                preparedStatement.addBatch();
            }
            try {
                preparedStatement.executeBatch();
            }
            catch (SQLException sQLException) {}
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            preparedStatement.close();
            throw throwable;
        }
        preparedStatement.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void insertNormalizedMessages(Connection connection, MessageExchangeImpl messageExchangeImpl) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement("INSERT INTO NORMALIZED_MESSAGE VALUES(?,?,?)");
        try {
            for (String string : messageExchangeImpl.getMessages().keySet()) {
                preparedStatement.setString(1, messageExchangeImpl.getExchangeId());
                preparedStatement.setString(2, string);
                preparedStatement.setObject(3, messageExchangeImpl.getMessage(string));
                preparedStatement.addBatch();
            }
            try {
                preparedStatement.executeBatch();
            }
            catch (SQLException sQLException) {}
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            preparedStatement.close();
            throw throwable;
        }
        preparedStatement.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @LifeCycle(on=LifeCycleType.START)
    protected void start() throws SQLException {
        this.log = new LoggingUtil(this.logger);
        this.log.start();
        ContainerConfiguration containerConfiguration = this.configurationService.getContainerConfiguration();
        this.storageDuration = containerConfiguration.getPersistenceDuration();
        this.fetchSize = containerConfiguration.getPersistenceFetchSize();
        this.databaseDriver = containerConfiguration.getRegistryDatabaseDriver();
        this.jdbcDataSource = new BasicDataSource();
        this.jdbcDataSource.setDriverClassName(containerConfiguration.getRegistryDatabaseDriver());
        this.jdbcDataSource.setUrl(containerConfiguration.getRegistryDatabaseUrl());
        this.jdbcDataSource.setUsername(containerConfiguration.getRegistryDatabaseUser());
        this.jdbcDataSource.setPassword(containerConfiguration.getRegistryDatabasePassword());
        Connection connection = this.jdbcDataSource.getConnection();
        try {
            if (!this.jdbcDataSource.getConnection().getMetaData().supportsBatchUpdates()) {
                this.log.error((Object)"The configured database does not support batch update that is required.");
                throw new SQLException("The configured database does not support batch update that is required.");
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            connection.close();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        connection.close();
        {
            this.checkPersistenceTables(this.jdbcDataSource);
        }
        this.cleanerTimer = new Timer();
        this.cleanerTimer.schedule((TimerTask)new PersistenceCleaner(), this.storageDuration, this.storageDuration);
        this.log.end();
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.call();
        this.cleanerTimer.cancel();
        try {
            this.jdbcDataSource.close();
        }
        catch (SQLException sQLException) {
            this.log.debug((Object)sQLException);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void checkPersistenceTables(BasicDataSource basicDataSource) throws SQLException {
        Connection connection;
        Statement statement;
        block13: {
            Statement statement2 = null;
            String string = null;
            statement = null;
            connection = null;
            try {
                try {
                    boolean bl;
                    connection = basicDataSource.getConnection();
                    statement = connection.createStatement();
                    try {
                        statement.executeQuery("SELECT 1 FROM MESSAGE_EXCHANGE");
                        bl = true;
                    }
                    catch (SQLException sQLException) {
                        bl = false;
                    }
                    if (!bl) {
                        this.log.info((Object)"Creating database tables");
                        statement2 = connection.createStatement();
                        if ("org.hsqldb.jdbcDriver".equals(this.databaseDriver)) {
                            statement2.executeUpdate("SET WRITE_DELAY FALSE");
                            string = "CREATE TABLE MESSAGE_EXCHANGE (EXCHANGE_ID VARCHAR(" + IDGenerator.UUID_SIZE + ") PRIMARY KEY, CONSUMER_ENDPOINT OBJECT, ENDPOINT OBJECT, INTERFACE_NAME VARCHAR(255), SERVICE_NAME VARCHAR(255), ENDPOINT_NAME VARCHAR(255), OPERATION_NAME VARCHAR(255), PATTERN VARCHAR(63), ERROR OBJECT, ROLE TINYINT, STATUS TINYINT, TTERMINATED BOOLEAN, TRANSACTED BOOLEAN, MONITORED BOOLEAN, PERSISTED BOOLEAN, CREATION_TIMESTAMP BIGINT)";
                        } else {
                            string = "oracle.jdbc.driver.OracleDriver".equals(this.databaseDriver) ? "CREATE TABLE MESSAGE_EXCHANGE (EXCHANGE_ID VARCHAR(" + IDGenerator.UUID_SIZE + ") PRIMARY KEY, CONSUMER_ENDPOINT BLOB, ENDPOINT BLOB, INTERFACE_NAME VARCHAR(255), SERVICE_NAME VARCHAR(255), ENDPOINT_NAME VARCHAR(255), OPERATION_NAME VARCHAR(255), PATTERN VARCHAR(63), ERROR BLOB, ROLE NUMBER(3), STATUS NUMBER(3), TTERMINATED NUMBER(1), TRANSACTED NUMBER(1), MONITORED NUMBER(1), PERSISTED NUMBER(1), CREATION_TIMESTAMP NUMBER(38))" : "CREATE TABLE MESSAGE_EXCHANGE (EXCHANGE_ID VARCHAR(" + IDGenerator.UUID_SIZE + ") PRIMARY KEY, CONSUMER_ENDPOINT LONGBLOB, ENDPOINT LONGBLOB, INTERFACE_NAME VARCHAR(255), SERVICE_NAME VARCHAR(255), ENDPOINT_NAME VARCHAR(255), OPERATION_NAME VARCHAR(255), PATTERN VARCHAR(63), ERROR LONGBLOB, ROLE TINYINT, STATUS TINYINT, TTERMINATED BOOLEAN, TRANSACTED BOOLEAN, MONITORED BOOLEAN, PERSISTED BOOLEAN, CREATION_TIMESTAMP BIGINT)";
                        }
                        statement2.executeUpdate(string);
                        string = "CREATE INDEX INTERFACE_INDEX ON MESSAGE_EXCHANGE (INTERFACE_NAME)";
                        statement2.executeUpdate(string);
                        string = "CREATE INDEX SERVICE_INDEX ON MESSAGE_EXCHANGE (SERVICE_NAME)";
                        statement2.executeUpdate(string);
                        string = "CREATE INDEX ENDPOINT_INDEX ON MESSAGE_EXCHANGE (ENDPOINT_NAME)";
                        statement2.executeUpdate(string);
                        string = "CREATE INDEX OPERATION_INDEX ON MESSAGE_EXCHANGE (OPERATION_NAME)";
                        string = "org.hsqldb.jdbcDriver".equals(this.databaseDriver) ? "CREATE TABLE MESSAGE_EXCHANGE_PROPERTY (EXCHANGE_ID VARCHAR(" + IDGenerator.UUID_SIZE + ") NOT NULL, KKEY VARCHAR(255) NOT NULL, VALUE OBJECT, PRIMARY KEY (EXCHANGE_ID, KKEY))" : ("oracle.jdbc.driver.OracleDriver".equals(this.databaseDriver) ? "CREATE TABLE MESSAGE_EXCHANGE_PROPERTY (EXCHANGE_ID VARCHAR(" + IDGenerator.UUID_SIZE + ") NOT NULL, KKEY VARCHAR(255) NOT NULL, VALUE BLOB, PRIMARY KEY (EXCHANGE_ID, KKEY))" : "CREATE TABLE MESSAGE_EXCHANGE_PROPERTY (EXCHANGE_ID VARCHAR(" + IDGenerator.UUID_SIZE + ") NOT NULL, KKEY VARCHAR(255) NOT NULL, VALUE LONGBLOB, PRIMARY KEY (EXCHANGE_ID, KKEY))");
                        statement2.executeUpdate(string);
                        statement2.executeUpdate("ALTER TABLE MESSAGE_EXCHANGE_PROPERTY ADD CONSTRAINT M_E_PROPERTY_FOREIGN_KEY FOREIGN KEY (EXCHANGE_ID) REFERENCES MESSAGE_EXCHANGE(EXCHANGE_ID)");
                        string = "org.hsqldb.jdbcDriver".equals(this.databaseDriver) ? "CREATE TABLE NORMALIZED_MESSAGE (EXCHANGE_ID VARCHAR(" + IDGenerator.UUID_SIZE + ") NOT NULL, KKEY VARCHAR(5) NOT NULL, VALUE OBJECT, PRIMARY KEY (EXCHANGE_ID, KKEY))" : ("oracle.jdbc.driver.OracleDriver".equals(this.databaseDriver) ? "CREATE TABLE NORMALIZED_MESSAGE (EXCHANGE_ID VARCHAR(" + IDGenerator.UUID_SIZE + ") NOT NULL, KKEY VARCHAR(5) NOT NULL, VALUE BLOB, PRIMARY KEY (EXCHANGE_ID, KKEY))" : "CREATE TABLE NORMALIZED_MESSAGE (EXCHANGE_ID VARCHAR(" + IDGenerator.UUID_SIZE + ") NOT NULL, KKEY VARCHAR(5) NOT NULL, VALUE LONGBLOB, PRIMARY KEY (EXCHANGE_ID, KKEY))");
                        statement2.executeUpdate(string);
                        statement2.executeUpdate("ALTER TABLE NORMALIZED_MESSAGE ADD CONSTRAINT N_M_FOREIGN_KEY FOREIGN KEY (EXCHANGE_ID) REFERENCES MESSAGE_EXCHANGE(EXCHANGE_ID)");
                        string = "org.hsqldb.jdbcDriver".equals(this.databaseDriver) ? "CREATE TABLE EXCHANGE_TIMESTAMP (ID IDENTITY, EVENT_TIMESTAMP BIGINT, EXCHANGE_ID VARCHAR(" + IDGenerator.UUID_SIZE + ") NOT NULL, IS_SENT BOOLEAN, TYPE VARCHAR(9))" : ("oracle.jdbc.driver.OracleDriver".equals(this.databaseDriver) ? "CREATE TABLE EXCHANGE_TIMESTAMP (ID NUMBER(38), EVENT_TIMESTAMP NUMBER(38), EXCHANGE_ID VARCHAR(" + IDGenerator.UUID_SIZE + ") NOT NULL, IS_SENT NUMBER(1), TYPE VARCHAR(9))" : "CREATE TABLE EXCHANGE_TIMESTAMP (ID MEDIUMINT NOT NULL AUTO_INCREMENT PRIMARY KEY, EVENT_TIMESTAMP BIGINT, EXCHANGE_ID VARCHAR(" + IDGenerator.UUID_SIZE + ") NOT NULL, IS_SENT BOOLEAN, TYPE VARCHAR(9))");
                        statement2.executeUpdate(string);
                        statement2.executeUpdate("ALTER TABLE EXCHANGE_TIMESTAMP ADD CONSTRAINT E_T_FOREIGN_KEY FOREIGN KEY (EXCHANGE_ID) REFERENCES MESSAGE_EXCHANGE(EXCHANGE_ID)");
                    }
                }
                catch (SQLException sQLException) {
                    boolean bl = false;
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (statement2 != null) {
                    statement2.close();
                }
                if (statement != null) {
                    statement.close();
                }
                if (connection == null) throw throwable;
                connection.close();
                throw throwable;
            }
            {
                Object var7_10 = null;
                if (statement2 == null) break block13;
            }
            statement2.close();
        }
        if (statement != null) {
            statement.close();
        }
        if (connection == null) return;
        connection.close();
    }

    private class PersistenceCleaner
    extends TimerTask {
        private PersistenceCleaner() {
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            PersistenceServiceImpl.this.log.debug((Object)"Start Persistence clean up");
            long l = System.currentTimeMillis() - PersistenceServiceImpl.this.storageDuration;
            try {
                Connection connection = PersistenceServiceImpl.this.jdbcDataSource.getConnection();
                try {
                    PreparedStatement preparedStatement = connection.prepareStatement("SELECT EXCHANGE_ID FROM MESSAGE_EXCHANGE WHERE CREATION_TIMESTAMP < ?");
                    try {
                        preparedStatement.setLong(1, l);
                        preparedStatement.setFetchSize(PersistenceServiceImpl.this.fetchSize);
                        ResultSet resultSet = preparedStatement.executeQuery();
                        try {
                            while (resultSet.next()) {
                                Object var8_8;
                                String string = resultSet.getString(1);
                                PersistenceServiceImpl.this.log.debug((Object)("Delete Message Exchange with Id '" + string + "' related data"));
                                PreparedStatement preparedStatement2 = connection.prepareStatement("DELETE FROM MESSAGE_EXCHANGE_PROPERTY WHERE EXCHANGE_ID=?");
                                try {
                                    preparedStatement2.setString(1, string);
                                    preparedStatement2.execute();
                                }
                                catch (Throwable throwable) {
                                    var8_8 = null;
                                    preparedStatement2.close();
                                    throw throwable;
                                }
                                {
                                    var8_8 = null;
                                }
                                preparedStatement2.close();
                                preparedStatement2 = connection.prepareStatement("DELETE FROM NORMALIZED_MESSAGE WHERE EXCHANGE_ID=?");
                                try {
                                    preparedStatement2.setString(1, string);
                                    preparedStatement2.execute();
                                }
                                catch (Throwable throwable) {
                                    var8_8 = null;
                                    preparedStatement2.close();
                                    throw throwable;
                                }
                                {
                                    var8_8 = null;
                                }
                                preparedStatement2.close();
                                preparedStatement2 = connection.prepareStatement("DELETE FROM EXCHANGE_TIMESTAMP WHERE EXCHANGE_ID=?");
                                try {
                                    preparedStatement2.setString(1, string);
                                    preparedStatement2.execute();
                                }
                                catch (Throwable throwable) {
                                    var8_8 = null;
                                    preparedStatement2.close();
                                    throw throwable;
                                }
                                {
                                    var8_8 = null;
                                }
                                preparedStatement2.close();
                                preparedStatement2 = connection.prepareStatement("DELETE FROM MESSAGE_EXCHANGE WHERE EXCHANGE_ID=?");
                                try {
                                    preparedStatement2.setString(1, string);
                                    preparedStatement2.execute();
                                }
                                catch (Throwable throwable) {
                                    var8_8 = null;
                                    preparedStatement2.close();
                                    throw throwable;
                                }
                                {
                                    var8_8 = null;
                                }
                                preparedStatement2.close();
                            }
                        }
                        catch (Throwable throwable) {
                            Object var10_14 = null;
                            resultSet.close();
                            throw throwable;
                        }
                        {
                            Object var10_15 = null;
                            resultSet.close();
                        }
                    }
                    catch (Throwable throwable) {
                        Object var12_17 = null;
                        preparedStatement.close();
                        throw throwable;
                    }
                    {
                        Object var12_18 = null;
                        preparedStatement.close();
                    }
                }
                catch (Throwable throwable) {
                    Object var14_20 = null;
                    connection.close();
                    throw throwable;
                }
                {
                    Object var14_21 = null;
                    connection.close();
                    return;
                }
            }
            catch (SQLException sQLException) {
                PersistenceServiceImpl.this.log.warning((Object)"Failed to delete old exchange data", (Throwable)sQLException);
            }
        }
    }
}

