/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.transport.platform.nio.client;

import org.apache.commons.pool.BaseKeyedPoolableObjectFactory;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.petals.communication.topology.TopologyService;
import org.ow2.petals.kernel.configuration.ContainerConfiguration;
import org.ow2.petals.transport.TransportException;
import org.ow2.petals.transport.platform.nio.client.NioClientAgent;
import org.ow2.petals.transport.platform.nio.selector.NioSelector;
import org.ow2.petals.util.LoggingUtil;

public class NioClientAgentPoolObjectFactory
extends BaseKeyedPoolableObjectFactory {
    private final TopologyService topologyService;
    private final NioSelector selectorAgent;
    private final Logger logger;
    private final LoggingUtil log;
    private final long connectionTimeout;

    public NioClientAgentPoolObjectFactory(TopologyService topologyService, NioSelector nioSelector, long l, Logger logger) {
        this.topologyService = topologyService;
        this.selectorAgent = nioSelector;
        this.logger = logger;
        this.log = new LoggingUtil(logger);
        this.connectionTimeout = l;
    }

    public Object makeObject(Object object) throws Exception {
        ContainerConfiguration containerConfiguration;
        String string = (String)object;
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.log.debug((Object)("Creating new connection to container '" + string + "'"));
        }
        if ((containerConfiguration = this.topologyService.getContainerConfiguration(string)) == null) {
            throw new TransportException("Cannot get the information for the container " + string);
        }
        String string2 = containerConfiguration.getHost();
        int n = containerConfiguration.getTCPPort();
        NioClientAgent nioClientAgent = new NioClientAgent(this.logger, this.selectorAgent);
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.log.debug((Object)("Connecting to " + string2 + ":" + n + " (Connection timeout: " + this.connectionTimeout + ")"));
        }
        nioClientAgent.connect(string2, n, this.connectionTimeout);
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.log.debug((Object)("Connection established to " + string2 + ":" + n));
        }
        return nioClientAgent;
    }

    public void destroyObject(Object object, Object object2) throws Exception {
        NioClientAgent nioClientAgent = (NioClientAgent)object2;
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.log.debug((Object)("The NIO client agent connected to the container '" + object + "' is removed from the pool."));
        }
        nioClientAgent.disconnect();
    }

    public boolean validateObject(Object object, Object object2) {
        NioClientAgent nioClientAgent = (NioClientAgent)object2;
        return nioClientAgent.isUsable();
    }
}

