/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.transport.platform.nio.selector;

import java.io.IOException;
import java.net.Socket;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.transport.platform.nio.selector.InputSocketChannelContext;
import org.ow2.petals.transport.platform.nio.selector.NioClient;
import org.ow2.petals.transport.platform.nio.selector.NioSelector;
import org.ow2.petals.transport.platform.nio.selector.NioServer;
import org.ow2.petals.transport.platform.nio.selector.OutputSocketChannelContext;
import org.ow2.petals.util.LoggingUtil;

@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=NioSelector.class)})
public class NioSelectorAgent
implements Runnable,
BindingController,
LifeCycleController,
NioSelector {
    private LoggerFactory loggerFactory;
    protected Logger logger;
    private LoggingUtil log;
    private Selector selector;
    private Thread selectorAgentThread;
    private final Queue<PendingRegistration> registrationQueue = new LinkedBlockingQueue<PendingRegistration>();

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public final void register(int n, AbstractSelectableChannel abstractSelectableChannel, Object object) throws ClosedChannelException {
        this.registrationQueue.offer(new PendingRegistration(abstractSelectableChannel, n, object));
        this.selector.wakeup();
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    /*
     * Exception decompiling
     */
    public final void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void accept(SelectionKey selectionKey) throws IOException {
        this.log.start();
        ServerSocketChannel serverSocketChannel = (ServerSocketChannel)selectionKey.channel();
        if (serverSocketChannel.isOpen()) {
            SocketChannel socketChannel = serverSocketChannel.accept();
            if (socketChannel == null) throw new IOException("Accepted socket but not already created.");
            Socket socket = socketChannel.socket();
            socket.setKeepAlive(true);
            socketChannel.configureBlocking(false);
            Object object = selectionKey.attachment();
            if (!(object instanceof NioServer)) throw new IOException("Unexpected key attachment on OP_ACCEPT: " + object.getClass().getName());
            ((NioServer)object).onConnectionIsAccepted(socketChannel, this.selector);
        }
        this.log.end();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void endsConnection(SelectionKey selectionKey) throws IOException {
        this.log.start();
        try {
            Object object = selectionKey.attachment();
            if (!(object instanceof NioClient)) throw new IOException("Unexpected key attachment on OP_CONNECT: " + object.getClass().getName());
            NioClient nioClient = (NioClient)object;
            try {
                SocketChannel socketChannel = (SocketChannel)selectionKey.channel();
                if (!socketChannel.finishConnect()) throw new IOException("Unable to finish the socket connection");
                nioClient.onIsConnected(new OutputSocketChannelContext(socketChannel, nioClient));
            }
            catch (IOException iOException) {
                this.log.error((Object)("Unable to connect: " + iOException.getMessage()));
                nioClient.onConnectionError(iOException);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.log.end();
            throw throwable;
        }
        {
            Object var5_8 = null;
        }
        this.log.end();
    }

    private void read(SelectionKey selectionKey) throws IOException {
        this.log.start();
        Object object = selectionKey.attachment();
        if (object instanceof InputSocketChannelContext) {
            ((InputSocketChannelContext)object).read(selectionKey);
        } else if (object instanceof OutputSocketChannelContext) {
            ((OutputSocketChannelContext)object).onClose(selectionKey);
        } else {
            throw new IOException("Unexpected key attachment on OP_READ: " + object.getClass().getName());
        }
        this.log.end();
    }

    private void write(SelectionKey selectionKey) {
        this.log.start();
        Object object = selectionKey.attachment();
        if (object instanceof OutputSocketChannelContext) {
            ((OutputSocketChannelContext)object).write(selectionKey);
        } else {
            this.log.error((Object)("Unexpected key attachment on OP_WRITE: " + object.getClass().getName()));
        }
        this.log.end();
    }

    @LifeCycle(on=LifeCycleType.START)
    public void start() throws IOException {
        this.log = new LoggingUtil(this.logger);
        this.log.start();
        this.selectorAgentThread = new Thread((Runnable)this, "SelectorAgent Thread");
        this.selectorAgentThread.setDaemon(true);
        this.selector = Selector.open();
        this.selectorAgentThread.start();
        this.log.end();
    }

    @LifeCycle(on=LifeCycleType.STOP)
    public void stop() throws Exception {
        this.log.start();
        this.selector.close();
        this.selectorAgentThread.interrupt();
        this.log.end();
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList arrayList = new ArrayList();
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    private class PendingRegistration {
        protected AbstractSelectableChannel socketChannel;
        protected int key;
        protected Object attachment;

        public PendingRegistration(AbstractSelectableChannel abstractSelectableChannel, int n, Object object) {
            this.socketChannel = abstractSelectableChannel;
            this.key = n;
            this.attachment = object;
        }
    }
}

