/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.transport.platform.nio.selector;

import java.io.IOException;
import java.net.SocketException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;
import org.ow2.petals.transport.platform.nio.selector.AbstractSocketChannelContext;
import org.ow2.petals.transport.platform.nio.selector.NioClient;

public class OutputSocketChannelContext
extends AbstractSocketChannelContext {
    private Queue<byte[]> writesQueue = new LinkedBlockingQueue<byte[]>();
    private NioClient nioClient;
    private byte[] currentBuffer;

    public OutputSocketChannelContext(SocketChannel socketChannel, NioClient nioClient) throws SocketException {
        super(socketChannel, socketChannel.socket().getSendBufferSize());
        this.nioClient = nioClient;
    }

    public final boolean offer(byte[] byArray) {
        return this.writesQueue.offer(byArray);
    }

    public final void write(SelectionKey selectionKey) {
        if (!this.isIOPending) {
            this.currentBuffer = this.writesQueue.poll();
            if (this.currentBuffer != null) {
                this.msgExRemainingBytes = this.currentBuffer.length;
                this.directBuffer.putInt(this.currentBuffer.length);
            } else {
                this.msgExRemainingBytes = 0;
            }
        }
        try {
            if (this.msgExRemainingBytes > 0) {
                int n = Math.min(this.msgExRemainingBytes, this.directBuffer.capacity() - this.directBuffer.position());
                this.directBuffer.put(this.currentBuffer, this.currentBuffer.length - this.msgExRemainingBytes, n);
                this.directBuffer.flip();
                this.socketChannel.write(this.directBuffer);
                if (this.directBuffer.hasRemaining()) {
                    this.directBuffer.compact();
                } else {
                    this.directBuffer.clear();
                }
                this.msgExRemainingBytes -= n;
            }
            if (this.msgExRemainingBytes > 0) {
                this.isIOPending = true;
            } else {
                this.isIOPending = false;
                this.nioClient.onIsWritten();
            }
        }
        catch (IOException iOException) {
            try {
                this.socketChannel.close();
                this.isIOPending = false;
                selectionKey.cancel();
                this.nioClient.onWriteError(iOException);
            }
            catch (IOException iOException2) {}
        }
    }

    public final void onClose(SelectionKey selectionKey) {
        this.nioClient.onClose(this.socketChannel);
    }
}

