/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.transport.platform.nio.server;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.nio.channels.SocketChannel;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.petals.transport.platform.nio.selector.PipedDeserializer;
import org.ow2.petals.transport.platform.nio.server.NioReceiver;
import org.ow2.petals.transport.platform.nio.util.stream.queue.QueueInputStream;
import org.ow2.petals.transport.platform.nio.util.stream.queue.QueueOutputStream;
import org.ow2.petals.util.LoggingUtil;

public final class PipedDeserializerImpl
implements PipedDeserializer {
    private final Logger logger;
    private final LoggingUtil log;
    private final OutputStream outputStream;
    private InputStream inputStream;
    private Object objectStreamLock = new Object();
    private final SocketChannel socketChannel;
    private final NioReceiver messageReceiver;

    public PipedDeserializerImpl(SocketChannel socketChannel, NioReceiver nioReceiver, Logger logger, LoggingUtil loggingUtil) throws IOException {
        this.logger = logger;
        this.log = loggingUtil;
        QueueOutputStream queueOutputStream = new QueueOutputStream();
        this.outputStream = queueOutputStream;
        this.inputStream = new QueueInputStream(queueOutputStream);
        this.socketChannel = socketChannel;
        this.messageReceiver = nioReceiver;
    }

    public final void connectStreams() {
    }

    public final OutputStream getOutputStream() {
        return this.outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        try {
            Object object;
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.log.debug((Object)("A read occurs on socket " + this.socketChannel.socket().toString()));
            }
            Object object2 = this.objectStreamLock;
            synchronized (object2) {
                object = new ObjectInputStream(this.inputStream).readUnshared();
            }
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.log.debug((Object)("Received object: " + object.toString()));
            }
            this.messageReceiver.onMessage(object);
        }
        catch (IOException iOException) {
            this.log.warning((Object)("An error occurs during deserialization: (" + iOException.getMessage() + "). Data are discarded."), (Throwable)iOException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.log.error((Object)("An error occurs during deserialization: " + classNotFoundException.getMessage() + "). Data are discarded."), (Throwable)classNotFoundException);
        }
    }
}

