/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.ws;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.activation.DataHandler;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.kernel.api.server.PetalsException;
import org.ow2.petals.kernel.configuration.ConfigurationService;
import org.ow2.petals.kernel.ws.api.PEtALSWebServiceException;
import org.ow2.petals.kernel.ws.api.to.AttachmentDescriptor;
import org.ow2.petals.system.repository.artifact.Artifact;
import org.ow2.petals.system.repository.artifact.ArtifactRepositoryService;
import org.ow2.petals.tools.ws.KernelWebService;
import org.ow2.petals.util.LoggingUtil;

@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=KernelWebService.class), @Interface(name="webservice", signature=org.ow2.petals.kernel.ws.api.ArtifactRepositoryService.class)})
public class ArtifactRepositoryServiceImpl
implements BindingController,
LifeCycleController,
org.ow2.petals.kernel.ws.api.ArtifactRepositoryService,
KernelWebService {
    private LoggerFactory loggerFactory;
    private Logger logger;
    private LoggingUtil log;
    private Component component;
    @Requires(name="artifactrepository", signature=ArtifactRepositoryService.class)
    private ArtifactRepositoryService artifactRepositoryService;
    @Requires(name="configuration", signature=ConfigurationService.class)
    private ConfigurationService configurationService;
    private File uploadPath;

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.debug((Object)"Starting...");
        this.uploadPath = new File(this.configurationService.getContainerConfiguration().getWorkDirectoryPath(), "upload");
        if (!this.uploadPath.exists()) {
            this.uploadPath.mkdirs();
        }
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.debug((Object)"Stopping...");
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public Component getComponent() {
        return this.component;
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public boolean addArtifact(AttachmentDescriptor attachmentDescriptor) throws PEtALSWebServiceException {
        boolean bl = false;
        File file = null;
        DataHandler dataHandler = attachmentDescriptor.getAttachment();
        if (dataHandler != null) {
            try {
                file = new File(this.uploadPath, "artifactUpload-" + System.currentTimeMillis());
                dataHandler.writeTo((OutputStream)new FileOutputStream(file));
                Artifact artifact = new Artifact();
                artifact.setFile(file);
                bl = this.artifactRepositoryService.addArtifact(artifact);
                if (!bl) {
                    throw new PEtALSWebServiceException("The file has not been added to the artifact repository service");
                }
                file.delete();
            }
            catch (IOException iOException) {
                throw new PEtALSWebServiceException(iOException.getMessage());
            }
            catch (PetalsException petalsException) {
                throw new PEtALSWebServiceException(petalsException.getMessage());
            }
        }
        return bl;
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public String[] getComponents() {
        List<String> list = this.artifactRepositoryService.getComponentsName();
        return list.toArray(new String[0]);
    }

    public String[] getServiceAssemblies() {
        List<String> list = this.artifactRepositoryService.getServiceAssembliesName();
        return list.toArray(new String[0]);
    }

    public String[] getSharedLibraries() {
        List<String> list = this.artifactRepositoryService.getSharedLibrariesName();
        return list.toArray(new String[0]);
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        if (string.equals("component")) {
            this.component = (Component)object;
            return;
        }
        if (string.equals("artifactrepository")) {
            if (!ArtifactRepositoryService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ArtifactRepositoryService.class.getName());
            }
            this.artifactRepositoryService = (ArtifactRepositoryService)object;
            return;
        }
        if (string.equals("configuration")) {
            if (!ConfigurationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ConfigurationService.class.getName());
            }
            this.configurationService = (ConfigurationService)object;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("artifactrepository");
        arrayList.add("configuration");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("artifactrepository")) {
            return this.artifactRepositoryService;
        }
        if (string.equals("configuration")) {
            return this.configurationService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("artifactrepository")) {
            this.artifactRepositoryService = null;
            return;
        }
        if (string.equals("configuration")) {
            this.configurationService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

