/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.ws;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.jbi.management.installation.ComponentInstallationService;
import org.ow2.petals.kernel.ws.api.InstallationService;
import org.ow2.petals.kernel.ws.api.PEtALSWebServiceException;
import org.ow2.petals.system.repository.artifact.Artifact;
import org.ow2.petals.system.repository.artifact.ArtifactRepositoryService;
import org.ow2.petals.tools.ws.KernelWebService;
import org.ow2.petals.util.LoggingUtil;

@FractalComponent
@Provides(interfaces={@Interface(name="webservice", signature=InstallationService.class), @Interface(name="service", signature=KernelWebService.class)})
public class InstallationServiceImpl
implements BindingController,
LifeCycleController,
InstallationService,
KernelWebService {
    private Component component;
    private LoggerFactory loggerFactory;
    @Requires(name="componentInstallation", signature=ComponentInstallationService.class)
    private ComponentInstallationService componentInstallationService;
    @Requires(name="artifactrepository", signature=ArtifactRepositoryService.class)
    private ArtifactRepositoryService artifactRepositoryService;
    private Logger logger;
    private LoggingUtil log;

    public Logger getLogger() {
        return this.logger;
    }

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.debug((Object)"Starting...");
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.debug((Object)"Stopping...");
    }

    public Component getComponent() {
        return this.component;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public boolean install(String string) throws PEtALSWebServiceException {
        Object object;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Entering method : install with params componentId = " + string));
        }
        List<Artifact> list = this.artifactRepositoryService.getComponents();
        Iterator<Artifact> iterator = list.iterator();
        boolean bl = false;
        Object object2 = null;
        while (iterator.hasNext() && !bl) {
            object = iterator.next();
            if (((Artifact)object).getName() == null || !((Artifact)object).getName().equals(string)) continue;
            object2 = object;
            bl = true;
        }
        if (object2 == null) {
            throw new PEtALSWebServiceException("Can not find component " + string + " from repository");
        }
        object = null;
        try {
            object = ((Artifact)object2).getFile().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            throw new PEtALSWebServiceException(malformedURLException.getMessage());
        }
        return this.install((URL)object);
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public boolean install(URL uRL) throws PEtALSWebServiceException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Entering method : install with params url = " + uRL));
        }
        return this.componentInstallationService.install(uRL);
    }

    public boolean uninstall(String string) throws PEtALSWebServiceException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Entering method : uninstall with params componentId = " + string));
        }
        return this.componentInstallationService.uninstall(string);
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("component")) {
            this.component = (Component)object;
            return;
        }
        if (string.equals("componentInstallation")) {
            if (!ComponentInstallationService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ComponentInstallationService.class.getName());
            }
            this.componentInstallationService = (ComponentInstallationService)object;
            return;
        }
        if (string.equals("artifactrepository")) {
            if (!ArtifactRepositoryService.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + ArtifactRepositoryService.class.getName());
            }
            this.artifactRepositoryService = (ArtifactRepositoryService)object;
            return;
        }
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("componentInstallation");
        arrayList.add("artifactrepository");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("componentInstallation")) {
            return this.componentInstallationService;
        }
        if (string.equals("artifactrepository")) {
            return this.artifactRepositoryService;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("componentInstallation")) {
            this.componentInstallationService = null;
            return;
        }
        if (string.equals("artifactrepository")) {
            this.artifactRepositoryService = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

