/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.ws;

import java.util.ArrayList;
import org.objectweb.fractal.api.Component;
import org.objectweb.fractal.api.NoSuchInterfaceException;
import org.objectweb.fractal.api.control.BindingController;
import org.objectweb.fractal.api.control.IllegalBindingException;
import org.objectweb.fractal.api.control.IllegalLifeCycleException;
import org.objectweb.fractal.api.control.LifeCycleController;
import org.objectweb.fractal.fraclet.annotation.annotations.FractalComponent;
import org.objectweb.fractal.fraclet.annotation.annotations.Interface;
import org.objectweb.fractal.fraclet.annotation.annotations.LifeCycle;
import org.objectweb.fractal.fraclet.annotation.annotations.Provides;
import org.objectweb.fractal.fraclet.annotation.annotations.Requires;
import org.objectweb.fractal.fraclet.annotation.annotations.type.LifeCycleType;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.ow2.petals.kernel.admin.PetalsAdminInterface;
import org.ow2.petals.kernel.ws.api.PEtALSWebServiceException;
import org.ow2.petals.kernel.ws.api.RuntimeService;
import org.ow2.petals.tools.ws.KernelWebService;
import org.ow2.petals.util.LoggingUtil;

@FractalComponent
@Provides(interfaces={@Interface(name="service", signature=KernelWebService.class), @Interface(name="webservice", signature=RuntimeService.class)})
public class RuntimeServiceImpl
implements BindingController,
LifeCycleController,
RuntimeService,
KernelWebService {
    @Requires(name="petalsAdminService", signature=PetalsAdminInterface.class)
    private PetalsAdminInterface petalsAdminInterface;
    private Component component;
    private Logger logger;
    private LoggingUtil log;
    private LoggerFactory loggerFactory;

    @LifeCycle(on=LifeCycleType.START)
    protected void start() {
        this.log = new LoggingUtil(this.logger);
        this.log.debug((Object)"Starting...");
    }

    public Logger getLogger() {
        return this.logger;
    }

    @LifeCycle(on=LifeCycleType.STOP)
    protected void stop() {
        this.log.debug((Object)"Stopping...");
    }

    public Component getComponent() {
        return this.component;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public boolean ping() throws PEtALSWebServiceException {
        return true;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public String getFcState() {
        return null;
    }

    public void shutdownContainer() throws PEtALSWebServiceException {
        Thread thread = new Thread(){

            public void run() {
                try {
                    Thread.sleep(1000L);
                    RuntimeServiceImpl.this.petalsAdminInterface.shutdownContainer();
                }
                catch (Exception exception) {
                    RuntimeServiceImpl.this.log.warning((Object)"Container can not be shutdowned remotely", (Throwable)exception);
                }
            }
        };
        thread.start();
    }

    public void setLoggerFactory(LoggerFactory loggerFactory) {
        this.loggerFactory = loggerFactory;
        this.logger = this.getLoggerFactory().getLogger("logger");
    }

    public void startFc() throws IllegalLifeCycleException {
        try {
            this.start();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopFc() throws IllegalLifeCycleException {
        try {
            this.stop();
        }
        catch (Exception exception) {
            throw new IllegalLifeCycleException(exception.getMessage());
        }
    }

    public void stopContainer() throws PEtALSWebServiceException {
        Thread thread = new Thread(){

            public void run() {
                try {
                    Thread.sleep(1000L);
                    RuntimeServiceImpl.this.petalsAdminInterface.stopContainer();
                }
                catch (Exception exception) {
                    RuntimeServiceImpl.this.log.warning((Object)"Container can not be stopped remotely", (Throwable)exception);
                }
            }
        };
        thread.start();
    }

    public void bindFc(String string, Object object) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("petalsAdminService")) {
            if (!PetalsAdminInterface.class.isAssignableFrom(object.getClass())) {
                throw new IllegalBindingException("server interfaces connected to " + string + " must be instances of " + PetalsAdminInterface.class.getName());
            }
            this.petalsAdminInterface = (PetalsAdminInterface)object;
            return;
        }
        if (string.equals("component")) {
            this.component = (Component)object;
            return;
        }
        if (string.equals("logger")) {
            this.logger = (Logger)object;
            return;
        }
        if (string.equals("logger-factory")) {
            this.setLoggerFactory((LoggerFactory)object);
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public String[] listFc() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("petalsAdminService");
        return arrayList.toArray(new String[0]);
    }

    public Object lookupFc(String string) throws NoSuchInterfaceException {
        if (string.equals("petalsAdminService")) {
            return this.petalsAdminInterface;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }

    public void unbindFc(String string) throws NoSuchInterfaceException, IllegalBindingException, IllegalLifeCycleException {
        if (string.equals("petalsAdminService")) {
            this.petalsAdminInterface = null;
            return;
        }
        throw new NoSuchInterfaceException("Client interface '" + string + "' is undefined.");
    }
}

