/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.communication.jndi.tribe.connection;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.ow2.petals.communication.jndi.agent.msg.request.RegistryRequest;
import org.ow2.petals.communication.jndi.agent.msg.response.AckResponse;
import org.ow2.petals.communication.jndi.agent.msg.response.ExceptionResponse;

public class ServerSocketThread
extends Thread {
    protected ServerSocket serverSocket;
    protected boolean run;

    public ServerSocketThread(int port, String host) {
        try {
            this.serverSocket = new ServerSocket();
            this.serverSocket.bind(new InetSocketAddress(host, port));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        this.run = true;
        while (!this.serverSocket.isBound()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {}
        }
        while (this.run) {
            try {
                Socket socket = this.serverSocket.accept();
                RegistryRequest request = null;
                AckResponse response = null;
                ObjectInputStream objectInputStream = new ObjectInputStream(socket.getInputStream());
                request = (RegistryRequest)objectInputStream.readObject();
                if (request.getType().equals((Object)RegistryRequest.RequestType.ping)) {
                    response = new AckResponse();
                    response.setArg1((Object)"test");
                } else {
                    response = new ExceptionResponse((Throwable)new RuntimeException());
                }
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(socket.getOutputStream());
                objectOutputStream.writeObject(response);
                objectOutputStream.flush();
                objectOutputStream.close();
            }
            catch (IOException e) {
                if (!this.run) continue;
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    public void terminate() {
        try {
            this.run = false;
            this.serverSocket.close();
        }
        catch (IOException e) {
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

