/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.container.thread;

import javax.jbi.JBIException;
import javax.jbi.component.Component;
import javax.jbi.component.ComponentContext;
import javax.jbi.component.ComponentLifeCycle;
import org.easymock.classextension.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.ow2.petals.container.thread.ComponentLifeCycleThread;

public class ComponentLifeCycleThreadTest {
    private ComponentLifeCycleThread lifeCycleThread;
    private ComponentLifeCycle lifeCycleMock;
    private Component componentMock;
    private ComponentContext contextMock;

    @Test
    public void testDoInit() throws Exception {
        this.lifeCycleThread.start();
        EasyMock.reset((Object)this.componentMock);
        org.easymock.EasyMock.expect((Object)this.componentMock.getLifeCycle()).andReturn((Object)this.lifeCycleMock);
        EasyMock.replay((Object)this.componentMock);
        EasyMock.reset((Object)this.contextMock);
        org.easymock.EasyMock.expect((Object)this.contextMock.getComponentName()).andReturn((Object)"contextMock");
        EasyMock.replay((Object)this.contextMock);
        this.lifeCycleThread.doInit(this.contextMock);
        EasyMock.verify((Object)this.componentMock);
    }

    @Test
    public void testDoStart() throws Exception {
        this.lifeCycleThread.start();
        EasyMock.reset((Object)this.componentMock);
        org.easymock.EasyMock.expect((Object)this.componentMock.getLifeCycle()).andReturn((Object)this.lifeCycleMock);
        EasyMock.replay((Object)this.componentMock);
        this.lifeCycleThread.doStart();
        EasyMock.verify((Object)this.componentMock);
    }

    @Test
    public void testDoStop() throws Exception {
        this.lifeCycleThread.start();
        EasyMock.reset((Object)this.componentMock);
        org.easymock.EasyMock.expect((Object)this.componentMock.getLifeCycle()).andReturn((Object)this.lifeCycleMock);
        EasyMock.replay((Object)this.componentMock);
        this.lifeCycleThread.doStop();
        EasyMock.verify((Object)this.componentMock);
    }

    @Test
    public void testDoShutdown() throws Exception {
        this.lifeCycleThread.start();
        EasyMock.reset((Object)this.componentMock);
        org.easymock.EasyMock.expect((Object)this.componentMock.getLifeCycle()).andReturn((Object)this.lifeCycleMock);
        EasyMock.replay((Object)this.componentMock);
        this.lifeCycleThread.doShutdown();
        EasyMock.verify((Object)this.componentMock);
    }

    @Test
    public void testMultipleCalls() {
        this.lifeCycleThread.start();
        EasyMock.reset((Object)this.componentMock);
        org.easymock.EasyMock.expect((Object)this.componentMock.getLifeCycle()).andReturn((Object)this.lifeCycleMock);
        EasyMock.replay((Object)this.componentMock);
        try {
            this.lifeCycleThread.doStop();
        }
        catch (JBIException e) {
            Assert.fail((String)e.getMessage());
        }
        EasyMock.verify((Object)this.componentMock);
        EasyMock.reset((Object)this.componentMock);
        org.easymock.EasyMock.expect((Object)this.componentMock.getLifeCycle()).andReturn((Object)this.lifeCycleMock);
        EasyMock.replay((Object)this.componentMock);
        try {
            this.lifeCycleThread.doShutdown();
        }
        catch (JBIException e) {
            Assert.fail((String)e.getMessage());
        }
        EasyMock.verify((Object)this.componentMock);
    }

    @Before
    public void setUp() throws Exception {
        this.componentMock = (Component)EasyMock.createMock(Component.class);
        this.contextMock = (ComponentContext)EasyMock.createMock(ComponentContext.class);
        this.lifeCycleMock = (ComponentLifeCycle)EasyMock.createMock(ComponentLifeCycle.class);
        this.lifeCycleThread = new ComponentLifeCycleThread(this.componentMock, 0L, null);
    }
}

