/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.management.task.deployment.undeploy;

import java.util.logging.Logger;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.Test;
import org.ow2.petals.jbi.management.Context;
import org.ow2.petals.jbi.management.task.deployment.undeploy.RemoveSAStateHolderTask;
import org.ow2.petals.system.systemstate.SystemStateService;
import org.ow2.petals.systemstate.generated.ServiceAssembly;
import org.ow2.petals.util.AbstractMavenTest;
import org.ow2.petals.util.LoggingUtil;

public class RemoveSAStateHolderTaskTest
extends AbstractMavenTest {
    private static final String SA_NAME = "myServiceAssemblyName";
    final LoggingUtil log = new LoggingUtil(Logger.getLogger(RemoveSAStateHolderTaskTest.class.getName()));

    @Test
    public void testRemoveSAStateHolderTask_000() throws Exception {
        SystemStateService systemStateSvc = (SystemStateService)EasyMock.createMock(SystemStateService.class);
        EasyMock.expect((Object)systemStateSvc.deleteServiceAssemblyStateHolder(SA_NAME)).andAnswer((IAnswer)new IAnswer<ServiceAssembly>(){

            public ServiceAssembly answer() throws Throwable {
                ServiceAssembly serviceAssembly = new ServiceAssembly();
                serviceAssembly.setName(RemoveSAStateHolderTaskTest.SA_NAME);
                return serviceAssembly;
            }
        });
        EasyMock.replay((Object[])new Object[]{systemStateSvc});
        Context ctx = new Context();
        ctx.setEntityName(SA_NAME);
        RemoveSAStateHolderTask task = new RemoveSAStateHolderTask(this.log, systemStateSvc);
        task.execute(ctx);
        TestCase.assertEquals((String)SA_NAME, (String)ctx.getServiceAssemblyStateHolder().getName());
        EasyMock.verify((Object[])new Object[]{systemStateSvc});
    }

    @Test
    public void testRemoveComponentStateHolderTask_001() throws Exception {
        SystemStateService systemStateSvc = (SystemStateService)EasyMock.createMock(SystemStateService.class);
        EasyMock.expect((Object)systemStateSvc.deleteServiceAssemblyStateHolder(SA_NAME)).andAnswer((IAnswer)new IAnswer<ServiceAssembly>(){

            public ServiceAssembly answer() throws Throwable {
                ServiceAssembly serviceAssembly = new ServiceAssembly();
                serviceAssembly.setName(RemoveSAStateHolderTaskTest.SA_NAME);
                return serviceAssembly;
            }
        });
        EasyMock.expect((Object)systemStateSvc.deleteServiceAssemblyStateHolder(SA_NAME)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{systemStateSvc});
        Context ctx1 = new Context();
        ctx1.setEntityName(SA_NAME);
        RemoveSAStateHolderTask task1 = new RemoveSAStateHolderTask(this.log, systemStateSvc);
        task1.execute(ctx1);
        TestCase.assertEquals((String)SA_NAME, (String)ctx1.getServiceAssemblyStateHolder().getName());
        Context ctx2 = new Context();
        ctx2.setEntityName(SA_NAME);
        RemoveSAStateHolderTask task2 = new RemoveSAStateHolderTask(this.log, systemStateSvc);
        task2.execute(ctx2);
        TestCase.assertNull((String)"Returned service assembly state holder not null", (Object)ctx2.getServiceAssemblyStateHolder());
        EasyMock.verify((Object[])new Object[]{systemStateSvc});
    }
}

