/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.management.task.download;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.ow2.petals.jbi.management.Context;
import org.ow2.petals.jbi.management.task.DownloadTask;
import org.ow2.petals.jbi.management.task.download.jetty.server.JettyServer;
import org.ow2.petals.kernel.api.server.PetalsException;
import org.ow2.petals.util.LoggingUtil;

public class DownloadTaskTest {
    private JettyServer jettyServer = null;
    private String baseDirPath;
    private String componentName = "test-contentType";

    @Before
    public void setUp() throws Exception {
        this.baseDirPath = this.getBaseDirPath();
        File workDirectory = new File(this.baseDirPath, "work");
        workDirectory.mkdirs();
        try {
            this.jettyServer = JettyServer.getInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @After
    public void tearDown() throws Exception {
        try {
            this.jettyServer.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testDownloadEntityPackageWithCorrectContentType() throws Exception {
        String urlTest = "http://localhost:8085/CorrectContentType/test-contentType.zip";
        Context ctx = this.createContext(urlTest);
        DownloadTask d = new DownloadTask(new LoggingUtil(Logger.getLogger("testLogger")), this.baseDirPath);
        Assert.assertEquals((Object)urlTest, (Object)ctx.getArchiveUrl().toString());
        d.execute(ctx);
        Assert.assertNotSame((Object)ctx.getArchiveUrl().toString(), (Object)urlTest);
        boolean t = new File(ctx.getArchiveUrl().toURI()).exists();
        Assert.assertEquals((Object)true, (Object)t);
    }

    @Test
    public void testDownloadEntityPackageWithWrongContentType() throws Exception {
        try {
            String test = "http://localhost:8085/WrongContentType/test-contentType.zip";
            Context ctx = this.createContext(test);
            DownloadTask d = new DownloadTask(new LoggingUtil(Logger.getLogger("testLogger")), this.baseDirPath);
            d.execute(ctx);
        }
        catch (PetalsException pE) {
            Assert.assertTrue((boolean)pE.getMessage().contains("http://localhost:8085/WrongContentType/test-contentType.zip"));
            Assert.assertTrue((boolean)pE.getMessage().contains("application/toto"));
        }
    }

    @Test
    public void testDownloadEntityPackageWithCorrectContentTypeWithCharset() throws Exception {
        String urlTest = "http://localhost:8085/CorrectContentTypeWithCharset/test-contentType.zip";
        Context ctx = this.createContext(urlTest);
        DownloadTask d = new DownloadTask(new LoggingUtil(Logger.getLogger("testLogger")), this.baseDirPath);
        Assert.assertEquals((Object)urlTest, (Object)ctx.getArchiveUrl().toString());
        d.execute(ctx);
        Assert.assertNotSame((Object)ctx.getArchiveUrl().toString(), (Object)urlTest);
        boolean t = new File(ctx.getArchiveUrl().toURI()).exists();
        Assert.assertEquals((Object)true, (Object)t);
    }

    @Test
    public void testDownloadEntityPackageWithoutContentType() throws Exception {
        try {
            String test = "http://localhost:8085/WithoutContentType/test-contentType.zip";
            Context ctx = this.createContext(test);
            DownloadTask d = new DownloadTask(new LoggingUtil(Logger.getLogger("testLogger")), this.baseDirPath);
            d.execute(ctx);
        }
        catch (PetalsException pE) {
            Assert.assertTrue((boolean)pE.getMessage().contains("http://localhost:8085/WithoutContentType/test-contentType.zip"));
            Assert.assertTrue((boolean)pE.getMessage().contains("It's content-type is undefined."));
        }
    }

    @Test
    public void testDownloadEntityPackageWithWrongURL() throws Exception {
        try {
            String test = "http://localhost:8085/WrongURL/test-contentType.zip";
            Context ctx = this.createContext(test);
            DownloadTask d = new DownloadTask(new LoggingUtil(Logger.getLogger("testLogger")), this.baseDirPath);
            d.execute(ctx);
        }
        catch (PetalsException pE) {
            Assert.assertTrue((boolean)pE.getMessage().contains("http://localhost:8085/WrongURL/test-contentType.zip"));
            Assert.assertTrue((boolean)pE.getMessage().contains("HTTP 404"));
        }
    }

    private Context createContext(String test) throws URISyntaxException, MalformedURLException {
        Context ctx = new Context();
        ctx.setEntityName(this.componentName);
        URI u = new URI(test);
        ctx.setArchiveUrl(u.toURL());
        return ctx;
    }

    private String getBaseDirPath() {
        String baseDirPath = this.getClass().getResource(".").getPath();
        baseDirPath = baseDirPath.substring(0, baseDirPath.indexOf("org"));
        return baseDirPath;
    }
}

