/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.management.task.installation;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.ow2.petals.jbi.management.task.installation.InstallationUtils;
import org.ow2.petals.kernel.api.server.PetalsException;
import org.ow2.petals.util.ZipUtil;

public class InstallationUtilsTest {
    private File baseDir;
    private File testResourcesDir;
    private File extractedDir;

    @Before
    public void setUp() {
        String baseDirPath = this.getClass().getResource(".").getPath();
        baseDirPath = baseDirPath.substring(0, baseDirPath.indexOf("target"));
        baseDirPath = baseDirPath.substring(baseDirPath.indexOf(":") + 1);
        try {
            this.baseDir = new File(new URI("file:" + baseDirPath).normalize());
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        this.testResourcesDir = new File(this.baseDir, "src" + File.separator + "test" + File.separator + "resources");
        this.extractedDir = new File(this.testResourcesDir, "extracted");
    }

    @Test
    public void testCheckClassPathElements() throws IOException {
        this.extractedDir.delete();
        this.extractedDir.mkdir();
        ZipUtil.unzipArchive((File)new File(this.testResourcesDir, "test-ziputil.zip"), (File)this.extractedDir);
        ArrayList<String> classpathElements = new ArrayList<String>();
        classpathElements.add("Lib01.jar");
        classpathElements.add("Lib02.jar");
        classpathElements.add("META-INF/jbi.xml");
        try {
            InstallationUtils.checkClassPathElements((File)this.extractedDir, classpathElements);
        }
        catch (PetalsException e) {
            Assert.fail((String)"Can't find all classpath elements");
        }
        FileUtils.forceDelete((File)this.extractedDir);
    }

    @Test
    public void testCheckClassPathElements2() throws IOException {
        this.extractedDir.delete();
        this.extractedDir.mkdir();
        ZipUtil.unzipArchive((File)new File(this.testResourcesDir, "test-ziputil.zip"), (File)this.extractedDir);
        ArrayList<String> classpathElements = new ArrayList<String>();
        classpathElements.add("toto.jar");
        try {
            InstallationUtils.checkClassPathElements((File)this.extractedDir, classpathElements);
            Assert.fail((String)"Can find an inexistant classpath element");
        }
        catch (PetalsException petalsException) {
            // empty catch block
        }
        FileUtils.forceDelete((File)this.extractedDir);
    }

    @Test
    public void testCheckClassPathElements3() throws IOException {
        this.extractedDir.delete();
        this.extractedDir.mkdir();
        ZipUtil.unzipArchive((File)new File(this.testResourcesDir, "test-ziputil.zip"), (File)this.extractedDir);
        ArrayList<String> classpathElements = new ArrayList<String>();
        classpathElements.add("");
        try {
            InstallationUtils.checkClassPathElements((File)this.extractedDir, classpathElements);
            Assert.fail((String)"Can find an empty classpath element");
        }
        catch (PetalsException petalsException) {
            // empty catch block
        }
        FileUtils.forceDelete((File)this.extractedDir);
    }
}

