/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.management.task.installation.install.component;

import java.io.File;
import java.util.logging.Logger;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.ow2.petals.jbi.management.Context;
import org.ow2.petals.jbi.management.task.installation.install.component.CreateComponentStateHolderTask;
import org.ow2.petals.system.systemstate.SystemStateService;
import org.ow2.petals.system.systemstate.exception.ComponentAlreadyExistsException;
import org.ow2.petals.systemstate.generated.Component;
import org.ow2.petals.util.AbstractMavenTest;
import org.ow2.petals.util.LoggingUtil;

public class CreateComponentStateHolderTaskTest
extends AbstractMavenTest {
    private static final String COMPONENT_NAME = "myComponentName";
    private static final String ARCHIVE_FILE_NAME = "archive.zip";
    final LoggingUtil log = new LoggingUtil(Logger.getLogger(CreateComponentStateHolderTaskTest.class.getName()));
    private String petalsHomeDir;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.petalsHomeDir = new File(this.targetDir, "petals-home").getAbsolutePath();
    }

    @Test
    public void testCreateComponentStateHolderTask_000() throws Exception {
        SystemStateService systemStateSvc = (SystemStateService)EasyMock.createMock(SystemStateService.class);
        EasyMock.expect((Object)systemStateSvc.createComponentStateHolder(COMPONENT_NAME, this.targetDir.toURI().toURL(), ARCHIVE_FILE_NAME)).andAnswer((IAnswer)new IAnswer<Component>(){

            public Component answer() throws Throwable {
                Component component = new Component();
                component.setName(CreateComponentStateHolderTaskTest.COMPONENT_NAME);
                return component;
            }
        });
        EasyMock.replay((Object[])new Object[]{systemStateSvc});
        Context ctx = new Context();
        ctx.setEntityName(COMPONENT_NAME);
        ctx.setArchiveUrl(new File(this.targetDir, ARCHIVE_FILE_NAME).toURI().toURL());
        ctx.setInstallUrl(this.targetDir.toURI().toURL());
        CreateComponentStateHolderTask task = new CreateComponentStateHolderTask(this.log, systemStateSvc, this.petalsHomeDir);
        task.execute(ctx);
        EasyMock.verify((Object[])new Object[]{systemStateSvc});
    }

    @Test
    public void testCreateComponentStateHolderTask_001() throws Exception {
        SystemStateService systemStateSvc = (SystemStateService)EasyMock.createMock(SystemStateService.class);
        EasyMock.expect((Object)systemStateSvc.createComponentStateHolder(COMPONENT_NAME, this.targetDir.toURI().toURL(), ARCHIVE_FILE_NAME)).andAnswer((IAnswer)new IAnswer<Component>(){

            public Component answer() throws Throwable {
                Component component = new Component();
                component.setName(CreateComponentStateHolderTaskTest.COMPONENT_NAME);
                return component;
            }
        });
        EasyMock.expect((Object)systemStateSvc.createComponentStateHolder(COMPONENT_NAME, this.targetDir.toURI().toURL(), ARCHIVE_FILE_NAME)).andThrow((Throwable)new ComponentAlreadyExistsException(COMPONENT_NAME));
        EasyMock.replay((Object[])new Object[]{systemStateSvc});
        Context ctx1 = new Context();
        ctx1.setEntityName(COMPONENT_NAME);
        ctx1.setArchiveUrl(new File(this.targetDir, ARCHIVE_FILE_NAME).toURI().toURL());
        ctx1.setInstallUrl(this.targetDir.toURI().toURL());
        CreateComponentStateHolderTask task1 = new CreateComponentStateHolderTask(this.log, systemStateSvc, this.petalsHomeDir);
        task1.execute(ctx1);
        try {
            Context ctx2 = new Context();
            ctx2.setEntityName(COMPONENT_NAME);
            ctx2.setArchiveUrl(new File(this.targetDir, ARCHIVE_FILE_NAME).toURI().toURL());
            ctx2.setInstallUrl(this.targetDir.toURI().toURL());
            CreateComponentStateHolderTask task2 = new CreateComponentStateHolderTask(this.log, systemStateSvc, this.petalsHomeDir);
            task2.execute(ctx2);
            Assert.fail((String)("The exception " + ComponentAlreadyExistsException.class.getName() + " is not raised."));
        }
        catch (ComponentAlreadyExistsException componentAlreadyExistsException) {
            // empty catch block
        }
        EasyMock.verify((Object[])new Object[]{systemStateSvc});
    }

    @Test
    public void testCreateComponentStateHolderTask_002() throws Exception {
        SystemStateService systemStateSvc = (SystemStateService)EasyMock.createMock(SystemStateService.class);
        final Component component = new Component();
        component.setName(COMPONENT_NAME);
        EasyMock.expect((Object)systemStateSvc.createComponentStateHolder(COMPONENT_NAME, this.targetDir.toURI().toURL(), ARCHIVE_FILE_NAME)).andAnswer((IAnswer)new IAnswer<Component>(){

            public Component answer() throws Throwable {
                return component;
            }
        });
        EasyMock.expect((Object)systemStateSvc.deleteComponentStateHolder(COMPONENT_NAME)).andAnswer((IAnswer)new IAnswer<Component>(){

            public Component answer() throws Throwable {
                return component;
            }
        });
        EasyMock.replay((Object[])new Object[]{systemStateSvc});
        Context ctx = new Context();
        ctx.setEntityName(COMPONENT_NAME);
        ctx.setArchiveUrl(new File(this.targetDir, ARCHIVE_FILE_NAME).toURI().toURL());
        ctx.setInstallUrl(this.targetDir.toURI().toURL());
        CreateComponentStateHolderTask task = new CreateComponentStateHolderTask(this.log, systemStateSvc, this.petalsHomeDir);
        task.execute(ctx);
        task.undo(ctx);
        EasyMock.verify((Object[])new Object[]{systemStateSvc});
    }

    @Test
    public void testCreateComponentStateHolderTask_003() throws Exception {
        SystemStateService systemStateSvc = (SystemStateService)EasyMock.createMock(SystemStateService.class);
        EasyMock.expect((Object)systemStateSvc.deleteComponentStateHolder(COMPONENT_NAME)).andAnswer((IAnswer)new IAnswer<Component>(){

            public Component answer() throws Throwable {
                Component component = new Component();
                component.setName(CreateComponentStateHolderTaskTest.COMPONENT_NAME);
                return component;
            }
        });
        EasyMock.replay((Object[])new Object[]{systemStateSvc});
        Context ctx = new Context();
        ctx.setEntityName(COMPONENT_NAME);
        ctx.setArchiveUrl(new File(this.targetDir, ARCHIVE_FILE_NAME).toURI().toURL());
        ctx.setInstallUrl(this.targetDir.toURI().toURL());
        CreateComponentStateHolderTask task = new CreateComponentStateHolderTask(this.log, systemStateSvc, this.petalsHomeDir);
        task.undo(ctx);
        EasyMock.verify((Object[])new Object[]{systemStateSvc});
    }
}

