/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.management.task.installation.install.component;

import java.io.FileNotFoundException;
import java.util.logging.Logger;
import org.easymock.EasyMock;
import org.junit.Test;
import org.ow2.petals.jbi.management.Context;
import org.ow2.petals.jbi.management.task.installation.uninstall.component.RemoveComponentRepositoryTask;
import org.ow2.petals.system.repository.RepositoryService;
import org.ow2.petals.util.AbstractMavenTest;
import org.ow2.petals.util.LoggingUtil;

public class RemoveComponentRepositoryTaskTest
extends AbstractMavenTest {
    private static final String COMPONENT_NAME = "myComponentName";
    final LoggingUtil log = new LoggingUtil(Logger.getLogger(RemoveComponentRepositoryTaskTest.class.getName()));

    @Test
    public void testRemoveComponentRepositoryTask_000() throws Exception {
        RepositoryService repositorySvc = (RepositoryService)EasyMock.createMock(RepositoryService.class);
        repositorySvc.removeComponent(COMPONENT_NAME);
        EasyMock.replay((Object[])new Object[]{repositorySvc});
        Context ctx = new Context();
        ctx.setEntityName(COMPONENT_NAME);
        RemoveComponentRepositoryTask task = new RemoveComponentRepositoryTask(this.log, repositorySvc);
        task.execute(ctx);
        EasyMock.verify((Object[])new Object[]{repositorySvc});
    }

    @Test
    public void testRemoveComponentRepositoryTask_001() throws Exception {
        RepositoryService repositorySvc = (RepositoryService)EasyMock.createMock(RepositoryService.class);
        repositorySvc.removeComponent(COMPONENT_NAME);
        repositorySvc.removeComponent(COMPONENT_NAME);
        EasyMock.expectLastCall().andThrow((Throwable)new FileNotFoundException());
        EasyMock.replay((Object[])new Object[]{repositorySvc});
        Context ctx1 = new Context();
        ctx1.setEntityName(COMPONENT_NAME);
        RemoveComponentRepositoryTask task1 = new RemoveComponentRepositoryTask(this.log, repositorySvc);
        task1.execute(ctx1);
        Context ctx2 = new Context();
        ctx2.setEntityName(COMPONENT_NAME);
        RemoveComponentRepositoryTask task2 = new RemoveComponentRepositoryTask(this.log, repositorySvc);
        task2.execute(ctx2);
        EasyMock.verify((Object[])new Object[]{repositorySvc});
    }
}

