/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.management.task.installation.install.component;

import java.util.logging.Logger;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.Test;
import org.ow2.petals.jbi.management.Context;
import org.ow2.petals.jbi.management.task.installation.uninstall.component.RemoveComponentStateHolderTask;
import org.ow2.petals.system.systemstate.SystemStateService;
import org.ow2.petals.systemstate.generated.Component;
import org.ow2.petals.util.AbstractMavenTest;
import org.ow2.petals.util.LoggingUtil;

public class RemoveComponentStateHolderTaskTest
extends AbstractMavenTest {
    private static final String COMPONENT_NAME = "myComponentName";
    final LoggingUtil log = new LoggingUtil(Logger.getLogger(RemoveComponentStateHolderTaskTest.class.getName()));

    @Test
    public void testRemoveComponentStateHolderTask_000() throws Exception {
        SystemStateService systemStateSvc = (SystemStateService)EasyMock.createMock(SystemStateService.class);
        EasyMock.expect((Object)systemStateSvc.deleteComponentStateHolder(COMPONENT_NAME)).andAnswer((IAnswer)new IAnswer<Component>(){

            public Component answer() throws Throwable {
                Component component = new Component();
                component.setName(RemoveComponentStateHolderTaskTest.COMPONENT_NAME);
                return component;
            }
        });
        EasyMock.replay((Object[])new Object[]{systemStateSvc});
        Context ctx = new Context();
        ctx.setEntityName(COMPONENT_NAME);
        RemoveComponentStateHolderTask task = new RemoveComponentStateHolderTask(this.log, systemStateSvc);
        task.execute(ctx);
        TestCase.assertEquals((String)COMPONENT_NAME, (String)ctx.getComponentStateHolder().getName());
        EasyMock.verify((Object[])new Object[]{systemStateSvc});
    }

    @Test
    public void testRemoveComponentStateHolderTask_001() throws Exception {
        SystemStateService systemStateSvc = (SystemStateService)EasyMock.createMock(SystemStateService.class);
        EasyMock.expect((Object)systemStateSvc.deleteComponentStateHolder(COMPONENT_NAME)).andAnswer((IAnswer)new IAnswer<Component>(){

            public Component answer() throws Throwable {
                Component component = new Component();
                component.setName(RemoveComponentStateHolderTaskTest.COMPONENT_NAME);
                return component;
            }
        });
        EasyMock.expect((Object)systemStateSvc.deleteComponentStateHolder(COMPONENT_NAME)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{systemStateSvc});
        Context ctx1 = new Context();
        ctx1.setEntityName(COMPONENT_NAME);
        RemoveComponentStateHolderTask task1 = new RemoveComponentStateHolderTask(this.log, systemStateSvc);
        task1.execute(ctx1);
        TestCase.assertEquals((String)COMPONENT_NAME, (String)ctx1.getComponentStateHolder().getName());
        Context ctx2 = new Context();
        ctx2.setEntityName(COMPONENT_NAME);
        RemoveComponentStateHolderTask task2 = new RemoveComponentStateHolderTask(this.log, systemStateSvc);
        task2.execute(ctx2);
        TestCase.assertNull((String)"Returned component state holder not null", (Object)ctx2.getComponentStateHolder());
        EasyMock.verify((Object[])new Object[]{systemStateSvc});
    }
}

