/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.messaging.exchange;

import java.net.URI;
import java.util.logging.Logger;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOptionalOut;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.RobustInOnly;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfOperation;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.jbi.messaging.exchange.PersistedContextualMessageExchangeFactoryImpl;
import org.ow2.petals.jbi.messaging.exchange.PersistedContextualMessageExchangeFactoryImplTest;

public class PersistedMessageExchangeFactoryForEndpointImplTest
extends PersistedContextualMessageExchangeFactoryImplTest {
    protected static final String PROVIDED_PROCESS_INSTANCE_ID = "a54b74d9-47cd-e8d7-12db-14562ad778cb";
    private javax.jbi.servicedesc.ServiceEndpoint targetEndpoint = (javax.jbi.servicedesc.ServiceEndpoint)Mockito.mock(ServiceEndpoint.class);

    @Override
    protected MessageExchangeFactory createTestMessageExchangeFactory() {
        return PersistedContextualMessageExchangeFactoryImpl.createContextualMessageExchangeFactoryForEndpoint((javax.jbi.servicedesc.ServiceEndpoint)this.consumerEndpointMock, (Logger)this.logger, (javax.jbi.servicedesc.ServiceEndpoint)this.targetEndpoint);
    }

    @Test
    public void testCreateExchangeFromServAndOpUseFactorySpecificTargetEp() throws MessagingException {
        QName serviceName = new QName("targetService");
        QName opName = new QName("targetOperation");
        MessageExchange actualMessageExchange = this.messageExchangeFactory.createExchange(serviceName, opName);
        this.assertGeneratedExchangeUseFactorySpecificTargetEp(actualMessageExchange);
    }

    @Test
    public void testCreateExchangeFromJBIPatternUseFactorySpecificTargetEp() throws MessagingException {
        URI pattern = AbsItfOperation.MEPPatternConstants.IN_ONLY.value();
        MessageExchange actualMessageExchange = this.messageExchangeFactory.createExchange(pattern);
        this.assertGeneratedExchangeUseFactorySpecificTargetEp(actualMessageExchange);
    }

    @Test
    public void testCreateInOnlyExchangeUseFactorySpecificTargetEp() throws MessagingException {
        InOnly actualMessageExchange = this.messageExchangeFactory.createInOnlyExchange();
        this.assertGeneratedExchangeUseFactorySpecificTargetEp((MessageExchange)actualMessageExchange);
    }

    @Test
    public void testCreateInOptionalOutExchangeUseFactorySpecificTargetEp() throws MessagingException {
        InOptionalOut actualMessageExchange = this.messageExchangeFactory.createInOptionalOutExchange();
        this.assertGeneratedExchangeUseFactorySpecificTargetEp((MessageExchange)actualMessageExchange);
    }

    @Test
    public void testCreateInOutExchangeUseFactorySpecificTargetEp() throws MessagingException {
        InOut actualMessageExchange = this.messageExchangeFactory.createInOutExchange();
        this.assertGeneratedExchangeUseFactorySpecificTargetEp((MessageExchange)actualMessageExchange);
    }

    @Test
    public void testCreateRobustInOnlyExchangeUseFactorySpecificTargetEp() throws MessagingException {
        RobustInOnly actualMessageExchange = this.messageExchangeFactory.createRobustInOnlyExchange();
        this.assertGeneratedExchangeUseFactorySpecificTargetEp((MessageExchange)actualMessageExchange);
    }

    private void assertGeneratedExchangeUseFactorySpecificTargetEp(MessageExchange actualMessageExchange) {
        Assert.assertEquals((String)"Returned exchange must target factory specific endpoint", (Object)this.targetEndpoint, (Object)actualMessageExchange.getEndpoint());
    }
}

