/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.system.classloader;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.ow2.petals.system.classloader.ComponentClassLoader;
import org.ow2.petals.system.classloader.SharedLibrariesClassLoader;
import org.ow2.petals.system.classloader.SharedLibraryClassLoader;

public class ComponentClassLoaderTest {
    private ComponentClassLoader componentClassLoader;
    private SharedLibraryClassLoader sharedLibraryClassLoader;

    @Before
    public void setUp() throws IOException {
        SharedLibrariesClassLoader sharedLibrariesClassLoader = new SharedLibrariesClassLoader(this.getClass().getClassLoader());
        ArrayList<URL> baseUrls = new ArrayList<URL>();
        ArrayList<String> classpathLocations = new ArrayList<String>();
        classpathLocations.add("petals-core-test.jar");
        String baseDir = this.getClass().getResource(".").toString();
        baseDir = baseDir.substring(0, baseDir.indexOf("target"));
        baseDir = baseDir.substring(baseDir.indexOf(":") + 1);
        baseUrls.add(new URL("file:" + baseDir.replace(File.separator, "/") + "src/test/resources/"));
        baseUrls.add(new URL("file:" + baseDir.replace(File.separator, "/") + "target/test-classes/"));
        baseUrls.add(new URL("file:" + baseDir.replace(File.separator, "/") + "target/"));
        this.sharedLibraryClassLoader = new SharedLibraryClassLoader(baseUrls.toArray(new URL[0]), classpathLocations);
        this.sharedLibraryClassLoader.setParentFirst(false);
        sharedLibrariesClassLoader.addSharedLibraryClassLoader("1", this.sharedLibraryClassLoader);
        baseUrls = new ArrayList();
        classpathLocations = new ArrayList();
        classpathLocations.add("petals-common-test.jar");
        baseUrls.add(new URL("file:" + baseDir.replace(File.separator, "/") + "src/test/resources/"));
        ArrayList<String> slNames = new ArrayList<String>();
        slNames.add("1");
        this.componentClassLoader = new ComponentClassLoader(baseUrls.toArray(new URL[0]), classpathLocations, sharedLibrariesClassLoader, slNames);
    }

    @Test
    public void testGetClasspath() {
        String compoCP = "testGetClasspath - component classpath " + this.componentClassLoader.getClasspath();
        compoCP.length();
        String slCP = "testGetClasspath - shared library classpath " + this.sharedLibraryClassLoader.getClasspath();
        slCP.length();
    }

    @Test
    public void testGetResourceInSelfAndParentSelfFirst() {
        this.componentClassLoader.setParentFirst(false);
        URL url = this.componentClassLoader.getResource("resourceBoth.txt");
        if (url == null) {
            Assert.fail((String)"testGetResourceInSelfAndParentSelfFirst - resource not found ");
        }
    }

    @Test
    public void testGetResourceInSelfAndParentParentFirst() {
        this.componentClassLoader.setParentFirst(true);
        URL url = this.componentClassLoader.getResource("resourceBoth.txt");
        if (url == null) {
            Assert.fail((String)"testGetResourceInSelfAndParentParentFirst - resource not found ");
        }
    }

    @Test
    public void testGetResourceAsStreamInSelfAndParentSelfFirst() throws IOException {
        this.componentClassLoader.setParentFirst(false);
        InputStream inputStream = this.componentClassLoader.getResourceAsStream("resourceBoth.txt");
        if (inputStream != null) {
            DataInputStream dis = new DataInputStream(inputStream);
            byte[] content = new byte[dis.available()];
            dis.readFully(content);
        } else {
            Assert.fail((String)"testGetResourceAsStreamInSelfAndParentSelfFirst - resource not found ");
        }
    }

    @Test
    public void testGetResourceAsStreamInSelfAndParentParentFirst() throws IOException {
        this.componentClassLoader.setParentFirst(true);
        InputStream inputStream = this.componentClassLoader.getResourceAsStream("resourceBoth.txt");
        if (inputStream != null) {
            DataInputStream dis = new DataInputStream(inputStream);
            byte[] content = new byte[dis.available()];
            dis.readFully(content);
        } else {
            Assert.fail((String)"testGetResourceAsStreamInSelfAndParentParentFirst - resource not found ");
        }
    }

    @Test
    public void testGetResourceAsStreamInParentSelfFirst() throws IOException {
        this.componentClassLoader.setParentFirst(false);
        InputStream inputStream = this.componentClassLoader.getResourceAsStream("resourceCore.txt");
        if (inputStream != null) {
            DataInputStream dis = new DataInputStream(inputStream);
            byte[] content = new byte[dis.available()];
            dis.readFully(content);
        } else {
            Assert.fail((String)"testGetResourceAsStreamInParentSelfFirst - resource not found ");
        }
    }

    @Test
    public void testGetResourceAsStreamInSelfParentFirst() throws IOException {
        this.componentClassLoader.setParentFirst(true);
        InputStream inputStream = this.componentClassLoader.getResourceAsStream("resourceContainer.txt");
        if (inputStream != null) {
            DataInputStream dis = new DataInputStream(inputStream);
            byte[] content = new byte[dis.available()];
            dis.readFully(content);
        } else {
            Assert.fail((String)"testGetResourceAsStreamInSelfParentFirst - resource not found ");
        }
    }

    @Test
    public void testLoadClassParentFirst() {
        this.componentClassLoader.setParentFirst(true);
        try {
            Class clazz = this.componentClassLoader.loadClass("org.objectweb.petals.ServiceContext", false);
            if (clazz == null) {
                Assert.fail((String)"testLoadClassParentFirst - class not found ");
            }
        }
        catch (ClassNotFoundException e) {
            Assert.fail((String)"testLoadClassParentFirst - class not found ");
        }
    }

    @Test
    public void testLoadClassSelfFirst() {
        this.componentClassLoader.setParentFirst(false);
        try {
            Class clazz = this.componentClassLoader.loadClass("org.objectweb.petals.PetalsException", false);
            if (clazz == null) {
                Assert.fail((String)"testLoadClassSelfFirst - class not found ");
            }
        }
        catch (ClassNotFoundException e) {
            Assert.fail((String)"testLoadClassSelfFirst - class not found ");
        }
    }

    @Test
    public void testLoadClassInSelfAndParentParentFirst() throws InstantiationException, IllegalAccessException {
        this.componentClassLoader.setParentFirst(true);
        try {
            Class clazz = this.componentClassLoader.loadClass("org.objectweb.petals.classloader.TestClassloader", false);
            if (clazz == null) {
                Assert.fail((String)"testLoadClassInSelfAndParentParentFirst - class not found ");
            }
        }
        catch (ClassNotFoundException e) {
            Assert.fail((String)"testLoadClassInSelfAndParentParentFirst - class not found ");
        }
    }

    @Test
    public void testLoadClassInSelfAndParentSelfFirst() throws InstantiationException, IllegalAccessException {
        this.componentClassLoader.setParentFirst(false);
        try {
            Class clazz = this.componentClassLoader.loadClass("org.objectweb.petals.classloader.TestClassloader", false);
            if (clazz == null) {
                Assert.fail((String)"testLoadClassInSelfAndParentSelfFirst - class not found ");
            }
        }
        catch (ClassNotFoundException e) {
            Assert.fail((String)"testLoadClassInSelfAndParentSelfFirst - class not found ");
        }
    }
}

