/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.system.classloader;

import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.Enumeration;
import org.easymock.classextension.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.ow2.petals.system.classloader.PetalsClassLoader;

public class PetalsClassLoaderTest {
    private PetalsClassLoader petalsClassLoader;

    @Before
    public void setUp() throws IOException {
        ArrayList<URL> baseUrls = new ArrayList<URL>();
        ArrayList classpathLocations = new ArrayList();
        String baseDir = this.getClass().getResource(".").getPath();
        baseDir = baseDir.substring(0, baseDir.indexOf("target"));
        baseDir = baseDir.substring(baseDir.indexOf(":") + 1);
        try {
            baseUrls.add(new URI("file", null, baseDir, null).normalize().toURL());
            baseUrls.add(new URI("file", null, baseDir.replace(File.separator, "/") + "target/test-classes/", null).normalize().toURL());
            baseUrls.add(new URI("file:" + baseDir.replace(File.separator, "/") + "target/").normalize().toURL());
            baseUrls.add(new URI("file", null, baseDir.replace(File.separator, "/") + "src/test/resources/junit-3.8.jar", null).normalize().toURL());
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        this.petalsClassLoader = new PetalsClassLoader(baseUrls.toArray(new URL[0]), classpathLocations);
        this.petalsClassLoader.setParentFirst(false);
    }

    @Test
    public void testGetClasspath() {
        this.petalsClassLoader.getClasspath();
    }

    @Test
    public void testLoadClassFromDirectory() {
        try {
            Class class1 = this.petalsClassLoader.loadClass("org.ow2.petals.system.classloader.ComponentClassLoaderTest", false);
            class1.getName();
        }
        catch (ClassNotFoundException e) {
            Assert.fail((String)"Class not found : org.objectweb.platform.petals.classloader.ComponentClassLoaderTest");
        }
    }

    @Test
    public void testLoadClassFromJar() {
        try {
            Class class1 = this.petalsClassLoader.loadClass("junit.framework.TestCase", false);
            class1.getName();
        }
        catch (ClassNotFoundException e) {
            Assert.fail((String)"Class not found : junit.framework.TestCase");
        }
    }

    @Test
    public void testGetResourceFromAJar() {
        URL url = this.petalsClassLoader.getResource("META-INF/MANIFEST.MF");
        if (url == null) {
            Assert.fail((String)"testGetResource - resource not found");
        }
    }

    @Test
    public void testGetResourceFromADirectory() {
        URL url = this.petalsClassLoader.getResource("src/ResourceToLoad");
        if (url == null) {
            Assert.fail((String)"testGetResource - resource not found");
        }
    }

    @Test
    public void testGetResourceThatDoesNotExist() {
        URL url = this.petalsClassLoader.getResource("test");
        if (url != null) {
            Assert.fail((String)"testGetResource - resource found problem");
        }
    }

    @Test
    public void testGetResourceAsStream() throws IOException {
        InputStream inputStream = this.petalsClassLoader.getResourceAsStream("src/ResourceToLoad");
        if (inputStream != null) {
            DataInputStream dis = new DataInputStream(inputStream);
            byte[] content = new byte[dis.available()];
            dis.readFully(content);
        } else {
            Assert.fail((String)"testGetResourceAsStream - stream not found");
        }
    }

    @Test
    public void testGetResourceAsStreamFromAJar() throws IOException {
        InputStream inputStream = this.petalsClassLoader.getResourceAsStream("META-INF/MANIFEST.MF");
        if (inputStream != null) {
            DataInputStream dis = new DataInputStream(inputStream);
            byte[] content = new byte[dis.available()];
            dis.readFully(content);
        } else {
            Assert.fail((String)"testGetResourceAsStream - stream not found");
        }
    }

    @Test
    public void testGetResources() throws IOException {
        Enumeration enumeration = this.petalsClassLoader.getResources("src/ResourceToLoad");
        if (!enumeration.hasMoreElements()) {
            Assert.fail((String)"testGetResource - resource not found");
        }
    }

    @Test
    public void testConstructor() throws Throwable {
        URLStreamHandlerFactory urlStreamHandlerFactory = (URLStreamHandlerFactory)EasyMock.createMock(URLStreamHandlerFactory.class);
        PetalsClassLoader petalsClassLoader = new PetalsClassLoader(new URL[0], new ArrayList(), this.getClass().getClassLoader(), urlStreamHandlerFactory);
        Assert.assertEquals((Object)petalsClassLoader.getParent(), (Object)this.getClass().getClassLoader());
        petalsClassLoader.close();
        Assert.assertEquals((long)petalsClassLoader.getBases().length, (long)0L);
    }
}

