/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.system.repository.artifact;

import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.ow2.petals.kernel.api.server.PetalsException;
import org.ow2.petals.system.repository.artifact.Artifact;
import org.ow2.petals.system.repository.artifact.ArtifactRepositoryService;
import org.ow2.petals.system.repository.artifact.LocalArtifactRepositoryService;

public class LocalArtifactRepositoryTest {
    private ArtifactRepositoryService repositoryService;
    private File rootPath;
    private File resourcesPath;

    private boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    this.deleteDirectory(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        return path.delete();
    }

    @Before
    public void setUp() throws Exception {
        this.rootPath = new File("artifactrepo");
        if (this.rootPath.exists()) {
            this.deleteDirectory(this.rootPath);
            this.rootPath.mkdirs();
        }
        this.repositoryService = new LocalArtifactRepositoryService(this.rootPath);
        String path = this.getClass().getResource(".").getPath();
        path = path.substring(0, path.indexOf("target"));
        path = path.substring(path.indexOf(":") + 1);
        path = path + "src/test/resources/packages/";
        path = path.replaceAll("/", Matcher.quoteReplacement(File.separator));
        this.resourcesPath = new File(path);
    }

    @After
    public void tearDown() throws Exception {
        this.deleteDirectory(this.rootPath);
    }

    @Test
    public void testAddArtifacts() throws Exception {
        Assert.assertEquals((long)this.repositoryService.getComponentsPath().listFiles().length, (long)0L);
        File component = new File(this.resourcesPath, "installation01.zip");
        Assert.assertTrue((boolean)component.exists());
        Artifact artifact = new Artifact();
        artifact.setFile(component);
        boolean result = this.repositoryService.addArtifact(artifact);
        Assert.assertTrue((boolean)result);
        Assert.assertEquals((long)this.repositoryService.getComponentsPath().listFiles().length, (long)1L);
        Assert.assertEquals((long)this.repositoryService.getServiceAssemblyPath().listFiles().length, (long)0L);
        File sa = new File(this.resourcesPath, "sa.zip");
        artifact.setFile(sa);
        result = this.repositoryService.addArtifact(artifact);
        Assert.assertTrue((boolean)result);
        Assert.assertEquals((long)this.repositoryService.getServiceAssemblyPath().listFiles().length, (long)1L);
    }

    @Test
    public void testGetComponent() {
        Assert.assertEquals((long)this.repositoryService.getComponentsPath().listFiles().length, (long)0L);
        File component = new File(this.resourcesPath, "installation01.zip");
        Artifact artifact = new Artifact();
        artifact.setFile(component);
        try {
            boolean result = this.repositoryService.addArtifact(artifact);
            Assert.assertTrue((boolean)result);
        }
        catch (PetalsException e) {
            Assert.fail((String)e.getMessage());
        }
        List components = this.repositoryService.getComponents();
        Assert.assertEquals((long)1L, (long)components.size());
        Assert.assertEquals((Object)"example-name", (Object)((Artifact)components.get(0)).getName());
        List names = this.repositoryService.getComponentsName();
        Assert.assertEquals((long)1L, (long)names.size());
        Assert.assertEquals((Object)"example-name", names.get(0));
    }
}

