/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.system.systemstate;

import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.List;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import org.ow2.petals.system.repository.RepositoryService;
import org.ow2.petals.system.systemstate.SystemStateService;
import org.ow2.petals.system.systemstate.SystemStateServiceImpl;
import org.ow2.petals.system.systemstate.exception.ComponentAlreadyExistsException;
import org.ow2.petals.system.systemstate.exception.ServiceAssemblyAlreadyExistsException;
import org.ow2.petals.system.systemstate.exception.SharedLibraryAlreadyExistsException;
import org.ow2.petals.systemstate.SystemStateBuilder;
import org.ow2.petals.systemstate.SystemStateException;
import org.ow2.petals.systemstate.generated.Component;
import org.ow2.petals.systemstate.generated.Components;
import org.ow2.petals.systemstate.generated.ServiceAssemblies;
import org.ow2.petals.systemstate.generated.ServiceAssembly;
import org.ow2.petals.systemstate.generated.SharedLibraries;
import org.ow2.petals.systemstate.generated.SharedLibrary;
import org.ow2.petals.systemstate.generated.SystemState;
import org.ow2.petals.testutil.PrivateAccessor;
import org.ow2.petals.util.AbstractMavenTest;

public class SystemStateServiceImplTest
extends AbstractMavenTest {
    private static final String COMPONENT_NAME = "myComponentName";
    private static final String SA_NAME = "myServiceAssemblyName";
    private static final String SL_NAME = "mySharedLibrarieName";
    private static final String SL_VERSION = "1.0.0";
    private static final String ARCHIVE_NAME = "archive.zip";
    private static final String SYSTEMSTATE_FILE = "system-state.xml";

    private SystemStateService createSystemStateService(File repositoryDirectory) throws Exception {
        RepositoryService repositoryServiceMock = (RepositoryService)EasyMock.createMock(RepositoryService.class);
        EasyMock.expect((Object)repositoryServiceMock.getRepositoryDirectory()).andReturn((Object)repositoryDirectory);
        EasyMock.replay((Object[])new Object[]{repositoryServiceMock});
        SystemStateServiceImpl systemStateSvc = new SystemStateServiceImpl();
        PrivateAccessor.setPrivateField(systemStateSvc, "repositoryService", repositoryServiceMock);
        Method methodStart = systemStateSvc.getClass().getDeclaredMethod("start", new Class[0]);
        methodStart.setAccessible(true);
        methodStart.invoke((Object)systemStateSvc, new Object[0]);
        return systemStateSvc;
    }

    @Test
    public void testCreateComponentStateHolder_000() throws Exception {
        File repositoryHomeDir = new File(this.targetDir, "testCreateComponentStateHolder_000");
        File systemStateFile = new File(repositoryHomeDir, SYSTEMSTATE_FILE);
        if (systemStateFile.exists()) {
            Assert.assertTrue((boolean)systemStateFile.delete());
        }
        File componentHomeDir = new File(repositoryHomeDir, COMPONENT_NAME);
        SystemStateService systemStateSvc = this.createSystemStateService(repositoryHomeDir);
        try {
            systemStateSvc.createComponentStateHolder(COMPONENT_NAME, componentHomeDir.toURI().toURL(), ARCHIVE_NAME);
            List components = systemStateSvc.getComponentStateHolders();
            Assert.assertEquals((long)1L, (long)components.size());
            Component component = (Component)components.get(0);
            Assert.assertEquals((Object)COMPONENT_NAME, (Object)component.getName());
            Assert.assertEquals((Object)ARCHIVE_NAME, (Object)component.getArchiveName());
            Assert.assertEquals((Object)"Uninstalled", (Object)component.getInstallState());
            Assert.assertEquals((Object)componentHomeDir.toURI().toURL().toString(), (Object)component.getInstallURL());
            Assert.assertEquals((Object)"Unknown", (Object)component.getLifecycleState());
        }
        catch (ComponentAlreadyExistsException e) {
            Assert.fail((String)("Unexpected exception: " + ((Object)((Object)e)).getClass().getName()));
        }
        catch (MalformedURLException e) {
            Assert.fail((String)("Unexpected exception: " + e.getClass().getName()));
        }
        catch (SystemStateException e) {
            Assert.fail((String)("Unexpected exception: " + ((Object)((Object)e)).getClass().getName()));
        }
    }

    @Test
    public void testCreateComponentStateHolder_001() throws Exception {
        File repositoryHomeDir = new File(this.targetDir, "testCreateComponentStateHolder_001");
        File systemStateFile = new File(repositoryHomeDir, SYSTEMSTATE_FILE);
        if (systemStateFile.exists()) {
            Assert.assertTrue((boolean)systemStateFile.delete());
        }
        SystemStateService systemStateSvc = this.createSystemStateService(repositoryHomeDir);
        try {
            try {
                File componentHomeDir1 = new File(repositoryHomeDir, COMPONENT_NAME);
                systemStateSvc.createComponentStateHolder(COMPONENT_NAME, componentHomeDir1.toURI().toURL(), ARCHIVE_NAME);
                List components = systemStateSvc.getComponentStateHolders();
                Assert.assertEquals((long)1L, (long)components.size());
                Component component = (Component)components.get(0);
                Assert.assertEquals((Object)COMPONENT_NAME, (Object)component.getName());
                Assert.assertEquals((Object)ARCHIVE_NAME, (Object)component.getArchiveName());
                Assert.assertEquals((Object)"Uninstalled", (Object)component.getInstallState());
                Assert.assertEquals((Object)componentHomeDir1.toURI().toURL().toString(), (Object)component.getInstallURL());
                Assert.assertEquals((Object)"Unknown", (Object)component.getLifecycleState());
            }
            catch (ComponentAlreadyExistsException e) {
                Assert.fail((String)("Unexpected exception: " + ((Object)((Object)e)).getClass().getName()));
            }
            File componentHomeDir2 = new File(repositoryHomeDir, COMPONENT_NAME);
            try {
                systemStateSvc.createComponentStateHolder(COMPONENT_NAME, componentHomeDir2.toURI().toURL(), ARCHIVE_NAME);
                Assert.fail((String)("The exception " + ComponentAlreadyExistsException.class.getName() + " is not raised."));
            }
            catch (ComponentAlreadyExistsException e) {
                List components = systemStateSvc.getComponentStateHolders();
                Assert.assertEquals((long)1L, (long)components.size());
                Component component = (Component)components.get(0);
                Assert.assertEquals((Object)COMPONENT_NAME, (Object)component.getName());
                Assert.assertEquals((Object)ARCHIVE_NAME, (Object)component.getArchiveName());
                Assert.assertEquals((Object)"Uninstalled", (Object)component.getInstallState());
                Assert.assertEquals((Object)componentHomeDir2.toURI().toURL().toString(), (Object)component.getInstallURL());
                Assert.assertEquals((Object)"Unknown", (Object)component.getLifecycleState());
            }
        }
        catch (MalformedURLException e) {
            Assert.fail((String)("Unexpected exception: " + e.getClass().getName()));
        }
        catch (SystemStateException e) {
            Assert.fail((String)("Unexpected exception: " + ((Object)((Object)e)).getClass().getName()));
        }
    }

    @Test
    public void testCreateServiceAssemblyStateHolder_000() throws Exception {
        File repositoryHomeDir = new File(this.targetDir, "testCreateServiceAssemblyStateHolder_000");
        File systemStateFile = new File(repositoryHomeDir, SYSTEMSTATE_FILE);
        if (systemStateFile.exists()) {
            Assert.assertTrue((boolean)systemStateFile.delete());
        }
        File saHomeDir = new File(repositoryHomeDir, SA_NAME);
        SystemStateService systemStateSvc = this.createSystemStateService(repositoryHomeDir);
        try {
            systemStateSvc.createServiceAssemblyStateHolder(SA_NAME, saHomeDir.toURI().toURL(), ARCHIVE_NAME);
            List serviceAssemblies = systemStateSvc.getServiceAssemblyStateHolders();
            Assert.assertEquals((long)1L, (long)serviceAssemblies.size());
            ServiceAssembly serviceAssembly = (ServiceAssembly)serviceAssemblies.get(0);
            Assert.assertEquals((Object)SA_NAME, (Object)serviceAssembly.getName());
            Assert.assertEquals((Object)ARCHIVE_NAME, (Object)serviceAssembly.getArchiveName());
            Assert.assertEquals((Object)saHomeDir.toURI().toURL().toString(), (Object)serviceAssembly.getInstallURL());
            Assert.assertEquals((Object)"Unknown", (Object)serviceAssembly.getLifecycleState());
        }
        catch (ServiceAssemblyAlreadyExistsException e) {
            Assert.fail((String)("Unexpected exception: " + ((Object)((Object)e)).getClass().getName()));
        }
        catch (MalformedURLException e) {
            Assert.fail((String)("Unexpected exception: " + e.getClass().getName()));
        }
        catch (SystemStateException e) {
            Assert.fail((String)("Unexpected exception: " + ((Object)((Object)e)).getClass().getName()));
        }
    }

    @Test
    public void testCreateServiceAssemblyStateHolder_001() throws Exception {
        File repositoryHomeDir = new File(this.targetDir, "testCreateServiceAssemblyStateHolder_001");
        File systemStateFile = new File(repositoryHomeDir, SYSTEMSTATE_FILE);
        if (systemStateFile.exists()) {
            Assert.assertTrue((boolean)systemStateFile.delete());
        }
        SystemStateService systemStateSvc = this.createSystemStateService(repositoryHomeDir);
        try {
            try {
                File saHomeDir1 = new File(repositoryHomeDir, SA_NAME);
                systemStateSvc.createServiceAssemblyStateHolder(SA_NAME, saHomeDir1.toURI().toURL(), ARCHIVE_NAME);
                List serviceAssemblies = systemStateSvc.getServiceAssemblyStateHolders();
                Assert.assertEquals((long)1L, (long)serviceAssemblies.size());
                ServiceAssembly serviceAssembly = (ServiceAssembly)serviceAssemblies.get(0);
                Assert.assertEquals((Object)SA_NAME, (Object)serviceAssembly.getName());
                Assert.assertEquals((Object)ARCHIVE_NAME, (Object)serviceAssembly.getArchiveName());
                Assert.assertEquals((Object)saHomeDir1.toURI().toURL().toString(), (Object)serviceAssembly.getInstallURL());
                Assert.assertEquals((Object)"Unknown", (Object)serviceAssembly.getLifecycleState());
            }
            catch (ServiceAssemblyAlreadyExistsException e) {
                Assert.fail((String)("Unexpected exception: " + ((Object)((Object)e)).getClass().getName()));
            }
            File saHomeDir2 = new File(repositoryHomeDir, SA_NAME);
            try {
                systemStateSvc.createServiceAssemblyStateHolder(SA_NAME, saHomeDir2.toURI().toURL(), ARCHIVE_NAME);
                Assert.fail((String)("The exception " + ServiceAssemblyAlreadyExistsException.class.getName() + " is not raised."));
            }
            catch (ServiceAssemblyAlreadyExistsException e) {
                List serviceAssemblies = systemStateSvc.getServiceAssemblyStateHolders();
                Assert.assertEquals((long)1L, (long)serviceAssemblies.size());
                ServiceAssembly serviceAssembly = (ServiceAssembly)serviceAssemblies.get(0);
                Assert.assertEquals((Object)SA_NAME, (Object)serviceAssembly.getName());
                Assert.assertEquals((Object)ARCHIVE_NAME, (Object)serviceAssembly.getArchiveName());
                Assert.assertEquals((Object)saHomeDir2.toURI().toURL().toString(), (Object)serviceAssembly.getInstallURL());
                Assert.assertEquals((Object)"Unknown", (Object)serviceAssembly.getLifecycleState());
            }
        }
        catch (MalformedURLException e) {
            Assert.fail((String)("Unexpected exception: " + e.getClass().getName()));
        }
        catch (SystemStateException e) {
            Assert.fail((String)("Unexpected exception: " + ((Object)((Object)e)).getClass().getName()));
        }
    }

    @Test
    public void testCreateSharedLibraryStateHolder_000() throws Exception {
        File repositoryHomeDir = new File(this.targetDir, "testCreateSharedLibraryStateHolder_000");
        File systemStateFile = new File(repositoryHomeDir, SYSTEMSTATE_FILE);
        if (systemStateFile.exists()) {
            Assert.assertTrue((boolean)systemStateFile.delete());
        }
        File slHomeDir = new File(repositoryHomeDir, SL_NAME);
        SystemStateService systemStateSvc = this.createSystemStateService(repositoryHomeDir);
        try {
            systemStateSvc.createSharedLibraryStateHolder(SL_NAME, SL_VERSION, slHomeDir.toURI().toURL(), ARCHIVE_NAME);
            List sharedLibraries = systemStateSvc.getSharedLibraryStateHolders();
            Assert.assertEquals((long)1L, (long)sharedLibraries.size());
            SharedLibrary sharedLibrary = (SharedLibrary)sharedLibraries.get(0);
            Assert.assertEquals((Object)SL_NAME, (Object)sharedLibrary.getName());
            Assert.assertEquals((Object)SL_VERSION, (Object)sharedLibrary.getVersion());
            Assert.assertEquals((Object)ARCHIVE_NAME, (Object)sharedLibrary.getArchiveName());
            Assert.assertEquals((Object)slHomeDir.toURI().toURL().toString(), (Object)sharedLibrary.getInstallURL());
        }
        catch (SharedLibraryAlreadyExistsException e) {
            Assert.fail((String)("Unexpected exception: " + ((Object)((Object)e)).getClass().getName()));
        }
        catch (MalformedURLException e) {
            Assert.fail((String)("Unexpected exception: " + e.getClass().getName()));
        }
        catch (SystemStateException e) {
            Assert.fail((String)("Unexpected exception: " + ((Object)((Object)e)).getClass().getName()));
        }
    }

    @Test
    public void testCreateSharedLibraryStateHolder_001() throws Exception {
        File repositoryHomeDir = new File(this.targetDir, "testCreateSharedLibraryStateHolder_001");
        File systemStateFile = new File(repositoryHomeDir, SYSTEMSTATE_FILE);
        if (systemStateFile.exists()) {
            Assert.assertTrue((boolean)systemStateFile.delete());
        }
        SystemStateService systemStateSvc = this.createSystemStateService(repositoryHomeDir);
        try {
            try {
                File slHomeDir1 = new File(repositoryHomeDir, SL_NAME);
                systemStateSvc.createSharedLibraryStateHolder(SL_NAME, SL_VERSION, slHomeDir1.toURI().toURL(), ARCHIVE_NAME);
                List sharedLibraries = systemStateSvc.getSharedLibraryStateHolders();
                Assert.assertEquals((long)1L, (long)sharedLibraries.size());
                SharedLibrary sharedLibrary = (SharedLibrary)sharedLibraries.get(0);
                Assert.assertEquals((Object)SL_NAME, (Object)sharedLibrary.getName());
                Assert.assertEquals((Object)SL_VERSION, (Object)sharedLibrary.getVersion());
                Assert.assertEquals((Object)ARCHIVE_NAME, (Object)sharedLibrary.getArchiveName());
                Assert.assertEquals((Object)slHomeDir1.toURI().toURL().toString(), (Object)sharedLibrary.getInstallURL());
            }
            catch (SharedLibraryAlreadyExistsException e) {
                Assert.fail((String)("Unexpected exception: " + ((Object)((Object)e)).getClass().getName()));
            }
            File slHomeDir2 = new File(repositoryHomeDir, SL_NAME);
            try {
                systemStateSvc.createSharedLibraryStateHolder(SL_NAME, SL_VERSION, slHomeDir2.toURI().toURL(), ARCHIVE_NAME);
                Assert.fail((String)("The exception " + SharedLibraryAlreadyExistsException.class.getName() + " is not raised."));
            }
            catch (SharedLibraryAlreadyExistsException e) {
                List sharedLibraries = systemStateSvc.getSharedLibraryStateHolders();
                Assert.assertEquals((long)1L, (long)sharedLibraries.size());
                SharedLibrary sharedLibrary = (SharedLibrary)sharedLibraries.get(0);
                Assert.assertEquals((Object)SL_NAME, (Object)sharedLibrary.getName());
                Assert.assertEquals((Object)SL_VERSION, (Object)sharedLibrary.getVersion());
                Assert.assertEquals((Object)ARCHIVE_NAME, (Object)sharedLibrary.getArchiveName());
                Assert.assertEquals((Object)slHomeDir2.toURI().toURL().toString(), (Object)sharedLibrary.getInstallURL());
            }
        }
        catch (MalformedURLException e) {
            Assert.fail((String)("Unexpected exception: " + e.getClass().getName()));
        }
        catch (SystemStateException e) {
            Assert.fail((String)("Unexpected exception: " + ((Object)((Object)e)).getClass().getName()));
        }
    }

    @Test
    public void testDeleteComponentStateHolder_000() throws Exception {
        File repositoryHomeDir = new File(this.targetDir, "testDeleteComponentStateHolder_000");
        repositoryHomeDir.mkdirs();
        File systemStateFile = new File(repositoryHomeDir, SYSTEMSTATE_FILE);
        if (systemStateFile.exists()) {
            Assert.assertTrue((boolean)systemStateFile.delete());
        }
        File componentHomeDir = new File(repositoryHomeDir, COMPONENT_NAME);
        SystemState systemState = new SystemState();
        Component component = new Component();
        component.setName(COMPONENT_NAME);
        component.setArchiveName(ARCHIVE_NAME);
        component.setInstallState("Uninstalled");
        component.setInstallURL(componentHomeDir.toURI().toURL().toString());
        component.setLifecycleState("Unknown");
        Object components = new Components();
        components.getComponent().add(component);
        systemState.setComponents((Components)components);
        systemState.setServiceAssemblies(new ServiceAssemblies());
        systemState.setSharedLibraries(new SharedLibraries());
        SystemStateBuilder.buildXmlFileSystemState((SystemState)systemState, (File)systemStateFile);
        Assert.assertTrue((boolean)systemStateFile.exists());
        SystemStateService systemStateSvc = this.createSystemStateService(repositoryHomeDir);
        try {
            component = systemStateSvc.deleteComponentStateHolder(COMPONENT_NAME);
            Assert.assertEquals((Object)COMPONENT_NAME, (Object)component.getName());
            Assert.assertEquals((Object)ARCHIVE_NAME, (Object)component.getArchiveName());
            Assert.assertEquals((Object)"Uninstalled", (Object)component.getInstallState());
            Assert.assertEquals((Object)componentHomeDir.toURI().toURL().toString(), (Object)component.getInstallURL());
            Assert.assertEquals((Object)"Unknown", (Object)component.getLifecycleState());
            components = systemStateSvc.getComponentStateHolders();
            Assert.assertEquals((long)0L, (long)components.size());
        }
        catch (SystemStateException e) {
            Assert.fail((String)("Unexpected exception: " + ((Object)((Object)e)).getClass().getName()));
        }
    }

    @Test
    public void testDeleteComponentStateHolder_001() throws Exception {
        File repositoryHomeDir = new File(this.targetDir, "testDeleteComponentStateHolder_001");
        repositoryHomeDir.mkdirs();
        File systemStateFile = new File(repositoryHomeDir, SYSTEMSTATE_FILE);
        if (systemStateFile.exists()) {
            Assert.assertTrue((boolean)systemStateFile.delete());
        }
        SystemState systemState = new SystemState();
        systemState.setComponents(new Components());
        systemState.setServiceAssemblies(new ServiceAssemblies());
        systemState.setSharedLibraries(new SharedLibraries());
        SystemStateBuilder.buildXmlFileSystemState((SystemState)systemState, (File)systemStateFile);
        Assert.assertTrue((boolean)systemStateFile.exists());
        SystemStateService systemStateSvc = this.createSystemStateService(repositoryHomeDir);
        try {
            Component component = systemStateSvc.deleteComponentStateHolder(COMPONENT_NAME);
            Assert.assertNull((Object)component);
        }
        catch (SystemStateException e) {
            Assert.fail((String)("Unexpected exception: " + ((Object)((Object)e)).getClass().getName()));
        }
    }

    @Test
    public void testDeleteServiceAssemblyStateHolder_000() throws Exception {
        File repositoryHomeDir = new File(this.targetDir, "testDeleteServiceAssemblyStateHolder_000");
        repositoryHomeDir.mkdirs();
        File systemStateFile = new File(repositoryHomeDir, SYSTEMSTATE_FILE);
        if (systemStateFile.exists()) {
            Assert.assertTrue((boolean)systemStateFile.delete());
        }
        File saHomeDir = new File(repositoryHomeDir, SA_NAME);
        SystemState systemState = new SystemState();
        ServiceAssembly serviceAssembly = new ServiceAssembly();
        serviceAssembly.setName(SA_NAME);
        serviceAssembly.setArchiveName(ARCHIVE_NAME);
        serviceAssembly.setInstallURL(saHomeDir.toURI().toURL().toString());
        serviceAssembly.setLifecycleState("Unknown");
        Object serviceAssemblies = new ServiceAssemblies();
        serviceAssemblies.getServiceAssembly().add(serviceAssembly);
        systemState.setComponents(new Components());
        systemState.setServiceAssemblies((ServiceAssemblies)serviceAssemblies);
        systemState.setSharedLibraries(new SharedLibraries());
        SystemStateBuilder.buildXmlFileSystemState((SystemState)systemState, (File)systemStateFile);
        Assert.assertTrue((boolean)systemStateFile.exists());
        SystemStateService systemStateSvc = this.createSystemStateService(repositoryHomeDir);
        try {
            serviceAssembly = systemStateSvc.deleteServiceAssemblyStateHolder(SA_NAME);
            Assert.assertEquals((Object)SA_NAME, (Object)serviceAssembly.getName());
            Assert.assertEquals((Object)ARCHIVE_NAME, (Object)serviceAssembly.getArchiveName());
            Assert.assertEquals((Object)saHomeDir.toURI().toURL().toString(), (Object)serviceAssembly.getInstallURL());
            Assert.assertEquals((Object)"Unknown", (Object)serviceAssembly.getLifecycleState());
            serviceAssemblies = systemStateSvc.getServiceAssemblyStateHolders();
            Assert.assertEquals((long)0L, (long)serviceAssemblies.size());
        }
        catch (SystemStateException e) {
            Assert.fail((String)("Unexpected exception: " + ((Object)((Object)e)).getClass().getName()));
        }
    }

    @Test
    public void testDeleteServiceAssemblyStateHolder_001() throws Exception {
        File repositoryHomeDir = new File(this.targetDir, "testDeleteServiceAssemblyStateHolder_001");
        repositoryHomeDir.mkdirs();
        File systemStateFile = new File(repositoryHomeDir, SYSTEMSTATE_FILE);
        if (systemStateFile.exists()) {
            Assert.assertTrue((boolean)systemStateFile.delete());
        }
        SystemState systemState = new SystemState();
        systemState.setComponents(new Components());
        systemState.setServiceAssemblies(new ServiceAssemblies());
        systemState.setSharedLibraries(new SharedLibraries());
        SystemStateBuilder.buildXmlFileSystemState((SystemState)systemState, (File)systemStateFile);
        Assert.assertTrue((boolean)systemStateFile.exists());
        SystemStateService systemStateSvc = this.createSystemStateService(repositoryHomeDir);
        try {
            ServiceAssembly serviceAssembly = systemStateSvc.deleteServiceAssemblyStateHolder(SA_NAME);
            Assert.assertNull((Object)serviceAssembly);
        }
        catch (SystemStateException e) {
            Assert.fail((String)("Unexpected exception: " + ((Object)((Object)e)).getClass().getName()));
        }
    }

    @Test
    public void testDeleteSharedLibraryStateHolder_000() throws Exception {
        File repositoryHomeDir = new File(this.targetDir, "testDeleteSharedLibraryStateHolder_000");
        repositoryHomeDir.mkdirs();
        File systemStateFile = new File(repositoryHomeDir, SYSTEMSTATE_FILE);
        if (systemStateFile.exists()) {
            Assert.assertTrue((boolean)systemStateFile.delete());
        }
        File slHomeDir = new File(repositoryHomeDir, SL_NAME);
        SystemState systemState = new SystemState();
        SharedLibrary sharedLibrary = new SharedLibrary();
        sharedLibrary.setName(SL_NAME);
        sharedLibrary.setVersion(SL_VERSION);
        sharedLibrary.setArchiveName(ARCHIVE_NAME);
        sharedLibrary.setInstallURL(slHomeDir.toURI().toURL().toString());
        Object sharedLibraries = new SharedLibraries();
        sharedLibraries.getSharedLibrary().add(sharedLibrary);
        systemState.setComponents(new Components());
        systemState.setServiceAssemblies(new ServiceAssemblies());
        systemState.setSharedLibraries((SharedLibraries)sharedLibraries);
        SystemStateBuilder.buildXmlFileSystemState((SystemState)systemState, (File)systemStateFile);
        Assert.assertTrue((boolean)systemStateFile.exists());
        SystemStateService systemStateSvc = this.createSystemStateService(repositoryHomeDir);
        try {
            sharedLibrary = systemStateSvc.deleteSharedLibraryStateHolder(SL_NAME, SL_VERSION);
            Assert.assertEquals((Object)SL_NAME, (Object)sharedLibrary.getName());
            Assert.assertEquals((Object)SL_VERSION, (Object)sharedLibrary.getVersion());
            Assert.assertEquals((Object)ARCHIVE_NAME, (Object)sharedLibrary.getArchiveName());
            Assert.assertEquals((Object)slHomeDir.toURI().toURL().toString(), (Object)sharedLibrary.getInstallURL());
            sharedLibraries = systemStateSvc.getSharedLibraryStateHolders();
            Assert.assertEquals((long)0L, (long)sharedLibraries.size());
        }
        catch (SystemStateException e) {
            Assert.fail((String)("Unexpected exception: " + ((Object)((Object)e)).getClass().getName()));
        }
    }

    @Test
    public void testDeleteSharedLibraryStateHolder_001() throws Exception {
        File repositoryHomeDir = new File(this.targetDir, "testDeleteSharedLibraryStateHolder_001");
        repositoryHomeDir.mkdirs();
        File systemStateFile = new File(repositoryHomeDir, SYSTEMSTATE_FILE);
        if (systemStateFile.exists()) {
            Assert.assertTrue((boolean)systemStateFile.delete());
        }
        SystemState systemState = new SystemState();
        systemState.setComponents(new Components());
        systemState.setServiceAssemblies(new ServiceAssemblies());
        systemState.setSharedLibraries(new SharedLibraries());
        SystemStateBuilder.buildXmlFileSystemState((SystemState)systemState, (File)systemStateFile);
        Assert.assertTrue((boolean)systemStateFile.exists());
        SystemStateService systemStateSvc = this.createSystemStateService(repositoryHomeDir);
        try {
            SharedLibrary sharedLibrary = systemStateSvc.deleteSharedLibraryStateHolder(SL_NAME, SL_VERSION);
            Assert.assertNull((Object)sharedLibrary);
        }
        catch (SystemStateException e) {
            Assert.fail((String)("Unexpected exception: " + ((Object)((Object)e)).getClass().getName()));
        }
    }
}

