/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.management.task.deployment.deploy;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.logging.Logger;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import org.ow2.petals.jbi.management.Context;
import org.ow2.petals.jbi.management.ManagementException;
import org.ow2.petals.jbi.management.task.deployment.deploy.CreateSARepositoryTask;
import org.ow2.petals.system.repository.RepositoryService;
import org.ow2.petals.system.repository.exception.ServiceAssemblyAlreadyExistsException;
import org.ow2.petals.util.AbstractMavenTest;
import org.ow2.petals.util.LoggingUtil;

public class CreateSARepositoryTaskTest
extends AbstractMavenTest {
    private static final String SA_NAME = "myServiceAssemblyName";
    private static final String ARCHIVE_FILE_NAME = "archive.zip";
    final LoggingUtil log = new LoggingUtil(Logger.getLogger(CreateSARepositoryTaskTest.class.getName()));

    @Test
    public void testCreateSARepositoryTask_000() throws Exception {
        RepositoryService repositorySvc = (RepositoryService)EasyMock.createMock(RepositoryService.class);
        EasyMock.expect((Object)repositorySvc.addServiceAssembly(SA_NAME, new File(this.testResourcesDir, ARCHIVE_FILE_NAME))).andReturn((Object)new File(this.targetDir, ARCHIVE_FILE_NAME));
        EasyMock.replay((Object[])new Object[]{repositorySvc});
        Context ctx = new Context();
        ctx.setEntityName(SA_NAME);
        ctx.setUnzipRoot(new File(this.testResourcesDir, ARCHIVE_FILE_NAME));
        CreateSARepositoryTask task = new CreateSARepositoryTask(this.log, repositorySvc);
        task.execute(ctx);
        TestCase.assertEquals((Object)new File(this.targetDir, ARCHIVE_FILE_NAME).toURI().toURL(), (Object)ctx.getInstallUrl());
        EasyMock.verify((Object[])new Object[]{repositorySvc});
    }

    @Test
    public void testCreateSARepositoryTask_001() throws Exception {
        RepositoryService repositorySvc = (RepositoryService)EasyMock.createMock(RepositoryService.class);
        EasyMock.expect((Object)repositorySvc.addServiceAssembly(SA_NAME, new File(this.testResourcesDir, ARCHIVE_FILE_NAME))).andReturn((Object)new File(this.targetDir, ARCHIVE_FILE_NAME));
        EasyMock.expect((Object)repositorySvc.addServiceAssembly(SA_NAME, new File(this.testResourcesDir, ARCHIVE_FILE_NAME))).andThrow((Throwable)new ServiceAssemblyAlreadyExistsException(SA_NAME, (Throwable)new Exception()));
        EasyMock.replay((Object[])new Object[]{repositorySvc});
        Context ctx1 = new Context();
        ctx1.setEntityName(SA_NAME);
        ctx1.setUnzipRoot(new File(this.testResourcesDir, ARCHIVE_FILE_NAME));
        CreateSARepositoryTask task1 = new CreateSARepositoryTask(this.log, repositorySvc);
        task1.execute(ctx1);
        TestCase.assertEquals((Object)new File(this.targetDir, ARCHIVE_FILE_NAME).toURI().toURL(), (Object)ctx1.getInstallUrl());
        try {
            Context ctx2 = new Context();
            ctx2.setEntityName(SA_NAME);
            ctx2.setUnzipRoot(new File(this.testResourcesDir, ARCHIVE_FILE_NAME));
            CreateSARepositoryTask task2 = new CreateSARepositoryTask(this.log, repositorySvc);
            task2.execute(ctx2);
            Assert.fail((String)("The exception " + ServiceAssemblyAlreadyExistsException.class.getName() + " is not raised."));
        }
        catch (ManagementException e) {
            TestCase.assertTrue((String)(ServiceAssemblyAlreadyExistsException.class.getName() + " is not the cause of ManagementException"), (boolean)(e.getCause() instanceof ServiceAssemblyAlreadyExistsException));
        }
        EasyMock.verify((Object[])new Object[]{repositorySvc});
    }

    @Test
    public void testCreateSARepositoryTask_002() throws Exception {
        RepositoryService repositorySvc = (RepositoryService)EasyMock.createMock(RepositoryService.class);
        EasyMock.expect((Object)repositorySvc.addServiceAssembly(SA_NAME, new File(this.testResourcesDir, ARCHIVE_FILE_NAME))).andReturn((Object)new File(this.targetDir, ARCHIVE_FILE_NAME));
        repositorySvc.removeServiceAssembly(SA_NAME);
        EasyMock.replay((Object[])new Object[]{repositorySvc});
        Context ctx = new Context();
        ctx.setEntityName(SA_NAME);
        ctx.setUnzipRoot(new File(this.testResourcesDir, ARCHIVE_FILE_NAME));
        CreateSARepositoryTask task = new CreateSARepositoryTask(this.log, repositorySvc);
        task.execute(ctx);
        TestCase.assertEquals((Object)new File(this.targetDir, ARCHIVE_FILE_NAME).toURI().toURL(), (Object)ctx.getInstallUrl());
        task.undo(ctx);
        EasyMock.verify((Object[])new Object[]{repositorySvc});
    }

    @Test
    public void testCreateSAStateHolderTask_003() throws Exception {
        RepositoryService repositorySvc = (RepositoryService)EasyMock.createMock(RepositoryService.class);
        repositorySvc.removeServiceAssembly(SA_NAME);
        EasyMock.expectLastCall().andThrow((Throwable)new FileNotFoundException());
        EasyMock.replay((Object[])new Object[]{repositorySvc});
        Context ctx = new Context();
        ctx.setEntityName(SA_NAME);
        ctx.setUnzipRoot(new File(this.testResourcesDir, ARCHIVE_FILE_NAME));
        CreateSARepositoryTask task = new CreateSARepositoryTask(this.log, repositorySvc);
        task.undo(ctx);
        EasyMock.verify((Object[])new Object[]{repositorySvc});
    }
}

