/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.management.task.deployment.deploy;

import java.io.File;
import java.util.logging.Logger;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.ow2.petals.jbi.management.Context;
import org.ow2.petals.jbi.management.task.deployment.deploy.CreateSAStateHolderTask;
import org.ow2.petals.system.systemstate.SystemStateService;
import org.ow2.petals.system.systemstate.exception.ServiceAssemblyAlreadyExistsException;
import org.ow2.petals.systemstate.generated.ServiceAssembly;
import org.ow2.petals.util.AbstractMavenTest;
import org.ow2.petals.util.LoggingUtil;

public class CreateSAStateHolderTaskTest
extends AbstractMavenTest {
    private static final String SA_NAME = "myServiceAssemblyName";
    private static final String ARCHIVE_FILE_NAME = "archive.zip";
    final LoggingUtil log = new LoggingUtil(Logger.getLogger(CreateSAStateHolderTaskTest.class.getName()));
    private String petalsHomeDir;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.petalsHomeDir = new File(this.targetDir, "petals-home").getAbsolutePath();
    }

    @Test
    public void testCreateSAStateHolderTask_000() throws Exception {
        SystemStateService systemStateSvc = (SystemStateService)EasyMock.createMock(SystemStateService.class);
        EasyMock.expect((Object)systemStateSvc.createServiceAssemblyStateHolder(SA_NAME, this.targetDir.toURI().toURL(), ARCHIVE_FILE_NAME)).andAnswer((IAnswer)new IAnswer<ServiceAssembly>(){

            public ServiceAssembly answer() throws Throwable {
                ServiceAssembly serviceAssembly = new ServiceAssembly();
                serviceAssembly.setName(CreateSAStateHolderTaskTest.SA_NAME);
                return serviceAssembly;
            }
        });
        EasyMock.replay((Object[])new Object[]{systemStateSvc});
        Context ctx = new Context();
        ctx.setEntityName(SA_NAME);
        ctx.setArchiveUrl(new File(this.targetDir, ARCHIVE_FILE_NAME).toURI().toURL());
        ctx.setInstallUrl(this.targetDir.toURI().toURL());
        CreateSAStateHolderTask task = new CreateSAStateHolderTask(this.log, systemStateSvc, this.petalsHomeDir);
        task.execute(ctx);
        EasyMock.verify((Object[])new Object[]{systemStateSvc});
    }

    @Test
    public void testCreateComponentStateHolderTask_001() throws Exception {
        SystemStateService systemStateSvc = (SystemStateService)EasyMock.createMock(SystemStateService.class);
        EasyMock.expect((Object)systemStateSvc.createServiceAssemblyStateHolder(SA_NAME, this.targetDir.toURI().toURL(), ARCHIVE_FILE_NAME)).andAnswer((IAnswer)new IAnswer<ServiceAssembly>(){

            public ServiceAssembly answer() throws Throwable {
                ServiceAssembly serviceAssembly = new ServiceAssembly();
                serviceAssembly.setName(CreateSAStateHolderTaskTest.SA_NAME);
                return serviceAssembly;
            }
        });
        EasyMock.expect((Object)systemStateSvc.createServiceAssemblyStateHolder(SA_NAME, this.targetDir.toURI().toURL(), ARCHIVE_FILE_NAME)).andThrow((Throwable)new ServiceAssemblyAlreadyExistsException(SA_NAME));
        EasyMock.replay((Object[])new Object[]{systemStateSvc});
        Context ctx1 = new Context();
        ctx1.setEntityName(SA_NAME);
        ctx1.setArchiveUrl(new File(this.targetDir, ARCHIVE_FILE_NAME).toURI().toURL());
        ctx1.setInstallUrl(this.targetDir.toURI().toURL());
        CreateSAStateHolderTask task1 = new CreateSAStateHolderTask(this.log, systemStateSvc, this.petalsHomeDir);
        task1.execute(ctx1);
        try {
            Context ctx2 = new Context();
            ctx2.setEntityName(SA_NAME);
            ctx2.setArchiveUrl(new File(this.targetDir, ARCHIVE_FILE_NAME).toURI().toURL());
            ctx2.setInstallUrl(this.targetDir.toURI().toURL());
            CreateSAStateHolderTask task2 = new CreateSAStateHolderTask(this.log, systemStateSvc, this.petalsHomeDir);
            task2.execute(ctx2);
            Assert.fail((String)("The exception " + ServiceAssemblyAlreadyExistsException.class.getName() + " is not raised."));
        }
        catch (ServiceAssemblyAlreadyExistsException serviceAssemblyAlreadyExistsException) {
            // empty catch block
        }
        EasyMock.verify((Object[])new Object[]{systemStateSvc});
    }

    @Test
    public void testCreateComponentStateHolderTask_002() throws Exception {
        SystemStateService systemStateSvc = (SystemStateService)EasyMock.createMock(SystemStateService.class);
        final ServiceAssembly serviceAssembly = new ServiceAssembly();
        serviceAssembly.setName(SA_NAME);
        EasyMock.expect((Object)systemStateSvc.createServiceAssemblyStateHolder(SA_NAME, this.targetDir.toURI().toURL(), ARCHIVE_FILE_NAME)).andAnswer((IAnswer)new IAnswer<ServiceAssembly>(){

            public ServiceAssembly answer() throws Throwable {
                return serviceAssembly;
            }
        });
        EasyMock.expect((Object)systemStateSvc.deleteServiceAssemblyStateHolder(SA_NAME)).andAnswer((IAnswer)new IAnswer<ServiceAssembly>(){

            public ServiceAssembly answer() throws Throwable {
                return serviceAssembly;
            }
        });
        EasyMock.replay((Object[])new Object[]{systemStateSvc});
        Context ctx = new Context();
        ctx.setEntityName(SA_NAME);
        ctx.setArchiveUrl(new File(this.targetDir, ARCHIVE_FILE_NAME).toURI().toURL());
        ctx.setInstallUrl(this.targetDir.toURI().toURL());
        CreateSAStateHolderTask task = new CreateSAStateHolderTask(this.log, systemStateSvc, this.petalsHomeDir);
        task.execute(ctx);
        task.undo(ctx);
        EasyMock.verify((Object[])new Object[]{systemStateSvc});
    }

    @Test
    public void testCreateComponentStateHolderTask_003() throws Exception {
        SystemStateService systemStateSvc = (SystemStateService)EasyMock.createMock(SystemStateService.class);
        EasyMock.expect((Object)systemStateSvc.deleteServiceAssemblyStateHolder(SA_NAME)).andAnswer((IAnswer)new IAnswer<ServiceAssembly>(){

            public ServiceAssembly answer() throws Throwable {
                ServiceAssembly serviceAssembly = new ServiceAssembly();
                serviceAssembly.setName(CreateSAStateHolderTaskTest.SA_NAME);
                return serviceAssembly;
            }
        });
        EasyMock.replay((Object[])new Object[]{systemStateSvc});
        Context ctx = new Context();
        ctx.setEntityName(SA_NAME);
        ctx.setArchiveUrl(new File(this.targetDir, ARCHIVE_FILE_NAME).toURI().toURL());
        ctx.setInstallUrl(this.targetDir.toURI().toURL());
        CreateSAStateHolderTask task = new CreateSAStateHolderTask(this.log, systemStateSvc, this.petalsHomeDir);
        task.undo(ctx);
        EasyMock.verify((Object[])new Object[]{systemStateSvc});
    }
}

