/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.management.task.installation.install.sl;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.logging.Logger;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import org.ow2.petals.jbi.management.Context;
import org.ow2.petals.jbi.management.ManagementException;
import org.ow2.petals.jbi.management.task.installation.install.sl.CreateSLRepositoryTask;
import org.ow2.petals.system.repository.RepositoryService;
import org.ow2.petals.system.repository.exception.SharedLibraryAlreadyExistsException;
import org.ow2.petals.util.AbstractMavenTest;
import org.ow2.petals.util.LoggingUtil;

public class CreateSLRepositoryTaskTest
extends AbstractMavenTest {
    private static final String SL_NAME = "mySLName";
    private static final String SL_VERSION = "1.0.0";
    private static final String ARCHIVE_FILE_NAME = "archive.zip";
    final LoggingUtil log = new LoggingUtil(Logger.getLogger(CreateSLRepositoryTaskTest.class.getName()));

    @Test
    public void testCreateSLRepositoryTask_000() throws Exception {
        RepositoryService repositorySvc = (RepositoryService)EasyMock.createMock(RepositoryService.class);
        EasyMock.expect((Object)repositorySvc.addSharedLibrary(SL_NAME, SL_VERSION, new File(this.testResourcesDir, ARCHIVE_FILE_NAME))).andReturn((Object)new File(this.targetDir, ARCHIVE_FILE_NAME));
        EasyMock.replay((Object[])new Object[]{repositorySvc});
        Context ctx = new Context();
        ctx.setEntityName(SL_NAME);
        ctx.setEntityVersion(SL_VERSION);
        ctx.setUnzipRoot(new File(this.testResourcesDir, ARCHIVE_FILE_NAME));
        CreateSLRepositoryTask task = new CreateSLRepositoryTask(this.log, repositorySvc);
        task.execute(ctx);
        Assert.assertEquals((Object)new File(this.targetDir, ARCHIVE_FILE_NAME).toURI().toURL(), (Object)ctx.getInstallUrl());
        EasyMock.verify((Object[])new Object[]{repositorySvc});
    }

    @Test
    public void testCreateSLRepositoryTask_001() throws Exception {
        RepositoryService repositorySvc = (RepositoryService)EasyMock.createMock(RepositoryService.class);
        EasyMock.expect((Object)repositorySvc.addSharedLibrary(SL_NAME, SL_VERSION, new File(this.testResourcesDir, ARCHIVE_FILE_NAME))).andReturn((Object)new File(this.targetDir, ARCHIVE_FILE_NAME));
        EasyMock.expect((Object)repositorySvc.addSharedLibrary(SL_NAME, SL_VERSION, new File(this.testResourcesDir, ARCHIVE_FILE_NAME))).andThrow((Throwable)new SharedLibraryAlreadyExistsException(SL_NAME, SL_VERSION, (Throwable)new Exception()));
        EasyMock.replay((Object[])new Object[]{repositorySvc});
        Context ctx1 = new Context();
        ctx1.setEntityName(SL_NAME);
        ctx1.setEntityVersion(SL_VERSION);
        ctx1.setUnzipRoot(new File(this.testResourcesDir, ARCHIVE_FILE_NAME));
        CreateSLRepositoryTask task1 = new CreateSLRepositoryTask(this.log, repositorySvc);
        task1.execute(ctx1);
        Assert.assertEquals((Object)new File(this.targetDir, ARCHIVE_FILE_NAME).toURI().toURL(), (Object)ctx1.getInstallUrl());
        try {
            Context ctx2 = new Context();
            ctx2.setEntityName(SL_NAME);
            ctx2.setEntityVersion(SL_VERSION);
            ctx2.setUnzipRoot(new File(this.testResourcesDir, ARCHIVE_FILE_NAME));
            CreateSLRepositoryTask task2 = new CreateSLRepositoryTask(this.log, repositorySvc);
            task2.execute(ctx2);
            Assert.fail((String)("The exception " + SharedLibraryAlreadyExistsException.class.getName() + " is not raised."));
        }
        catch (ManagementException e) {
            Assert.assertTrue((String)(SharedLibraryAlreadyExistsException.class.getName() + " is not the cause of ManagementException"), (boolean)(e.getCause() instanceof SharedLibraryAlreadyExistsException));
        }
        EasyMock.verify((Object[])new Object[]{repositorySvc});
    }

    @Test
    public void testCreateSLRepositoryTask_002() throws Exception {
        RepositoryService repositorySvc = (RepositoryService)EasyMock.createMock(RepositoryService.class);
        EasyMock.expect((Object)repositorySvc.addSharedLibrary(SL_NAME, SL_VERSION, new File(this.testResourcesDir, ARCHIVE_FILE_NAME))).andReturn((Object)new File(this.targetDir, ARCHIVE_FILE_NAME));
        repositorySvc.removeSharedLibrary(SL_NAME, SL_VERSION);
        EasyMock.replay((Object[])new Object[]{repositorySvc});
        Context ctx = new Context();
        ctx.setEntityName(SL_NAME);
        ctx.setEntityVersion(SL_VERSION);
        ctx.setUnzipRoot(new File(this.testResourcesDir, ARCHIVE_FILE_NAME));
        CreateSLRepositoryTask task = new CreateSLRepositoryTask(this.log, repositorySvc);
        task.execute(ctx);
        Assert.assertEquals((Object)new File(this.targetDir, ARCHIVE_FILE_NAME).toURI().toURL(), (Object)ctx.getInstallUrl());
        task.undo(ctx);
        EasyMock.verify((Object[])new Object[]{repositorySvc});
    }

    @Test
    public void testCreateSLRepositoryTask_003() throws Exception {
        RepositoryService repositorySvc = (RepositoryService)EasyMock.createMock(RepositoryService.class);
        repositorySvc.removeSharedLibrary(SL_NAME, SL_VERSION);
        EasyMock.expectLastCall().andThrow((Throwable)new FileNotFoundException());
        EasyMock.replay((Object[])new Object[]{repositorySvc});
        Context ctx = new Context();
        ctx.setEntityName(SL_NAME);
        ctx.setEntityVersion(SL_VERSION);
        ctx.setUnzipRoot(new File(this.testResourcesDir, ARCHIVE_FILE_NAME));
        CreateSLRepositoryTask task = new CreateSLRepositoryTask(this.log, repositorySvc);
        task.undo(ctx);
        EasyMock.verify((Object[])new Object[]{repositorySvc});
    }
}

