/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.management.task.installation.install.sl;

import java.util.logging.Logger;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.Test;
import org.ow2.petals.jbi.management.Context;
import org.ow2.petals.jbi.management.task.installation.uninstall.sl.RemoveSLStateHolderTask;
import org.ow2.petals.system.systemstate.SystemStateService;
import org.ow2.petals.systemstate.generated.SharedLibrary;
import org.ow2.petals.util.AbstractMavenTest;
import org.ow2.petals.util.LoggingUtil;

public class RemoveSLStateHolderTaskTest
extends AbstractMavenTest {
    private static final String SL_NAME = "mySharedLibraryName";
    private static final String SL_VERSION = "1.0.0";
    final LoggingUtil log = new LoggingUtil(Logger.getLogger(RemoveSLStateHolderTaskTest.class.getName()));

    @Test
    public void testRemoveSLStateHolderTask_000() throws Exception {
        SystemStateService systemStateSvc = (SystemStateService)EasyMock.createMock(SystemStateService.class);
        EasyMock.expect((Object)systemStateSvc.deleteSharedLibraryStateHolder(SL_NAME, SL_VERSION)).andAnswer((IAnswer)new IAnswer<SharedLibrary>(){

            public SharedLibrary answer() throws Throwable {
                SharedLibrary sharedLibrary = new SharedLibrary();
                sharedLibrary.setName(RemoveSLStateHolderTaskTest.SL_NAME);
                sharedLibrary.setVersion(RemoveSLStateHolderTaskTest.SL_VERSION);
                return sharedLibrary;
            }
        });
        EasyMock.replay((Object[])new Object[]{systemStateSvc});
        Context ctx = new Context();
        ctx.setEntityName(SL_NAME);
        ctx.setEntityVersion(SL_VERSION);
        RemoveSLStateHolderTask task = new RemoveSLStateHolderTask(this.log, systemStateSvc);
        task.execute(ctx);
        TestCase.assertEquals((String)SL_NAME, (String)ctx.getSharedLibraryStateHolder().getName());
        TestCase.assertEquals((String)SL_VERSION, (String)ctx.getSharedLibraryStateHolder().getVersion());
        EasyMock.verify((Object[])new Object[]{systemStateSvc});
    }

    @Test
    public void testRemoveSLStateHolderTask_001() throws Exception {
        SystemStateService systemStateSvc = (SystemStateService)EasyMock.createMock(SystemStateService.class);
        EasyMock.expect((Object)systemStateSvc.deleteSharedLibraryStateHolder(SL_NAME, SL_VERSION)).andAnswer((IAnswer)new IAnswer<SharedLibrary>(){

            public SharedLibrary answer() throws Throwable {
                SharedLibrary sharedLibrary = new SharedLibrary();
                sharedLibrary.setName(RemoveSLStateHolderTaskTest.SL_NAME);
                sharedLibrary.setVersion(RemoveSLStateHolderTaskTest.SL_VERSION);
                return sharedLibrary;
            }
        });
        EasyMock.expect((Object)systemStateSvc.deleteSharedLibraryStateHolder(SL_NAME, SL_VERSION)).andReturn(null);
        EasyMock.replay((Object[])new Object[]{systemStateSvc});
        Context ctx1 = new Context();
        ctx1.setEntityName(SL_NAME);
        ctx1.setEntityVersion(SL_VERSION);
        RemoveSLStateHolderTask task1 = new RemoveSLStateHolderTask(this.log, systemStateSvc);
        task1.execute(ctx1);
        TestCase.assertEquals((String)SL_NAME, (String)ctx1.getSharedLibraryStateHolder().getName());
        TestCase.assertEquals((String)SL_VERSION, (String)ctx1.getSharedLibraryStateHolder().getVersion());
        Context ctx2 = new Context();
        ctx2.setEntityName(SL_NAME);
        ctx2.setEntityVersion(SL_VERSION);
        RemoveSLStateHolderTask task2 = new RemoveSLStateHolderTask(this.log, systemStateSvc);
        task2.execute(ctx2);
        TestCase.assertNull((String)"Returned shared library state holder not null", (Object)ctx2.getSharedLibraryStateHolder());
        EasyMock.verify((Object[])new Object[]{systemStateSvc});
    }
}

