/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.messaging.exchange;

import com.ebmwebsourcing.easycommons.thread.ExecutionContext;
import java.net.URI;
import java.util.logging.Logger;
import javax.jbi.messaging.FlowAttributes;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOptionalOut;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.RobustInOnly;
import javax.xml.namespace.QName;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfOperation;
import org.ow2.petals.commons.PetalsExecutionContext;
import org.ow2.petals.jbi.messaging.endpoint.ServiceEndpoint;
import org.ow2.petals.jbi.messaging.exchange.MessageExchangeCheckHelper;
import org.ow2.petals.jbi.messaging.exchange.MessageExchangeImpl;
import org.ow2.petals.jbi.messaging.exchange.MessageExchangeWrapper;
import org.ow2.petals.jbi.messaging.exchange.PersistedContextualMessageExchangeFactoryImpl;

public class PersistedContextualMessageExchangeFactoryImplTest
extends MessageExchangeCheckHelper {
    protected final ServiceEndpoint consumerEndpointMock = (ServiceEndpoint)Mockito.mock(ServiceEndpoint.class);
    protected final Logger logger = Logger.getLogger("testLogger");
    protected MessageExchangeFactory messageExchangeFactory;

    protected MessageExchangeFactory createTestMessageExchangeFactory() {
        return PersistedContextualMessageExchangeFactoryImpl.createContextualMessageExchangeFactory((javax.jbi.servicedesc.ServiceEndpoint)this.consumerEndpointMock, (Logger)this.logger);
    }

    @Before
    public final void before() {
        this.messageExchangeFactory = this.createTestMessageExchangeFactory();
        PetalsExecutionContext.putFlowAttributes((FlowAttributes)new FlowAttributes("flowInstanceId", "flowStepId"));
    }

    @After
    public final void after() {
        ExecutionContext.getProperties().clear();
    }

    @Test
    public void testCreateExchangeFromServAndOp() throws MessagingException {
        QName serviceName = new QName("targetService");
        QName opName = new QName("targetOperation");
        MessageExchange actualMessageExchange = this.messageExchangeFactory.createExchange(serviceName, opName);
        this.assertGeneratedExchangeIsAMessageExchangeDecorator(actualMessageExchange);
        this.assertExchangeIdIsPetalsUUID(actualMessageExchange);
        this.assertGeneratedExchangeUseProvidedServiceAndOp(actualMessageExchange, serviceName, opName);
    }

    @Test
    public void testCreateExchangeFromLegacyInOnlyPattern() throws MessagingException {
        URI pattern = MessageExchangeImpl.IN_ONLY_PATTERN;
        MessageExchange actualMessageExchange = this.messageExchangeFactory.createExchange(pattern);
        this.assertGeneratedExchangeIsAMessageExchangeDecorator(actualMessageExchange);
        this.assertGeneratedExchangeIsInOnly(actualMessageExchange);
        this.assertExchangeIdIsPetalsUUID(actualMessageExchange);
    }

    @Test
    public void testCreateExchangeFromNewInOnlyPattern() throws MessagingException {
        URI pattern = AbsItfOperation.MEPPatternConstants.IN_ONLY.value();
        MessageExchange actualMessageExchange = this.messageExchangeFactory.createExchange(pattern);
        this.assertGeneratedExchangeIsAMessageExchangeDecorator(actualMessageExchange);
        this.assertGeneratedExchangeIsInOnly(actualMessageExchange);
        this.assertExchangeIdIsPetalsUUID(actualMessageExchange);
    }

    @Test
    public void testCreateExchangeFromLegacyRobustInOnlyPattern() throws MessagingException {
        URI pattern = MessageExchangeImpl.ROBUST_IN_ONLY_PATTERN;
        MessageExchange actualMessageExchange = this.messageExchangeFactory.createExchange(pattern);
        this.assertGeneratedExchangeIsAMessageExchangeDecorator(actualMessageExchange);
        this.assertGeneratedExchangeIsRobustInOnly(actualMessageExchange);
        this.assertExchangeIdIsPetalsUUID(actualMessageExchange);
    }

    @Test
    public void testCreateExchangeFromNewRobustInOnlyPattern() throws MessagingException {
        URI pattern = AbsItfOperation.MEPPatternConstants.ROBUST_IN_ONLY.value();
        MessageExchange actualMessageExchange = this.messageExchangeFactory.createExchange(pattern);
        this.assertGeneratedExchangeIsAMessageExchangeDecorator(actualMessageExchange);
        this.assertGeneratedExchangeIsRobustInOnly(actualMessageExchange);
        this.assertExchangeIdIsPetalsUUID(actualMessageExchange);
    }

    @Test
    public void testCreateExchangeFromLegacyInOptOutPattern() throws MessagingException {
        URI pattern = MessageExchangeImpl.IN_OPTIONAL_OUT_PATTERN;
        MessageExchange actualMessageExchange = this.messageExchangeFactory.createExchange(pattern);
        this.assertGeneratedExchangeIsAMessageExchangeDecorator(actualMessageExchange);
        this.assertGeneratedExchangeIsInOptOut(actualMessageExchange);
        this.assertExchangeIdIsPetalsUUID(actualMessageExchange);
    }

    @Test
    public void testCreateExchangeFromNewInOptOutPattern() throws MessagingException {
        URI pattern = AbsItfOperation.MEPPatternConstants.IN_OPTIONAL_OUT.value();
        MessageExchange actualMessageExchange = this.messageExchangeFactory.createExchange(pattern);
        this.assertGeneratedExchangeIsAMessageExchangeDecorator(actualMessageExchange);
        this.assertGeneratedExchangeIsInOptOut(actualMessageExchange);
        this.assertExchangeIdIsPetalsUUID(actualMessageExchange);
    }

    @Test
    public void testCreateExchangeFromLegacyInOutPattern() throws MessagingException {
        URI pattern = MessageExchangeImpl.IN_OUT_PATTERN;
        MessageExchange actualMessageExchange = this.messageExchangeFactory.createExchange(pattern);
        this.assertGeneratedExchangeIsAMessageExchangeDecorator(actualMessageExchange);
        this.assertGeneratedExchangeIsInOut(actualMessageExchange);
        this.assertExchangeIdIsPetalsUUID(actualMessageExchange);
    }

    @Test
    public void testCreateExchangeFromNewInOutPattern() throws MessagingException {
        URI pattern = AbsItfOperation.MEPPatternConstants.IN_OUT.value();
        MessageExchange actualMessageExchange = this.messageExchangeFactory.createExchange(pattern);
        this.assertGeneratedExchangeIsAMessageExchangeDecorator(actualMessageExchange);
        this.assertGeneratedExchangeIsInOut(actualMessageExchange);
        this.assertExchangeIdIsPetalsUUID(actualMessageExchange);
    }

    @Test
    public void testCreateExchangeFromNonJBIPattern() {
        URI pattern = URI.create("http://non/jbi/pattern");
        try {
            this.messageExchangeFactory.createExchange(pattern);
            Assert.fail((String)"A MessagingException must be thrown");
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
    }

    @Test
    public void testCreateInOnlyExchange() throws MessagingException {
        InOnly actualMessageExchange = this.messageExchangeFactory.createInOnlyExchange();
        this.assertGeneratedExchangeIsAMessageExchangeDecorator((MessageExchange)actualMessageExchange);
        this.assertGeneratedExchangeIsInOnly((MessageExchange)actualMessageExchange);
        this.assertExchangeIdIsPetalsUUID((MessageExchange)actualMessageExchange);
    }

    @Test
    public void testCreateInOptionalOutExchange() throws MessagingException {
        InOptionalOut actualMessageExchange = this.messageExchangeFactory.createInOptionalOutExchange();
        this.assertGeneratedExchangeIsAMessageExchangeDecorator((MessageExchange)actualMessageExchange);
        this.assertGeneratedExchangeIsInOptOut((MessageExchange)actualMessageExchange);
        this.assertExchangeIdIsPetalsUUID((MessageExchange)actualMessageExchange);
    }

    @Test
    public void testCreateInOutExchange() throws MessagingException {
        InOut actualMessageExchange = this.messageExchangeFactory.createInOutExchange();
        this.assertGeneratedExchangeIsAMessageExchangeDecorator((MessageExchange)actualMessageExchange);
        this.assertGeneratedExchangeIsInOut((MessageExchange)actualMessageExchange);
        this.assertExchangeIdIsPetalsUUID((MessageExchange)actualMessageExchange);
    }

    @Test
    public void testCreateRobustInOnlyExchange() throws MessagingException {
        RobustInOnly actualMessageExchange = this.messageExchangeFactory.createRobustInOnlyExchange();
        this.assertGeneratedExchangeIsAMessageExchangeDecorator((MessageExchange)actualMessageExchange);
        this.assertGeneratedExchangeIsRobustInOnly((MessageExchange)actualMessageExchange);
        this.assertExchangeIdIsPetalsUUID((MessageExchange)actualMessageExchange);
    }

    @Test
    public void testCreateInOnlyExchangeWithContextualFlowInstanceId() throws MessagingException {
        InOnly actualMessageExchange = this.messageExchangeFactory.createInOnlyExchange();
        this.assertGeneratedExchangeIsAMessageExchangeDecorator((MessageExchange)actualMessageExchange);
        this.assertGeneratedExchangeIsInOnly((MessageExchange)actualMessageExchange);
        this.assertIdIsPetalsQualifiedUUID(actualMessageExchange.getExchangeId());
    }

    @Test
    public void testCreateInOptionalOutExchangeWithContextualFlowInstanceId() throws MessagingException {
        InOptionalOut actualMessageExchange = this.messageExchangeFactory.createInOptionalOutExchange();
        this.assertGeneratedExchangeIsAMessageExchangeDecorator((MessageExchange)actualMessageExchange);
        this.assertGeneratedExchangeIsInOptOut((MessageExchange)actualMessageExchange);
        this.assertIdIsPetalsQualifiedUUID(actualMessageExchange.getExchangeId());
    }

    @Test
    public void testCreateInOutExchangeWithContextualFlowInstanceId() throws MessagingException {
        InOut actualMessageExchange = this.messageExchangeFactory.createInOutExchange();
        this.assertGeneratedExchangeIsAMessageExchangeDecorator((MessageExchange)actualMessageExchange);
        this.assertGeneratedExchangeIsInOut((MessageExchange)actualMessageExchange);
        this.assertIdIsPetalsQualifiedUUID(actualMessageExchange.getExchangeId());
    }

    @Test
    public void testCreateRobustInOnlyExchangeWithContextualFlowInstanceId() throws MessagingException {
        RobustInOnly actualMessageExchange = this.messageExchangeFactory.createRobustInOnlyExchange();
        this.assertGeneratedExchangeIsAMessageExchangeDecorator((MessageExchange)actualMessageExchange);
        this.assertGeneratedExchangeIsRobustInOnly((MessageExchange)actualMessageExchange);
        this.assertIdIsPetalsQualifiedUUID(actualMessageExchange.getExchangeId());
    }

    @Test
    public void testCreateInOnlyExchangeWithContextualNullFlowInstanceId() throws MessagingException {
        InOnly actualMessageExchange = this.messageExchangeFactory.createInOnlyExchange();
        this.assertGeneratedExchangeIsAMessageExchangeDecorator((MessageExchange)actualMessageExchange);
        this.assertGeneratedExchangeIsInOnly((MessageExchange)actualMessageExchange);
        this.assertExchangeIdIsPetalsUUID((MessageExchange)actualMessageExchange);
    }

    @Test
    public void testCreateInOptionalOutExchangeWithContextualNullFlowInstanceId() throws MessagingException {
        InOptionalOut actualMessageExchange = this.messageExchangeFactory.createInOptionalOutExchange();
        this.assertGeneratedExchangeIsAMessageExchangeDecorator((MessageExchange)actualMessageExchange);
        this.assertGeneratedExchangeIsInOptOut((MessageExchange)actualMessageExchange);
        this.assertExchangeIdIsPetalsUUID((MessageExchange)actualMessageExchange);
    }

    @Test
    public void testCreateInOutExchangeWithContextualNullFlowInstanceId() throws MessagingException {
        InOut actualMessageExchange = this.messageExchangeFactory.createInOutExchange();
        this.assertGeneratedExchangeIsAMessageExchangeDecorator((MessageExchange)actualMessageExchange);
        this.assertGeneratedExchangeIsInOut((MessageExchange)actualMessageExchange);
        this.assertExchangeIdIsPetalsUUID((MessageExchange)actualMessageExchange);
    }

    @Test
    public void testCreateRobustInOnlyExchangeWithContextualNullFlowInstanceId() throws MessagingException {
        RobustInOnly actualMessageExchange = this.messageExchangeFactory.createRobustInOnlyExchange();
        this.assertGeneratedExchangeIsAMessageExchangeDecorator((MessageExchange)actualMessageExchange);
        this.assertGeneratedExchangeIsRobustInOnly((MessageExchange)actualMessageExchange);
        this.assertExchangeIdIsPetalsUUID((MessageExchange)actualMessageExchange);
    }

    @Test
    public void testCreateExchangeFromServiceAndOpAndContextualFlowInstanceId() throws MessagingException {
        QName serviceName = new QName("targetService");
        QName opName = new QName("targetOperation");
        MessageExchange actualMessageExchange = this.messageExchangeFactory.createExchange(serviceName, opName);
        this.assertGeneratedExchangeIsAMessageExchangeDecorator(actualMessageExchange);
        this.assertIdIsPetalsQualifiedUUID(actualMessageExchange.getExchangeId());
        this.assertGeneratedExchangeUseProvidedServiceAndOp(actualMessageExchange, serviceName, opName);
    }

    @Test
    public void testCreateExchangeFromServiceAndOpAndNullContextualFlowInstanceId() throws MessagingException {
        QName serviceName = new QName("targetService");
        QName opName = new QName("targetOperation");
        MessageExchange actualMessageExchange = this.messageExchangeFactory.createExchange(serviceName, opName);
        this.assertGeneratedExchangeIsAMessageExchangeDecorator(actualMessageExchange);
        this.assertExchangeIdIsPetalsUUID(actualMessageExchange);
        this.assertGeneratedExchangeUseProvidedServiceAndOp(actualMessageExchange, serviceName, opName);
    }

    @Test
    public void testCreateExchangeFromLegacyInOnlyPatternAndContextualFlowInstanceId() throws MessagingException {
        URI pattern = MessageExchangeImpl.IN_ONLY_PATTERN;
        MessageExchange actualMessageExchange = this.messageExchangeFactory.createExchange(pattern);
        this.assertGeneratedExchangeIsAMessageExchangeDecorator(actualMessageExchange);
        this.assertGeneratedExchangeIsInOnly(actualMessageExchange);
        this.assertIdIsPetalsQualifiedUUID(actualMessageExchange.getExchangeId());
    }

    @Test
    public void testCreateExchangeFromNewInOnlyPatternAndContextualFlowInstanceId() throws MessagingException {
        URI pattern = AbsItfOperation.MEPPatternConstants.IN_ONLY.value();
        MessageExchange actualMessageExchange = this.messageExchangeFactory.createExchange(pattern);
        this.assertGeneratedExchangeIsAMessageExchangeDecorator(actualMessageExchange);
        this.assertGeneratedExchangeIsInOnly(actualMessageExchange);
        this.assertIdIsPetalsQualifiedUUID(actualMessageExchange.getExchangeId());
    }

    @Test
    public void testCreateExchangeFromNewInOnlyPatternAndNullContextualFlowInstanceId() throws MessagingException {
        URI pattern = AbsItfOperation.MEPPatternConstants.IN_ONLY.value();
        MessageExchange actualMessageExchange = this.messageExchangeFactory.createExchange(pattern);
        this.assertGeneratedExchangeIsAMessageExchangeDecorator(actualMessageExchange);
        this.assertGeneratedExchangeIsInOnly(actualMessageExchange);
        this.assertExchangeIdIsPetalsUUID(actualMessageExchange);
    }

    @Test
    public void testCreateExchangeFromLegacyRobustInOnlyPatternAndContextualFlowInstanceId() throws MessagingException {
        URI pattern = MessageExchangeImpl.ROBUST_IN_ONLY_PATTERN;
        MessageExchange actualMessageExchange = this.messageExchangeFactory.createExchange(pattern);
        this.assertGeneratedExchangeIsAMessageExchangeDecorator(actualMessageExchange);
        this.assertGeneratedExchangeIsRobustInOnly(actualMessageExchange);
        this.assertIdIsPetalsQualifiedUUID(actualMessageExchange.getExchangeId());
    }

    @Test
    public void testCreateExchangeFromNewRobustInOnlyPatternAndContextualFlowInstanceId() throws MessagingException {
        URI pattern = AbsItfOperation.MEPPatternConstants.ROBUST_IN_ONLY.value();
        MessageExchange actualMessageExchange = this.messageExchangeFactory.createExchange(pattern);
        this.assertGeneratedExchangeIsAMessageExchangeDecorator(actualMessageExchange);
        this.assertGeneratedExchangeIsRobustInOnly(actualMessageExchange);
        this.assertIdIsPetalsQualifiedUUID(actualMessageExchange.getExchangeId());
    }

    @Test
    public void testCreateExchangeFromNewRobustInOnlyPatternAndNullContextualFlowInstanceId() throws MessagingException {
        URI pattern = AbsItfOperation.MEPPatternConstants.ROBUST_IN_ONLY.value();
        MessageExchange actualMessageExchange = this.messageExchangeFactory.createExchange(pattern);
        this.assertGeneratedExchangeIsAMessageExchangeDecorator(actualMessageExchange);
        this.assertGeneratedExchangeIsRobustInOnly(actualMessageExchange);
        this.assertExchangeIdIsPetalsUUID(actualMessageExchange);
    }

    @Test
    public void testCreateExchangeFromLegacyInOptOutPatternAndContextualFlowInstanceId() throws MessagingException {
        URI pattern = MessageExchangeImpl.IN_OPTIONAL_OUT_PATTERN;
        MessageExchange actualMessageExchange = this.messageExchangeFactory.createExchange(pattern);
        this.assertGeneratedExchangeIsAMessageExchangeDecorator(actualMessageExchange);
        this.assertGeneratedExchangeIsInOptOut(actualMessageExchange);
        this.assertIdIsPetalsQualifiedUUID(actualMessageExchange.getExchangeId());
    }

    @Test
    public void testCreateExchangeFromNewInOptOutPatternAndContextualFlowInstanceId() throws MessagingException {
        URI pattern = AbsItfOperation.MEPPatternConstants.IN_OPTIONAL_OUT.value();
        MessageExchange actualMessageExchange = this.messageExchangeFactory.createExchange(pattern);
        this.assertGeneratedExchangeIsAMessageExchangeDecorator(actualMessageExchange);
        this.assertGeneratedExchangeIsInOptOut(actualMessageExchange);
        this.assertIdIsPetalsQualifiedUUID(actualMessageExchange.getExchangeId());
    }

    @Test
    public void testCreateExchangeFromNewInOptOutPatternAndNullContextualFlowInstanceId() throws MessagingException {
        URI pattern = AbsItfOperation.MEPPatternConstants.IN_OPTIONAL_OUT.value();
        MessageExchange actualMessageExchange = this.messageExchangeFactory.createExchange(pattern);
        this.assertGeneratedExchangeIsAMessageExchangeDecorator(actualMessageExchange);
        this.assertGeneratedExchangeIsInOptOut(actualMessageExchange);
        this.assertExchangeIdIsPetalsUUID(actualMessageExchange);
    }

    @Test
    public void testCreateExchangeFromLegacyInOutPatternAndContextualFlowInstanceId() throws MessagingException {
        URI pattern = MessageExchangeImpl.IN_OUT_PATTERN;
        MessageExchange actualMessageExchange = this.messageExchangeFactory.createExchange(pattern);
        this.assertGeneratedExchangeIsAMessageExchangeDecorator(actualMessageExchange);
        this.assertGeneratedExchangeIsInOut(actualMessageExchange);
        this.assertIdIsPetalsQualifiedUUID(actualMessageExchange.getExchangeId());
    }

    @Test
    public void testCreateExchangeFromNewInOutPatternAndContextualFlowInstanceId() throws MessagingException {
        URI pattern = AbsItfOperation.MEPPatternConstants.IN_OUT.value();
        MessageExchange actualMessageExchange = this.messageExchangeFactory.createExchange(pattern);
        this.assertGeneratedExchangeIsAMessageExchangeDecorator(actualMessageExchange);
        this.assertGeneratedExchangeIsInOut(actualMessageExchange);
        this.assertIdIsPetalsQualifiedUUID(actualMessageExchange.getExchangeId());
    }

    @Test
    public void testCreateExchangeFromNewInOutPatternAndNullContextualFlowInstanceId() throws MessagingException {
        URI pattern = AbsItfOperation.MEPPatternConstants.IN_OUT.value();
        MessageExchange actualMessageExchange = this.messageExchangeFactory.createExchange(pattern);
        this.assertGeneratedExchangeIsAMessageExchangeDecorator(actualMessageExchange);
        this.assertGeneratedExchangeIsInOut(actualMessageExchange);
        this.assertExchangeIdIsPetalsUUID(actualMessageExchange);
    }

    @Test
    public void testCreateExchangeFromNonJBIPatternAndContextualFlowInstanceId() {
        URI pattern = URI.create("http://non/jbi/pattern");
        try {
            this.messageExchangeFactory.createExchange(pattern);
            Assert.fail((String)"A MessagingException must be thrown");
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
    }

    private void assertGeneratedExchangeIsAMessageExchangeDecorator(MessageExchange actualMessageExchange) {
        Assert.assertTrue((String)"Returned message exchange isn't a MessageExchangeDecorator", (boolean)(actualMessageExchange instanceof MessageExchangeWrapper));
    }

    private void assertExchangeIdIsPetalsUUID(MessageExchange actualMessageExchange) {
        this.assertIdIsPetalsQualifiedUUID(actualMessageExchange.getExchangeId());
    }

    private void assertGeneratedExchangeUseProvidedServiceAndOp(MessageExchange actualMessageExchange, QName serviceName, QName opName) {
        Assert.assertEquals((String)"Bad service on created exchange", (Object)serviceName, (Object)actualMessageExchange.getService());
        Assert.assertEquals((String)"Bad operation on created exchange", (Object)opName, (Object)actualMessageExchange.getOperation());
    }

    private void assertGeneratedExchangeIsInOnly(MessageExchange actualMessageExchange) {
        Assert.assertTrue((String)("Bad pattern on created exchange expected 'InOnly' was '" + actualMessageExchange.getClass().getName() + "'"), (boolean)(actualMessageExchange instanceof InOnly));
    }

    private void assertGeneratedExchangeIsRobustInOnly(MessageExchange actualMessageExchange) {
        Assert.assertTrue((String)("Bad pattern on created exchange expected 'RobustInOnly' was '" + actualMessageExchange.getClass().getName() + "'"), (boolean)(actualMessageExchange instanceof RobustInOnly));
    }

    private void assertGeneratedExchangeIsInOptOut(MessageExchange actualMessageExchange) {
        Assert.assertTrue((String)("Bad pattern on created exchange expected 'InOptOut' was '" + actualMessageExchange.getClass().getName() + "'"), (boolean)(actualMessageExchange instanceof InOptionalOut));
    }

    private void assertGeneratedExchangeIsInOut(MessageExchange actualMessageExchange) {
        Assert.assertTrue((String)("Bad pattern on created exchange expected 'InOut' was '" + actualMessageExchange.getClass().getName() + "'"), (boolean)(actualMessageExchange instanceof InOut));
    }
}

