/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.messaging.exchange;

import java.net.URI;
import java.util.logging.Logger;
import javax.jbi.messaging.InOnly;
import javax.jbi.messaging.InOptionalOut;
import javax.jbi.messaging.InOut;
import javax.jbi.messaging.MessageExchange;
import javax.jbi.messaging.MessageExchangeFactory;
import javax.jbi.messaging.MessagingException;
import javax.jbi.messaging.RobustInOnly;
import javax.jbi.servicedesc.ServiceEndpoint;
import javax.xml.namespace.QName;
import org.junit.Assert;
import org.junit.Test;
import org.ow2.easywsdl.wsdl.api.abstractItf.AbsItfOperation;
import org.ow2.petals.jbi.messaging.exchange.PersistedContextualMessageExchangeFactoryImpl;
import org.ow2.petals.jbi.messaging.exchange.PersistedContextualMessageExchangeFactoryImplTest;

public class PersistedMessageExchangeFactoryForServiceImplTest
extends PersistedContextualMessageExchangeFactoryImplTest {
    private QName targetService = new QName("targetService");

    @Override
    protected MessageExchangeFactory createTestMessageExchangeFactory() {
        return PersistedContextualMessageExchangeFactoryImpl.createContextualMessageExchangeFactoryForService((ServiceEndpoint)this.consumerEndpointMock, (Logger)this.logger, (QName)this.targetService);
    }

    @Test
    public void testCreateExchangeFromServAndOpUseFactorySpecificTargetService() throws MessagingException {
        QName serviceName = new QName("targetService");
        QName opName = new QName("targetOperation");
        MessageExchange actualMessageExchange = this.messageExchangeFactory.createExchange(serviceName, opName);
        this.assertGeneratedExchangeUseFactorySpecificTargetService(actualMessageExchange);
    }

    @Test
    public void testCreateExchangeFromJBIPatternUseFactorySpecificTargetService() throws MessagingException {
        URI pattern = AbsItfOperation.MEPPatternConstants.IN_ONLY.value();
        MessageExchange actualMessageExchange = this.messageExchangeFactory.createExchange(pattern);
        this.assertGeneratedExchangeUseFactorySpecificTargetService(actualMessageExchange);
    }

    @Test
    public void testCreateInOnlyExchangeUseFactorySpecificTargetService() throws MessagingException {
        InOnly actualMessageExchange = this.messageExchangeFactory.createInOnlyExchange();
        this.assertGeneratedExchangeUseFactorySpecificTargetService((MessageExchange)actualMessageExchange);
    }

    @Test
    public void testCreateInOptionalOutExchangeUseFactorySpecificTargetService() throws MessagingException {
        InOptionalOut actualMessageExchange = this.messageExchangeFactory.createInOptionalOutExchange();
        this.assertGeneratedExchangeUseFactorySpecificTargetService((MessageExchange)actualMessageExchange);
    }

    @Test
    public void testCreateInOutExchangeUseFactorySpecificTargetService() throws MessagingException {
        InOut actualMessageExchange = this.messageExchangeFactory.createInOutExchange();
        this.assertGeneratedExchangeUseFactorySpecificTargetService((MessageExchange)actualMessageExchange);
    }

    @Test
    public void testCreateRobustInOnlyExchangeUseFactorySpecificTargetService() throws MessagingException {
        RobustInOnly actualMessageExchange = this.messageExchangeFactory.createRobustInOnlyExchange();
        this.assertGeneratedExchangeUseFactorySpecificTargetService((MessageExchange)actualMessageExchange);
    }

    private void assertGeneratedExchangeUseFactorySpecificTargetService(MessageExchange actualMessageExchange) {
        Assert.assertEquals((String)"Returned exchange must target factory specific service", (Object)this.targetService, (Object)actualMessageExchange.getService());
    }
}

