/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.system.classloader.factory;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.ow2.petals.system.classloader.factory.JarURLFactory;

public class JarURLFactoryTest {
    private String baseDir;

    @Before
    public void setUp() {
        this.baseDir = this.getClass().getResource(".").toString();
        this.baseDir = this.baseDir.substring(0, this.baseDir.indexOf("target"));
        this.baseDir = this.baseDir.substring(this.baseDir.indexOf(":") + 1);
    }

    @Test
    public void testGetURL() throws IOException {
        JarURLFactory factory = new JarURLFactory(new URL("file:" + this.baseDir.replace(File.separator, "/") + "src/test/resources/petals-core-test.jar"));
        URL url = factory.getURL("META-INF/MANIFEST.MF");
        Assert.assertEquals((Object)url, (Object)new URL("jar:file:" + this.baseDir.replace(File.separator, "/") + "src/test/resources/petals-core-test.jar!/META-INF/MANIFEST.MF"));
    }

    @Test
    public void testGetURLException() throws IOException {
        URL url = new URL("file:" + this.baseDir.replace(File.separator, "/") + "src/test/resources/petals-core-test.jar");
        JarURLFactory factory = new JarURLFactory(url);
        Assert.assertEquals((Object)url, (Object)factory.getURL(""));
    }
}

