/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.container.thread;

import javax.jbi.JBIException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.ow2.petals.container.thread.AbstractThread;

public class AbstractThreadTest {
    protected AbstractThread threadTest;

    @Test
    public void testSubmissionFailure() {
        try {
            this.threadTest.execute("TASK");
            Assert.fail();
        }
        catch (JBIException jBIException) {
            // empty catch block
        }
    }

    @Test
    public void testMultipleConsumers() {
        int loopA = 10;
        long sleepA = 100L;
        int loopB = 5;
        long sleepB = 120L;
        this.threadTest.start();
        ConsumerThread consumerA = new ConsumerThread(this.threadTest, loopA, sleepA);
        ConsumerThread consumerB = new ConsumerThread(this.threadTest, loopB, sleepB);
        consumerA.start();
        consumerB.start();
        try {
            consumerA.join((long)loopA * sleepA * 2L);
            consumerB.join((long)loopB * sleepB * 2L);
        }
        catch (InterruptedException e) {
            Assert.fail((String)"Task submission failure");
        }
    }

    @Before
    public void setUp() throws Exception {
        this.threadTest = new AbstractThread(0L, null){

            protected boolean doTask(String action) {
                boolean result = false;
                result = !action.equals("SHUTDOWN");
                return result;
            }
        };
    }

    protected static class ConsumerThread
    extends Thread {
        private AbstractThread abstractThread;
        private long sleepTime;
        private int loop;

        public ConsumerThread(AbstractThread abstractThread, int loop, long sleepTime) {
            this.abstractThread = abstractThread;
            this.loop = loop;
            this.sleepTime = sleepTime;
        }

        @Override
        public void run() {
            for (int i = 0; i < this.loop; ++i) {
                try {
                    this.abstractThread.execute("" + i);
                }
                catch (JBIException e1) {
                    e1.printStackTrace();
                }
                try {
                    Thread.sleep(this.sleepTime);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

