/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.container.thread;

import javax.jbi.JBIException;
import javax.jbi.component.Bootstrap;
import javax.jbi.component.InstallationContext;
import javax.management.ObjectName;
import org.easymock.classextension.EasyMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.ow2.petals.container.thread.BootstrapThread;
import org.ow2.petals.jbi.component.context.InstallationContextImpl;

public class InstallerThreadTest {
    private BootstrapThread installerThread;
    private InstallationContext installContextMock;
    private Bootstrap bootstrapMock;

    @Test
    public void testCleanUp() throws JBIException {
        this.installerThread.start();
        EasyMock.reset((Object)this.bootstrapMock);
        this.bootstrapMock.cleanUp();
        org.easymock.EasyMock.expectLastCall();
        EasyMock.replay((Object)this.bootstrapMock);
        try {
            this.installerThread.cleanUp();
        }
        catch (JBIException e) {
            Assert.fail((String)e.getMessage());
        }
        EasyMock.verify((Object)this.bootstrapMock);
    }

    @Test
    public void testInit() throws JBIException {
        this.installerThread.start();
        this.installContextMock = (InstallationContext)EasyMock.createMock(InstallationContextImpl.class);
        EasyMock.reset((Object)this.bootstrapMock);
        this.bootstrapMock.init(this.installContextMock);
        org.easymock.EasyMock.expectLastCall();
        EasyMock.replay((Object)this.bootstrapMock);
        try {
            this.installerThread.init(this.installContextMock);
        }
        catch (JBIException e) {
            Assert.fail((String)e.getMessage());
        }
        EasyMock.verify((Object)this.bootstrapMock);
    }

    @Test
    public void testOnInstall() throws JBIException {
        this.installerThread.start();
        EasyMock.reset((Object)this.bootstrapMock);
        this.bootstrapMock.onInstall();
        org.easymock.EasyMock.expectLastCall();
        EasyMock.replay((Object)this.bootstrapMock);
        try {
            this.installerThread.onInstall();
        }
        catch (JBIException e) {
            Assert.fail((String)e.getMessage());
        }
        EasyMock.verify((Object)this.bootstrapMock);
    }

    @Test
    public void testOnUninstall() throws JBIException {
        this.installerThread.start();
        EasyMock.reset((Object)this.bootstrapMock);
        this.bootstrapMock.onUninstall();
        org.easymock.EasyMock.expectLastCall();
        EasyMock.replay((Object)this.bootstrapMock);
        try {
            this.installerThread.onUninstall();
        }
        catch (JBIException e) {
            Assert.fail((String)e.getMessage());
        }
        EasyMock.verify((Object)this.bootstrapMock);
    }

    @Test
    public void testGetExtensionMBeanName() {
        this.installerThread.start();
        EasyMock.reset((Object)this.bootstrapMock);
        ObjectName objectName = (ObjectName)EasyMock.createMock(ObjectName.class);
        org.easymock.EasyMock.expect((Object)this.bootstrapMock.getExtensionMBeanName()).andReturn((Object)objectName);
        EasyMock.replay((Object)this.bootstrapMock);
        ObjectName oName = this.installerThread.getExtensionMBeanName();
        Assert.assertEquals((Object)oName, (Object)objectName);
        EasyMock.verify((Object)this.bootstrapMock);
    }

    @Test
    public void testMultipleCalls() {
        this.installerThread.start();
        try {
            this.installerThread.onInstall();
            this.installerThread.onUninstall();
            this.installerThread.onInstall();
            this.installerThread.onUninstall();
            this.installerThread.onInstall();
            this.installerThread.onUninstall();
        }
        catch (JBIException e) {
            e.printStackTrace();
        }
    }

    @Before
    public void setUp() throws Exception {
        this.bootstrapMock = (Bootstrap)EasyMock.createMock(Bootstrap.class);
        this.installerThread = new BootstrapThread("installermock", this.bootstrapMock, 0L, null);
    }
}

