/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.management.task.download.jetty.server;

import javax.servlet.Servlet;
import org.apache.log4j.Logger;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.ContextHandlerCollection;
import org.mortbay.jetty.nio.SelectChannelConnector;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.ServletHolder;
import org.mortbay.thread.BoundedThreadPool;
import org.mortbay.thread.ThreadPool;
import org.ow2.petals.jbi.management.task.download.jetty.server.ServerConfig;
import org.ow2.petals.jbi.management.task.download.jetty.servlets.CorrectContentTypeServlet;
import org.ow2.petals.jbi.management.task.download.jetty.servlets.CorrectContentTypeWithCharsetServlet;
import org.ow2.petals.jbi.management.task.download.jetty.servlets.WithoutContentTypeServlet;
import org.ow2.petals.jbi.management.task.download.jetty.servlets.WrongContentTypeServlet;

public class JettyServer {
    private Logger log = Logger.getLogger(JettyServer.class);
    public static final int HEADER_BUFFER_SIZE = 16384;
    private static JettyServer instance = null;
    private CorrectContentTypeServlet correctContentTypeServlet;
    private CorrectContentTypeWithCharsetServlet correctContentTypeWithCharsetServlet;
    private WrongContentTypeServlet wrongContentTypeSevlet;
    private WithoutContentTypeServlet withoutContentTypeSevlet;
    private ServerConfig config;
    private Server server;
    private BoundedThreadPool threadPool;

    private JettyServer(ServerConfig config) {
        this.config = config;
        this.threadPool = new BoundedThreadPool();
        this.threadPool.setName("SoapJettyThreadPool");
        this.threadPool.setMaxThreads(this.config.getJettyThreadMaxPoolSize());
        this.threadPool.setMinThreads(this.config.getJettyThreadMinPoolSize());
        SelectChannelConnector nioConnector = new SelectChannelConnector();
        nioConnector.setPort(this.config.getPort());
        if (this.config.isRestrict()) {
            nioConnector.setHost(this.config.getHost());
        }
        nioConnector.setHeaderBufferSize(16384);
        nioConnector.setStatsOn(false);
        nioConnector.setAcceptors(this.config.getJettyAcceptors());
        this.server = new Server();
        this.server.setConnectors(new Connector[]{nioConnector});
        this.server.setThreadPool((ThreadPool)this.threadPool);
    }

    public void createAllServlets() {
        ContextHandlerCollection contexts = new ContextHandlerCollection();
        this.server.setHandler((Handler)contexts);
        this.createCorrectContentTypeServlet(contexts);
        this.createCorrectContentTypeWithCharsetServlet(contexts);
        this.createWrongContentTypeServlet(contexts);
        this.createWithoutContentTypeServlet(contexts);
    }

    private void createWithoutContentTypeServlet(ContextHandlerCollection contexts) {
        Context withoutContentTypeContext = new Context((HandlerContainer)contexts, "/WithoutContentType", 1);
        this.withoutContentTypeSevlet = new WithoutContentTypeServlet();
        ServletHolder repositoryServletHolder = new ServletHolder((Servlet)this.withoutContentTypeSevlet);
        repositoryServletHolder.setName("WithoutContentTypeSevlet");
        repositoryServletHolder.setInitOrder(3);
        withoutContentTypeContext.addServlet(repositoryServletHolder, "/");
    }

    private void createWrongContentTypeServlet(ContextHandlerCollection contexts) {
        Context wrongContentTypeContext = new Context((HandlerContainer)contexts, "/WrongContentType", 1);
        this.wrongContentTypeSevlet = new WrongContentTypeServlet();
        ServletHolder repositoryServletHolder = new ServletHolder((Servlet)this.wrongContentTypeSevlet);
        repositoryServletHolder.setName("WrongContentTypeSevlet");
        repositoryServletHolder.setInitOrder(1);
        wrongContentTypeContext.addServlet(repositoryServletHolder, "/");
    }

    private void createCorrectContentTypeServlet(ContextHandlerCollection contexts) {
        Context repositoryContext = new Context((HandlerContainer)contexts, "/CorrectContentType", 1);
        this.correctContentTypeServlet = new CorrectContentTypeServlet();
        ServletHolder correctContentTypeServletHolder = new ServletHolder((Servlet)this.correctContentTypeServlet);
        correctContentTypeServletHolder.setName("CorrectContentTypeServlet");
        correctContentTypeServletHolder.setInitOrder(2);
        repositoryContext.addServlet(correctContentTypeServletHolder, "/");
    }

    private void createCorrectContentTypeWithCharsetServlet(ContextHandlerCollection contexts) {
        Context repositoryContext = new Context((HandlerContainer)contexts, "/CorrectContentTypeWithCharset", 1);
        this.correctContentTypeWithCharsetServlet = new CorrectContentTypeWithCharsetServlet();
        ServletHolder correctContentTypeWithCharsetServletHolder = new ServletHolder((Servlet)this.correctContentTypeWithCharsetServlet);
        correctContentTypeWithCharsetServletHolder.setName("CorrectContentTypeWithCharsetServlet");
        correctContentTypeWithCharsetServletHolder.setInitOrder(2);
        repositoryContext.addServlet(correctContentTypeWithCharsetServletHolder, "/");
    }

    public static JettyServer getInstance() throws Exception {
        if (instance == null) {
            instance = new JettyServer(new ServerConfig());
            instance.createAllServlets();
            instance.start();
        }
        if (!instance.getServer().isStarted()) {
            instance.createAllServlets();
            instance.start();
        }
        return instance;
    }

    public void start() throws Exception {
        this.log.info((Object)"Starting Jetty server...");
        this.log.info((Object)("Host : " + (!this.config.isRestrict() ? "*" : this.config.getHost() + " (restricted)") + " / Port : " + this.config.getPort() + " / Jetty Max poolsize : " + this.config.getJettyThreadMaxPoolSize() + " / Jetty Min poolsize : " + this.config.getJettyThreadMinPoolSize() + " / Jetty Acceptors size : " + this.config.getJettyAcceptors()));
        this.server.start();
    }

    public void stop() throws Exception {
        this.log.info((Object)"Stop and kill Jetty server...");
        for (Handler h : this.server.getHandlers()) {
            this.server.removeHandler(h);
        }
        for (Handler h : this.server.getChildHandlers()) {
            this.server.removeHandler(h);
        }
        this.server.stop();
    }

    public Server getServer() {
        return this.server;
    }

    public ServerConfig getConfig() {
        return this.config;
    }
}

