/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.petals.jbi.management.task.installation.install.component;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.logging.Logger;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.junit.Assert;
import org.junit.Test;
import org.ow2.petals.jbi.management.Context;
import org.ow2.petals.jbi.management.ManagementException;
import org.ow2.petals.jbi.management.task.installation.install.component.CreateComponentRepositoryTask;
import org.ow2.petals.system.repository.RepositoryService;
import org.ow2.petals.system.repository.exception.ComponentAlreadyExistsException;
import org.ow2.petals.util.AbstractMavenTest;
import org.ow2.petals.util.LoggingUtil;

public class CreateComponentRepositoryTaskTest
extends AbstractMavenTest {
    private static final String COMPONENT_NAME = "myComponentName";
    private static final String ARCHIVE_FILE_NAME = "archive.zip";
    final LoggingUtil log = new LoggingUtil(Logger.getLogger(CreateComponentRepositoryTaskTest.class.getName()));

    @Test
    public void testCreateComponentRepositoryTask_000() throws Exception {
        RepositoryService repositorySvc = (RepositoryService)EasyMock.createMock(RepositoryService.class);
        EasyMock.expect((Object)repositorySvc.addComponent(COMPONENT_NAME, new File(this.testResourcesDir, ARCHIVE_FILE_NAME))).andReturn((Object)new File(this.targetDir, ARCHIVE_FILE_NAME));
        EasyMock.replay((Object[])new Object[]{repositorySvc});
        Context ctx = new Context();
        ctx.setEntityName(COMPONENT_NAME);
        ctx.setUnzipRoot(new File(this.testResourcesDir, ARCHIVE_FILE_NAME));
        CreateComponentRepositoryTask task = new CreateComponentRepositoryTask(this.log, repositorySvc);
        task.execute(ctx);
        TestCase.assertEquals((Object)new File(this.targetDir, ARCHIVE_FILE_NAME).toURI().toURL(), (Object)ctx.getInstallUrl());
        EasyMock.verify((Object[])new Object[]{repositorySvc});
    }

    @Test
    public void testCreateComponentRepositoryTask_001() throws Exception {
        RepositoryService repositorySvc = (RepositoryService)EasyMock.createMock(RepositoryService.class);
        EasyMock.expect((Object)repositorySvc.addComponent(COMPONENT_NAME, new File(this.testResourcesDir, ARCHIVE_FILE_NAME))).andReturn((Object)new File(this.targetDir, ARCHIVE_FILE_NAME));
        EasyMock.expect((Object)repositorySvc.addComponent(COMPONENT_NAME, new File(this.testResourcesDir, ARCHIVE_FILE_NAME))).andThrow((Throwable)new ComponentAlreadyExistsException(COMPONENT_NAME, (Throwable)new Exception()));
        EasyMock.replay((Object[])new Object[]{repositorySvc});
        Context ctx1 = new Context();
        ctx1.setEntityName(COMPONENT_NAME);
        ctx1.setUnzipRoot(new File(this.testResourcesDir, ARCHIVE_FILE_NAME));
        CreateComponentRepositoryTask task1 = new CreateComponentRepositoryTask(this.log, repositorySvc);
        task1.execute(ctx1);
        TestCase.assertEquals((Object)new File(this.targetDir, ARCHIVE_FILE_NAME).toURI().toURL(), (Object)ctx1.getInstallUrl());
        try {
            Context ctx2 = new Context();
            ctx2.setEntityName(COMPONENT_NAME);
            ctx2.setUnzipRoot(new File(this.testResourcesDir, ARCHIVE_FILE_NAME));
            CreateComponentRepositoryTask task2 = new CreateComponentRepositoryTask(this.log, repositorySvc);
            task2.execute(ctx2);
            Assert.fail((String)("The exception " + ComponentAlreadyExistsException.class.getName() + " is not raised."));
        }
        catch (ManagementException e) {
            TestCase.assertTrue((String)(ComponentAlreadyExistsException.class.getName() + " is not the cause of ManagementException"), (boolean)(e.getCause() instanceof ComponentAlreadyExistsException));
        }
        EasyMock.verify((Object[])new Object[]{repositorySvc});
    }

    @Test
    public void testCreateComponentRepositoryTask_002() throws Exception {
        RepositoryService repositorySvc = (RepositoryService)EasyMock.createMock(RepositoryService.class);
        EasyMock.expect((Object)repositorySvc.addComponent(COMPONENT_NAME, new File(this.testResourcesDir, ARCHIVE_FILE_NAME))).andReturn((Object)new File(this.targetDir, ARCHIVE_FILE_NAME));
        repositorySvc.removeComponent(COMPONENT_NAME);
        EasyMock.replay((Object[])new Object[]{repositorySvc});
        Context ctx = new Context();
        ctx.setEntityName(COMPONENT_NAME);
        ctx.setUnzipRoot(new File(this.testResourcesDir, ARCHIVE_FILE_NAME));
        CreateComponentRepositoryTask task = new CreateComponentRepositoryTask(this.log, repositorySvc);
        task.execute(ctx);
        TestCase.assertEquals((Object)new File(this.targetDir, ARCHIVE_FILE_NAME).toURI().toURL(), (Object)ctx.getInstallUrl());
        task.undo(ctx);
        EasyMock.verify((Object[])new Object[]{repositorySvc});
    }

    @Test
    public void testCreateComponentStateHolderTask_003() throws Exception {
        RepositoryService repositorySvc = (RepositoryService)EasyMock.createMock(RepositoryService.class);
        repositorySvc.removeComponent(COMPONENT_NAME);
        EasyMock.expectLastCall().andThrow((Throwable)new FileNotFoundException());
        EasyMock.replay((Object[])new Object[]{repositorySvc});
        Context ctx = new Context();
        ctx.setEntityName(COMPONENT_NAME);
        ctx.setUnzipRoot(new File(this.testResourcesDir, ARCHIVE_FILE_NAME));
        CreateComponentRepositoryTask task = new CreateComponentRepositoryTask(this.log, repositorySvc);
        task.undo(ctx);
        EasyMock.verify((Object[])new Object[]{repositorySvc});
    }
}

